/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.cache.impl.HashStringRedisCacheGroup;
import com.hand.hap.cache.impl.RoleResourceCache;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.FunctionResource;
import com.hand.hap.function.dto.MenuItem;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.mapper.FunctionMapper;
import com.hand.hap.function.mapper.FunctionResourceMapper;
import com.hand.hap.function.mapper.RoleFunctionMapper;
import com.hand.hap.function.service.IFunctionService;
import com.hand.hap.function.service.IResourceService;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.system.dto.Language;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class FunctionServiceImpl
extends BaseServiceImpl<Function>
implements IFunctionService {
    @Autowired
    private FunctionMapper functionMapper;
    @Autowired
    private FunctionResourceMapper functionResourceMapper;
    @Autowired
    private RoleFunctionMapper roleFunctionMapper;
    @Autowired
    private IResourceService resourceService;
    @Autowired
    private IRoleFunctionService roleFunctionService;
    @Autowired
    @Qualifier(value="functionCache")
    private HashStringRedisCacheGroup<Function> functionCache;
    @Autowired
    private RoleResourceCache roleResourceCache;
    @Autowired
    private ILanguageProvider languageProvider;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Function insertSelective(IRequest request, Function function) {
        if (function == null) {
            return null;
        }
        super.insertSelective(request, function);
        this.reloadFunctionCache(function.getFunctionId());
        return function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadFunctionCache(Long functionId) {
        IRequest old = RequestHelper.getCurrentRequest();
        try {
            IRequest iRequest = RequestHelper.newEmptyRequest();
            RequestHelper.setCurrentRequest(iRequest);
            for (Language language : this.languageProvider.getSupportedLanguages()) {
                iRequest.setLocale(language.getLangCode());
                Function f = (Function)this.functionMapper.selectByPrimaryKey(functionId);
                if (f == null) continue;
                ((HashStringRedisCache)this.functionCache.getGroup(language.getLangCode())).setValue(functionId.toString(), f);
            }
        }
        finally {
            RequestHelper.setCurrentRequest(old);
        }
    }

    private void deleteFunctionCache(Long functionId) {
        for (Language language : this.languageProvider.getSupportedLanguages()) {
            ((HashStringRedisCache)this.functionCache.getGroup(language.getLangCode())).remove(functionId.toString());
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Function updateByPrimaryKey(IRequest request, Function function) {
        if (function == null) {
            return null;
        }
        Criteria criteria = new Criteria(function);
        criteria.update("functionCode", "moduleCode", "functionName", "functionIcon", "functionSequence", "functionDescription", "parentFunctionId", "resourceId");
        super.updateByPrimaryKeyOptions(request, function, criteria);
        this.reloadFunctionCache(function.getFunctionId());
        return function;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Function selectByPrimaryKey(IRequest request, Function function) {
        if (function.getFunctionId() == null) {
            return null;
        }
        Function result = (Function)this.functionMapper.selectByPrimaryKey(function.getFunctionId());
        return result;
    }

    private int deleteByPrimaryKey(IRequest request, Function function) {
        if (function.getFunctionId() == null) {
            return 0;
        }
        List<Function> childs = this.functionMapper.selectFunctionByParentId(function.getFunctionId());
        childs.forEach(t -> this.deleteByPrimaryKey(request, (Function)t));
        this.functionResourceMapper.deleteByFunctionId(function.getFunctionId());
        this.roleFunctionMapper.deleteByFunctionId(function.getFunctionId());
        int updateCount = this.functionMapper.deleteByPrimaryKey(function);
        this.checkOvn(updateCount, function);
        this.deleteFunctionCache(function.getFunctionId());
        return updateCount;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<Function> batchUpdate(IRequest request, List<Function> functions) {
        if (functions == null || functions.isEmpty()) {
            return functions;
        }
        for (Function function : functions) {
            if (function.getFunctionId() == null) {
                ((IFunctionService)this.self()).insertSelective(request, function);
                continue;
            }
            ((IFunctionService)this.self()).updateByPrimaryKey(request, function);
        }
        return functions;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int batchDelete(IRequest request, List<Function> functions) {
        int result = 0;
        if (functions == null || functions.isEmpty()) {
            return result;
        }
        for (Function function : functions) {
            this.deleteByPrimaryKey(request, function);
            ++result;
        }
        return result;
    }

    @Override
    public List<Function> selectFunction(IRequest request, Function function, int page, int pageSize) {
        Criteria criteria = new Criteria(function);
        criteria.unSelect("parentFunctionName");
        return super.selectOptions(request, function, criteria, page, pageSize);
    }

    @Override
    public List<Resource> selectExitResourcesByFunction(IRequest request, Function function, Resource resource, int page, int pageSize) {
        if (function == null || function.getFunctionId() == null) {
            return null;
        }
        PageHelper.startPage(page, pageSize);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("function", function);
        params.put("resource", resource);
        return this.functionMapper.selectExistsResourcesByFunction(params);
    }

    @Override
    public List<Resource> selectNotExitResourcesByFunction(IRequest request, Function function, Resource resource, int page, int pageSize) {
        if (function == null || function.getFunctionId() == null) {
            return null;
        }
        PageHelper.startPage(page, pageSize);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("function", function);
        params.put("resource", resource);
        return this.functionMapper.selectNotExistsResourcesByFunction(params);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public Function updateFunctionResources(IRequest request, Function function, List<Resource> resources) {
        if (function != null) {
            if (resources != null && !resources.isEmpty()) {
                for (Resource resource : resources) {
                    if ("add".equals(resource.get__status())) {
                        FunctionResource functionResource = new FunctionResource();
                        functionResource.setResourceId(resource.getResourceId());
                        functionResource.setFunctionId(function.getFunctionId());
                        functionResource.setObjectVersionNumber(1L);
                        functionResource.setCreatedBy(request.getUserId());
                        functionResource.setCreationDate(new Date());
                        functionResource.setLastUpdateDate(new Date());
                        functionResource.setLastUpdatedBy(request.getUserId());
                        this.functionResourceMapper.insertSelective(functionResource);
                        continue;
                    }
                    if (!"delete".equals(resource.get__status())) continue;
                    this.functionResourceMapper.deleteFunctionResource(function.getFunctionId(), resource.getResourceId());
                }
            }
            this.roleResourceCache.reload();
        }
        return function;
    }

    @Override
    public List<MenuItem> selectAllMenus(IRequest request) {
        List<Function> functions = this.functionCache.getGroupAll(request.getLocale());
        MenuItem root = this.castFunctionsToMenuItem(functions);
        return root.getChildren();
    }

    private MenuItem castFunctionsToMenuItem(List<Function> functions) {
        MenuItem root = new MenuItem();
        ArrayList<MenuItem> children = new ArrayList<MenuItem>();
        root.setChildren(children);
        HashMap<Long, Function> idToFuncMap = new HashMap<Long, Function>();
        for (Function f : functions) {
            idToFuncMap.put(f.getFunctionId(), f);
        }
        HashMap<Long, MenuItem> map = new HashMap<Long, MenuItem>();
        Iterator<Function> iterator = functions.iterator();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            if (idToFuncMap.get(function.getParentFunctionId()) != null) continue;
            MenuItem rootChild = this.createMenuItem(function);
            map.put(function.getFunctionId(), rootChild);
            children.add(rootChild);
            iterator.remove();
        }
        this.processFunctions(map, functions);
        map.forEach((k, v) -> {
            if (v.getChildren() != null) {
                Collections.sort(v.getChildren());
            }
        });
        Collections.sort(children);
        return root;
    }

    private void processFunctions(Map<Long, MenuItem> map, List<Function> functions) {
        Iterator<Function> iterator = functions.iterator();
        int size0 = functions.size();
        while (iterator.hasNext()) {
            Function function = iterator.next();
            MenuItem parent = map.get(function.getParentFunctionId());
            if (parent == null) continue;
            MenuItem item = this.createMenuItem(function);
            map.put(function.getFunctionId(), item);
            List<MenuItem> children = parent.getChildren();
            if (children == null) {
                children = new ArrayList<MenuItem>();
                parent.setChildren(children);
            }
            children.add(item);
            iterator.remove();
        }
        if (functions.size() == size0) {
            this.detectCircle(functions);
        }
        if (!functions.isEmpty()) {
            this.processFunctions(map, functions);
        }
    }

    private void detectCircle(List<Function> functions) {
        HashMap<Long, Function> tmpFuncMap = new HashMap<Long, Function>();
        for (Function f : functions) {
            tmpFuncMap.put(f.getFunctionId(), f);
        }
        ArrayList<Function> tmpList = new ArrayList<Function>();
        for (Function f : functions) {
            tmpList.clear();
            Function f0 = f;
            tmpList.add(f0);
            while (f0.getParentFunctionId() != null) {
                int idx = tmpList.indexOf(f0 = (Function)tmpFuncMap.get(f0.getParentFunctionId()));
                if (idx != -1) {
                    tmpList.add(f0);
                    String msg = tmpList.stream().skip(idx).map(a -> a.getFunctionName() + "(" + a.getFunctionId() + ")").reduce((a, b) -> a + "-->" + b).get();
                    throw new RuntimeException(msg);
                }
                tmpList.add(f0);
            }
        }
    }

    @Override
    public List<MenuItem> selectRoleFunctions(IRequest request) {
        Long[] roleIds;
        List<Function> functions = this.functionCache.getGroupAll(request.getLocale());
        HashSet<Long> ids = new HashSet<Long>();
        for (Long roleId : roleIds = request.getAllRoleId()) {
            Long[] fids = this.roleFunctionService.getRoleFunctionById(roleId);
            if (fids == null) continue;
            ids.addAll(Arrays.asList(fids));
        }
        HashMap<Long, Function> funcMap = new HashMap<Long, Function>();
        if (functions != null) {
            for (Function f : functions) {
                funcMap.put(f.getFunctionId(), f);
            }
        }
        HashMap<Long, MenuItem> menuMap = new HashMap<Long, MenuItem>();
        if (ids != null) {
            for (Long fId : ids) {
                this.createMenuRecursive(menuMap, funcMap, fId);
            }
        }
        ArrayList<MenuItem> itemList = new ArrayList<MenuItem>();
        menuMap.forEach((k, v) -> {
            if (v.getParent() == null) {
                itemList.add((MenuItem)v);
            }
            if (v.getChildren() != null) {
                Collections.sort(v.getChildren());
            }
        });
        Collections.sort(itemList);
        return itemList;
    }

    private MenuItem createMenuRecursive(Map<Long, MenuItem> menuMap, Map<Long, Function> funcMap, Long funcId) {
        MenuItem mi = menuMap.get(funcId);
        if (mi == null) {
            MenuItem miParent;
            Function func = funcMap.get(funcId);
            if (func == null) {
                return null;
            }
            mi = this.createMenuItem(func);
            menuMap.put(funcId, mi);
            Long parentId = func.getParentFunctionId();
            if (parentId != null && (miParent = this.createMenuRecursive(menuMap, funcMap, parentId)) != null) {
                List<MenuItem> children = miParent.getChildren();
                if (children == null) {
                    children = new ArrayList<MenuItem>();
                    miParent.setChildren(children);
                }
                mi.setParent(miParent);
                children.add(mi);
            }
        }
        return mi;
    }

    private MenuItem createMenuItem(Function function) {
        Resource resource;
        MenuItem menu = new MenuItem();
        menu.setText(function.getFunctionName());
        menu.setIcon(function.getFunctionIcon());
        menu.setFunctionCode(function.getFunctionCode());
        if (function.getResourceId() != null && (resource = this.resourceService.selectResourceById(function.getResourceId())) != null) {
            menu.setUrl(resource.getUrl());
        }
        menu.setId(function.getFunctionId());
        menu.setScore(function.getFunctionSequence());
        return menu;
    }
}

