/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.hand.hap.core.annotation.Children;
import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.annotation.MultiLanguageField;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.mybatis.annotation.Condition;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.JoinCache;
import com.hand.hap.mybatis.common.query.JoinColumn;
import com.hand.hap.mybatis.common.query.JoinOn;
import com.hand.hap.mybatis.common.query.JoinTable;
import com.hand.hap.mybatis.common.query.Where;
import com.hand.hap.system.dto.BaseDTO;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.criteria.JoinType;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@MultiLanguage
@Table(name="sys_function_b")
public class Function
extends BaseDTO {
    public static final String FIELD_FUNCTION_ID = "functionId";
    public static final String FIELD_FUNCTION_CODE = "functionCode";
    public static final String FIELD_FUNCTION_DESCRIPTION = "functionDescription";
    public static final String FIELD_FUNCTION_ICON = "functionIcon";
    public static final String FIELD_FUNCTION_SEQUENCE = "functionSequence";
    public static final String FIELD_FUNCTION_NAME = "functionName";
    public static final String FIELD_MODULE_CODE = "moduleCode";
    public static final String FIELD_PARENT_FUNCTION_ID = "parentFunctionId";
    public static final String FIELD_PARENT_FUNCTION_NAME = "parentFunctionName";
    public static final String FIELD_RESOURCE_NAME = "resourceName";
    public static final String FIELD_RESOURCE_ID = "resourceId";
    public static final String FIELD_RESOURCES = "resources";
    public static final String FIELD_TYPE = "type";
    @Id
    @Column
    @Where
    @GeneratedValue(generator="IDENTITY")
    private Long functionId;
    @Column
    @OrderBy(value="ASC")
    @Where
    @NotEmpty
    @Length(max=30)
    private String functionCode;
    @Column
    @MultiLanguageField
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Length(max=240)
    private String functionDescription;
    @Column
    @Condition(exclude=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Length(max=100)
    private String functionIcon;
    @Column
    @Condition(exclude=true)
    private Long functionSequence;
    @Column
    @MultiLanguageField
    @Where(comparison=Comparison.LIKE)
    @Length(max=150)
    private String functionName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Transient
    @Length(max=10)
    private String lang;
    @Column
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Where
    @Length(max=30)
    private String moduleCode;
    @Column
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Where
    private Long parentFunctionId;
    @Transient
    @JoinCache(joinKey="parentFunctionId", joinColumn="functionName", cacheName="function")
    @Length(max=150)
    private String parentFunctionName;
    @Transient
    @JoinColumn(joinName="resourceJoin", field="name")
    @Length(max=40)
    private String resourceName;
    @Column
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JoinTable(name="resourceJoin", joinMultiLanguageTable=true, target=Resource.class, type=JoinType.LEFT, on={@JoinOn(joinField="resourceId"), @JoinOn(joinField="lang", joinExpression="#{request.locale,jdbcType=VARCHAR,javaType=java.lang.String}")})
    @Where
    private Long resourceId;
    @Children
    @Transient
    private List<Resource> resources;
    @Column
    private String type = "PAGE";

    public String getFunctionCode() {
        return this.functionCode;
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    public String getFunctionIcon() {
        return this.functionIcon;
    }

    public Long getFunctionId() {
        return this.functionId;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getLang() {
        return this.lang;
    }

    public String getModuleCode() {
        return this.moduleCode;
    }

    public Long getParentFunctionId() {
        return this.parentFunctionId;
    }

    public Long getResourceId() {
        return this.resourceId;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getType() {
        return this.type;
    }

    public void setFunctionCode(String functionCode) {
        this.functionCode = StringUtils.trim((String)functionCode);
    }

    public void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription;
    }

    public void setFunctionIcon(String functionIcon) {
        this.functionIcon = functionIcon;
    }

    public void setFunctionId(Long functionId) {
        this.functionId = functionId;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setLang(String sourceLang) {
        this.lang = sourceLang;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = StringUtils.trim((String)moduleCode);
    }

    public void setParentFunctionId(Long parentFunctionId) {
        this.parentFunctionId = parentFunctionId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getFunctionSequence() {
        return this.functionSequence;
    }

    public void setFunctionSequence(Long functionSequence) {
        this.functionSequence = functionSequence;
    }

    public String getParentFunctionName() {
        return this.parentFunctionName;
    }

    public void setParentFunctionName(String parentFunctionName) {
        this.parentFunctionName = parentFunctionName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
}

