/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.service.impl;

import com.hand.hap.flexfield.dto.FlexRule;
import com.hand.hap.flexfield.dto.FlexRuleDetail;
import com.hand.hap.flexfield.dto.FlexRuleField;
import com.hand.hap.flexfield.dto.WarpFlexRuleField;
import com.hand.hap.flexfield.mapper.FlexRuleDetailMapper;
import com.hand.hap.flexfield.mapper.FlexRuleFieldMapper;
import com.hand.hap.flexfield.mapper.FlexRuleMapper;
import com.hand.hap.flexfield.service.IFlexRuleService;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class FlexRuleServiceImpl
extends BaseServiceImpl<FlexRule>
implements IFlexRuleService {
    @Autowired
    FlexRuleMapper ruleMapper;
    @Autowired
    FlexRuleFieldMapper fieldMapper;
    @Autowired
    FlexRuleDetailMapper flexRuleDetailMapper;
    @Autowired
    FlexRuleFieldMapper FlexRuleFieldMapper;

    @Override
    public ResponseData matchingRule(String ruleSetCode, Set<Map> model) {
        FlexRule flexRule;
        List<FlexRule> flexRules = this.ruleMapper.matchingRule(ruleSetCode);
        if (!flexRules.isEmpty() && null != (flexRule = flexRules.stream().filter(flexRule1 -> this.matching((FlexRule)flexRule1, model)).max(Comparator.comparing(flexRule2 -> flexRule2.getFlexRuleDetailList().size())).orElseGet(() -> new FlexRule())).getRuleId()) {
            FlexRuleField flexRuleField = new FlexRuleField();
            flexRuleField.setRuleId(flexRule.getRuleId());
            return new ResponseData(this.classify(this.fieldMapper.queryFlexField(flexRuleField)));
        }
        return new ResponseData();
    }

    @Override
    public void deleteRule(List<FlexRule> flexRules) {
        for (FlexRule flexRule : flexRules) {
            FlexRuleDetail ruleDetail = new FlexRuleDetail();
            FlexRuleField ruleField = new FlexRuleField();
            ruleField.setRuleId(flexRule.getRuleId());
            ruleDetail.setRuleId(flexRule.getRuleId());
            this.flexRuleDetailMapper.delete(ruleDetail);
            this.FlexRuleFieldMapper.delete(ruleField);
            int updateCount = this.ruleMapper.delete(flexRule);
            this.checkOvn(updateCount, flexRule);
        }
    }

    private List<WarpFlexRuleField> classify(List<FlexRuleField> flexRuleFields) {
        ArrayList<WarpFlexRuleField> warpFlexRuleFields = new ArrayList<WarpFlexRuleField>();
        flexRuleFields.stream().collect(Collectors.groupingBy(FlexRuleField::getFieldColumnNumber)).forEach((k, v) -> warpFlexRuleFields.add(WarpFlexRuleField.warpFlexRuleField(v)));
        return warpFlexRuleFields;
    }

    public static void setPrompt(WarpFlexRuleField warpFlexRuleField, Locale locale, MessageSource messageSource) {
        warpFlexRuleField.getFields().forEach(v -> FlexRuleServiceImpl.doSetPrompt(v, locale, messageSource));
    }

    private static void doSetPrompt(FlexRuleField flexRuleField, Locale locale, MessageSource messageSource) {
        JSONObject josn = JSONObject.fromObject((Object)flexRuleField.getFieldType());
        String name = messageSource.getMessage(josn.get("labelName").toString(), null, locale);
        if (!StringUtil.isEmpty((CharSequence)name)) {
            josn.put((Object)"labelName", (Object)name);
            flexRuleField.setFieldType(josn.toString());
        }
    }

    private boolean matching(FlexRule flexRule, Set<Map> model) {
        boolean result = false;
        List<FlexRuleDetail> flexRuleDetails = flexRule.getFlexRuleDetailList();
        int sameNumber = 0;
        block0: for (FlexRuleDetail flexRuleDetail1 : flexRuleDetails) {
            for (Map.Entry entry : model) {
                if (!flexRuleDetail1.getFieldValue().equalsIgnoreCase(entry.getValue().toString()) || !flexRuleDetail1.getFieldName().equalsIgnoreCase(entry.getKey().toString())) continue;
                ++sameNumber;
                continue block0;
            }
        }
        if (sameNumber == flexRuleDetails.size()) {
            result = true;
        }
        return result;
    }
}

