/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.ui.Component;
import java.util.List;
import java.util.Map;

public class InputField
extends Component {
    public static final String PROPERTITY_CULTURE = "culture";
    private static final String PROPERTITY_VALUE = "value";
    private static final String PROPERTITY_CLEAR_BUTTON = "clearButton";
    private static final String PROPERTITY_PLACEHOLDER = "placeholder";
    private static final String PROPERTITY_CHANGE = "change";
    private static final String PROPERTITY_BIND = "bind";
    private static final String PROPERTITY_BINDMODEL = "bindModel";
    private static final String PROPERTITY_REQUIRED = "required";
    private static final String PROPERTITY_VALIDATION_MESSAGE = "validationMessage";
    private static final String PROPERTITY_NAME = "name";
    private static final String PROPERTITY_DATA_MSG = "dataMsg";

    public Object getValue() throws Exception {
        return this.getPrototype().get(PROPERTITY_VALUE);
    }

    public void setValue(Object value) {
        this.setPropertity(PROPERTITY_VALUE, value);
    }

    public Boolean getClearButton() {
        return this.getPrototype().getBoolean(PROPERTITY_CLEAR_BUTTON);
    }

    public void setClearButton(Boolean clearButton) {
        this.setPropertity(PROPERTITY_CLEAR_BUTTON, clearButton);
    }

    public String getPlaceholder() {
        return this.getPrototype().getString(PROPERTITY_PLACEHOLDER);
    }

    public void setPlaceholder(String placeholder) {
        this.setPropertity(PROPERTITY_PLACEHOLDER, placeholder);
    }

    public String getCulture() {
        return this.getPrototype().getString(PROPERTITY_CULTURE);
    }

    public void setCulture(String culture) {
        this.setPropertity(PROPERTITY_CULTURE, culture);
    }

    public String getBind() {
        String bind = this.getPrototype().getString(PROPERTITY_BIND);
        return bind;
    }

    public void setBind(String required) {
        this.setPropertity(PROPERTITY_BIND, required);
    }

    public String getBindModel() {
        String bindModel = this.getPrototype().getString(PROPERTITY_BINDMODEL);
        if (bindModel != null) {
            ReferenceType rt = new ReferenceType(bindModel);
            return rt.getReference();
        }
        return null;
    }

    public void setBindModel(ReferenceType bindModel) {
        this.setPropertity(PROPERTITY_BINDMODEL, bindModel);
    }

    public String getValidationMessage() {
        if (this.getPrototype().getString(PROPERTITY_VALIDATION_MESSAGE) != null) {
            return "validationMessage=\"" + this.getPrototype().getString(PROPERTITY_VALIDATION_MESSAGE) + "\"";
        }
        return "";
    }

    public void setValidationMessage(String validationMessage) {
        this.setPropertity(PROPERTITY_VALIDATION_MESSAGE, validationMessage);
    }

    public String getName() {
        return this.getPrototype().getString(PROPERTITY_NAME);
    }

    public void setName(String name) {
        this.setPropertity(PROPERTITY_NAME, name);
    }

    public String getRequired() {
        Boolean required = this.getPrototype().getBoolean(PROPERTITY_REQUIRED);
        if (required != null && required.booleanValue()) {
            return PROPERTITY_REQUIRED;
        }
        return "";
    }

    public void setRequired(Boolean bind) {
        this.setPropertity(PROPERTITY_REQUIRED, bind);
    }

    public String getDataMsg() {
        List<XMap> item;
        String dataMsg = "";
        XMap validation = this.getPrototype().getChild("validation");
        if (validation != null && (item = validation.getChildren()) != null) {
            for (XMap map : item) {
                String name = map.getString(PROPERTITY_NAME);
                String msg = map.getString("msg");
                if (name == null || msg == null) continue;
                dataMsg = dataMsg + "data-" + name + "-msg =\"" + msg + "\"  ";
            }
        }
        return dataMsg;
    }

    public void setDataMsg(List<Map<String, String>> msg) {
        XMap view = this.getPrototype().getChild("validation");
        if (view == null) {
            view = this.getPrototype().createChild("h", "http://www.hand-china.com/hap", "validation");
        }
        if (msg != null) {
            for (Map<String, String> m : msg) {
                XMap item = view.createChild("h", "http://www.hand-china.com/hap", "item");
                if (m == null) continue;
                for (Map.Entry<String, String> entry : m.entrySet()) {
                    item.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    protected void initPrototype(XMap view) {
        super.initPrototype(view);
        this.addEvent(PROPERTITY_CHANGE);
    }

    @Override
    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_BIND, this.getBind());
        context.put(PROPERTITY_BINDMODEL, this.getBindModel());
        context.put(PROPERTITY_REQUIRED, this.getRequired());
        context.put(PROPERTITY_NAME, this.getName());
        context.put(PROPERTITY_DATA_MSG, this.getDataMsg());
        context.put(PROPERTITY_VALIDATION_MESSAGE, this.getValidationMessage());
        context.put(PROPERTITY_PLACEHOLDER, this.getPlaceholder());
        context.addJsonConfig(PROPERTITY_CULTURE, this.getCulture());
        context.addJsonConfig(PROPERTITY_PLACEHOLDER, this.getPlaceholder());
        context.addJsonConfig(PROPERTITY_VALUE, this.getValue());
        context.addJsonConfig(PROPERTITY_CLEAR_BUTTON, this.getClearButton());
    }
}

