/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.impl.ResourceCustomizationCache;
import com.hand.hap.core.web.DefaultFreeMarkerView;
import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.ViewTagFactory;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.XMapHandler;
import com.hand.hap.core.web.view.XMapParser;
import com.hand.hap.core.web.view.XMapUtil;
import com.hand.hap.function.dto.Resource;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.xmlpull.v1.XmlPullParserException;

public class ScreenView
extends DefaultFreeMarkerView {
    protected final Logger logger = LoggerFactory.getLogger(ScreenView.class);
    private ViewTagFactory screenTagFactory;
    private CacheManager cacheManager;
    private Cache<Resource> resourceCache;
    private ResourceCustomizationCache resourceCustomizationCache;

    public ViewTagFactory getScreenTagFactory() {
        return this.screenTagFactory;
    }

    protected void initServletContext(ServletContext servletContext) throws BeansException {
        super.initServletContext(servletContext);
        this.screenTagFactory = (ViewTagFactory)this.autodetectScreenTagFactory(ViewTagFactory.class);
        this.cacheManager = (CacheManager)this.autodetectScreenTagFactory(CacheManager.class);
        this.resourceCustomizationCache = (ResourceCustomizationCache)this.autodetectScreenTagFactory(ResourceCustomizationCache.class);
        this.resourceCache = this.cacheManager.getCache("resource_url");
    }

    protected Object autodetectScreenTagFactory(Class<?> clazz) throws BeansException {
        try {
            return BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), clazz, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single ViewTagFactory bean in this web application context!", (Throwable)ex);
        }
    }

    protected void processTemplate(Template template, Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SimpleHash fmModel = this.buildTemplateModel(model, request, response);
        try (PrintWriter writer = response.getWriter();){
            String str;
            String[] mergeList;
            XMap xmap = this.parseView(fmModel, template);
            Resource resource = this.resourceCache.getValue(template.getName());
            if (resource != null && (mergeList = this.resourceCustomizationCache.getValue(resource.getResourceId().toString())) != null) {
                List<String> list = Arrays.asList(mergeList);
                this.mergeView(xmap, list, request, fmModel);
            }
            if ((str = ScreenBuilder.build(xmap, new ViewContext(this.getConfiguration(), this.getScreenTagFactory(), fmModel.toMap(), request, response))) != null) {
                ((Writer)writer).write(str);
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Failed to parse screen template for URL [" + this.getUrl() + "]", (Throwable)e);
            }
            throw e;
        }
    }

    private XMap parseView(SimpleHash model, Template template) throws IOException, TemplateException, XmlPullParserException {
        XMap xmap = null;
        try (StringWriter out = new StringWriter();){
            template.process((Object)model, (Writer)out);
            out.flush();
            xmap = XMapParser.parseReader(new StringReader(out.toString()), new XMapHandler());
        }
        return xmap;
    }

    private void mergeView(XMap source, List<String> list, HttpServletRequest request, SimpleHash model) {
        if (list != null) {
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            for (String url : list) {
                try {
                    Template t = this.getTemplate(url, locale);
                    XMap view = this.parseView(model, t);
                    XMapUtil.merge(source, view);
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) continue;
                    this.logger.error("Failed to merge view " + url, (Throwable)e);
                }
            }
        }
    }

    protected void doRender(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Rendering FreeMarker template [{}] in FreeMarkerView '{}'", (Object)this.getUrl(), (Object)this.getBeanName());
        }
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        this.processTemplate(this.getTemplate(locale), model, request, response);
    }
}

