/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.json;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.hand.hap.core.util.TimeZoneUtil;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeDeserializer
extends JsonDeserializer<Date>
implements ContextualDeserializer {
    private static Logger log = LoggerFactory.getLogger(DateTimeDeserializer.class);
    private String pattern = "yyyy-MM-dd";

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String str = jp.getText();
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        try {
            SimpleDateFormat sb = new SimpleDateFormat(this.getPattern());
            sb.setTimeZone(TimeZoneUtil.getTimeZone());
            return sb.parse(str);
        }
        catch (ParseException e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        DateTimeDeserializer deserializer = new DateTimeDeserializer();
        if (property != null) {
            JsonFormat jf = (JsonFormat)property.getMember().getAnnotation(JsonFormat.class);
            if (jf != null && !"".equals(jf.pattern())) {
                deserializer.setPattern(jf.pattern());
            }
        } else {
            deserializer.setPattern("yyyy-MM-dd HH:mm:ss");
        }
        return deserializer;
    }
}

