/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.interceptor;

import com.hand.hap.security.TokenUtils;
import com.hand.hap.system.dto.BaseDTO;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class SecurityTokenInterceptor
implements Interceptor {
    public static final ThreadLocal<String> LOCAL_SECURITY_KEY = new ThreadLocal();

    public Object intercept(Invocation invocation) throws Throwable {
        Object domain;
        Object result = invocation.proceed();
        String securityKey = LOCAL_SECURITY_KEY.get();
        if (securityKey == null) {
            return result;
        }
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (mappedStatement.getSqlCommandType() == SqlCommandType.SELECT) {
            if (result instanceof List) {
                Logger logger;
                for (Object o : (List)result) {
                    if (!(o instanceof BaseDTO)) continue;
                    TokenUtils.generateAndSetToken(securityKey, (BaseDTO)o);
                }
                if (((List)result).size() == 1 && mappedStatement.getId().endsWith("_COUNT") && (logger = LoggerFactory.getLogger((String)mappedStatement.getId())).isDebugEnabled()) {
                    logger.debug("count: " + ((List)result).get(0));
                }
            }
        } else if (mappedStatement.getSqlCommandType() == SqlCommandType.INSERT && (domain = invocation.getArgs()[1]) instanceof BaseDTO) {
            TokenUtils.generateAndSetToken(securityKey, (BaseDTO)domain);
        }
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }
}

