/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.interceptor;

import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.interceptor.SecurityTokenInterceptor;
import com.hand.hap.core.util.TimeZoneUtil;
import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.security.TokenUtils;
import java.util.TimeZone;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MonitorInterceptor
extends HandlerInterceptorAdapter {
    private static ThreadLocal<Long> holder = new ThreadLocal();

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String tz;
        RequestHelper.clearCurrentRequest();
        this.fillMDC(request);
        holder.set(System.currentTimeMillis());
        HttpSession session = request.getSession(false);
        if (session != null && StringUtils.isNotEmpty((String)(tz = (String)session.getAttribute("timeZone")))) {
            TimeZoneUtil.setTimeZone(TimeZone.getTimeZone(tz));
        }
        SecurityTokenInterceptor.LOCAL_SECURITY_KEY.set(TokenUtils.getSecurityKey(session));
        HapInvokeInfo.REST_INVOKE_HANDLER.set(handler);
        return true;
    }

    private void fillMDC(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            Long userId = (Long)session.getAttribute("userId");
            String uuid = UUID.randomUUID().toString().replace("-", "");
            if (userId != null) {
                MDC.put((String)"userId", (String)userId.toString());
            }
            MDC.put((String)"requestId", (String)uuid);
            MDC.put((String)"sessionId", (String)session.getId());
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        HandlerMethod method;
        Logger logger;
        long end = System.currentTimeMillis();
        if (handler instanceof HandlerMethod && (logger = LoggerFactory.getLogger((Class)(method = (HandlerMethod)handler).getBeanType())).isTraceEnabled()) {
            logger.trace(method.toString() + " - " + (end - holder.get()) + " ms");
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
    }
}

