/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.interceptor;

import com.hand.hap.audit.mapper.AuditMapper;
import com.hand.hap.audit.service.IAuditTableNameProvider;
import com.hand.hap.audit.service.impl.DefaultAuditTableNameProvider;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.ITlTableNameProvider;
import com.hand.hap.core.annotation.AuditEnabled;
import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.components.ApplicationContextHelper;
import com.hand.hap.core.impl.DefaultTlTableNameProvider;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.web.view.IDGenerator;
import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import com.hand.hap.system.dto.Language;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class AuditInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(AuditInterceptor.class);
    public static final ThreadLocal<String> LOCAL_AUDIT_SESSION = new ThreadLocal();
    private ILanguageProvider languageProvider;
    private ApplicationContext beanFactory;
    private AuditMapper templateMapper;
    private ITlTableNameProvider tableNameProvider = DefaultTlTableNameProvider.getInstance();
    @Autowired(required=false)
    private IAuditTableNameProvider auditTableNameProvider = DefaultAuditTableNameProvider.instance;

    public Object intercept(Invocation invocation) throws Throwable {
        Object result;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        Object param = invocation.getArgs()[1];
        Object targetDto = null;
        if (param instanceof Map) {
            Map temp = (Map)param;
            for (Map.Entry entry : temp.entrySet()) {
                if (!((String)entry.getKey()).equals("dto")) continue;
                targetDto = temp.get("dto");
                break;
            }
        } else {
            targetDto = param;
        }
        if (null == targetDto || !(targetDto instanceof BaseDTO)) {
            return invocation.proceed();
        }
        if (targetDto.getClass().getAnnotation(AuditEnabled.class) == null) {
            return invocation.proceed();
        }
        BaseDTO dto = (BaseDTO)targetDto;
        SqlCommandType type = mappedStatement.getSqlCommandType();
        switch (type) {
            case INSERT: 
            case UPDATE: {
                result = invocation.proceed();
                this.doAudit(dto, type.name(), mappedStatement, param, invocation);
                break;
            }
            case DELETE: {
                this.doAudit(dto, type.name(), mappedStatement, param, invocation);
                result = invocation.proceed();
                break;
            }
            default: {
                result = invocation.proceed();
            }
        }
        return result;
    }

    public Map<String, Object> getWhereClause(MappedStatement mappedStatement, Object param, String tableName) throws JSQLParserException, NoSuchFieldException {
        BoundSql boundSql = mappedStatement.getBoundSql(param);
        String whereExpression = this.getWhereExpression(boundSql.getSql());
        int whereParamNum = this.getWhereParamNum(whereExpression);
        List parameterMappings = boundSql.getParameterMappings();
        Configuration configuration = mappedStatement.getConfiguration();
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        String WHERE_CLAUSE = whereExpression;
        HashMap<String, Object> wps = new HashMap<String, Object>();
        this.logger.debug("Audit 0001:" + parameterMappings.size());
        this.logger.debug("Audit 0002:" + whereParamNum);
        if (parameterMappings != null) {
            if (whereParamNum == 0) {
                Field[] fields;
                String majorField = null;
                Object value = null;
                for (Field f : fields = param.getClass().getDeclaredFields()) {
                    f.setAccessible(true);
                    if (null == f.getAnnotation(Id.class)) continue;
                    majorField = f.getName();
                    try {
                        value = f.get(param);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                wps.put(majorField, value);
                wps.put("WHERE_CLAUSE", "B." + DTOClassInfo.camelToUnderLine(majorField) + "=#{" + majorField + "}");
                return wps;
            }
            for (int i = parameterMappings.size() - whereParamNum; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (param == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(param.getClass())) {
                    value = param;
                } else {
                    MetaObject typeHandler = configuration.newMetaObject(param);
                    value = typeHandler.getValue(propertyName);
                }
                if (propertyName.startsWith("dto.")) {
                    propertyName = propertyName.replaceFirst("dto.", "");
                }
                wps.put(propertyName, value);
                WHERE_CLAUSE = WHERE_CLAUSE.replaceFirst("\\?", "#{" + propertyName + "}");
            }
            Object[] wheres = WHERE_CLAUSE.split(" AND ");
            int j = wheres.length;
            for (int i = 0; i < j; ++i) {
                wheres[i] = "B." + (String)wheres[i] + "";
            }
            wps.put("WHERE_CLAUSE", StringUtils.join((Object[])wheres, (String)" AND "));
        }
        return wps;
    }

    public int getWhereParamNum(String whereExpression) {
        String[] params = whereExpression.trim().split(" ");
        int count = 0;
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].startsWith("?")) continue;
            ++count;
        }
        return count;
    }

    public String getWhereExpression(String sql) throws JSQLParserException {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Insert) {
            return "";
        }
        Object where_expression = null;
        if (statement instanceof Update) {
            Update updateStatement = (Update)statement;
            where_expression = updateStatement.getWhere();
        } else if (statement instanceof Delete) {
            Delete deleteStatement = (Delete)statement;
            where_expression = deleteStatement.getWhere();
        }
        return where_expression.toString();
    }

    private void doAudit(BaseDTO dto, String type, MappedStatement mappedStatement, Object param, Invocation invocation) throws Exception {
        Class<?> clazz;
        Table tbl;
        ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
        if (null == this.beanFactory) {
            this.beanFactory = applicationContext;
        }
        if (null == this.languageProvider) {
            this.languageProvider = (ILanguageProvider)applicationContext.getBean(ILanguageProvider.class);
        }
        if ((tbl = this.checkTable(clazz = dto.getClass())) == null) {
            return;
        }
        String tableName = tbl.name();
        EntityField[] ids = DTOClassInfo.getIdFields(clazz);
        if (ids.length == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Can not get PrimaryKey(s) of dto class:" + clazz);
            }
            return;
        }
        AuditInterceptor.generateAndSetAuditSessionId();
        String asid = LOCAL_AUDIT_SESSION.get();
        AuditEnabled auditEnabled = clazz.getAnnotation(AuditEnabled.class);
        String auditTableName = StringUtils.defaultIfEmpty((String)auditEnabled.auditTable(), (String)this.auditTableNameProvider.getAuditTableName(tableName));
        boolean hasExtensionAttribute = true;
        if (clazz.isAnnotationPresent(ExtensionAttribute.class)) {
            ExtensionAttribute extensionAttribute = clazz.getAnnotation(ExtensionAttribute.class);
            hasExtensionAttribute = !extensionAttribute.disable();
        }
        ArrayList<String> cols = new ArrayList<String>();
        for (Map.Entry<String, EntityField> entry : DTOClassInfo.getEntityFields(clazz).entrySet()) {
            if (entry.getValue().isAnnotationPresent(Transient.class) || entry.getValue().getName().startsWith("attribute") && !hasExtensionAttribute) continue;
            cols.add(DTOClassInfo.getColumnName(entry.getValue()));
        }
        EntityField[] entityFields = DTOClassInfo.getMultiLanguageFields(clazz);
        MultiLanguage multiLanguageTable = clazz.getAnnotation(MultiLanguage.class);
        IRequest request = RequestHelper.getCurrentRequest(true);
        String localLanguage = request.getLocale();
        ArrayList<String> dynFields = new ArrayList<String>();
        boolean isTrue = false;
        int j = cols.size();
        for (int i = 0; i < j; ++i) {
            String s = (String)cols.get(i);
            isTrue = false;
            if (null != multiLanguageTable) {
                for (EntityField entityField : entityFields) {
                    if (!DTOClassInfo.camelToUnderLine(entityField.getName()).toLowerCase().equals(s.toLowerCase())) continue;
                    isTrue = true;
                    s = "TL." + s;
                    break;
                }
            }
            dynFields.add(isTrue ? s : "B." + s);
        }
        HashMap<String, Object> auditParam = new HashMap<String, Object>();
        String majorField = "";
        Field[] fields = clazz.getDeclaredFields();
        for (Field f : fields) {
            if (null == f.getAnnotation(Id.class)) continue;
            majorField = DTOClassInfo.camelToUnderLine(f.getName());
            break;
        }
        Map<String, Object> wps = this.getWhereClause(mappedStatement, param, tableName);
        for (Map.Entry<String, Object> entry : wps.entrySet()) {
            auditParam.put(entry.getKey(), entry.getValue());
        }
        String tableTlName = this.tableNameProvider.getTlTableName(tableName);
        auditParam.put("_AUDIT_TABLE_NAME", auditTableName);
        auditParam.put("_COLS", cols);
        auditParam.put("_AUDIT_TYPE", type);
        auditParam.put("_AUDIT_SESSION_ID", asid);
        auditParam.put("_AUDIT_ID", IDGenerator.getInstance().generate());
        auditParam.put("_MAJOR_FIELD", majorField);
        auditParam.put("_DYN_FIELDS", dynFields);
        auditParam.put("_BASE_TABLE_NAME", tableName);
        auditParam.put("_TABLE_NAME", tableTlName);
        String clause = wps.get("WHERE_CLAUSE").toString();
        auditParam.put("_WHERE_CLAUSE", clause);
        HashSet<String> languageCodes = new HashSet<String>();
        Map<String, Map<String, String>> map = dto.get__tls();
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            Map<String, String> m = entry.getValue();
            for (Map.Entry<String, String> item : m.entrySet()) {
                languageCodes.add(item.getKey());
            }
        }
        HashMap<String, String> updateParam = new HashMap<String, String>();
        updateParam.put("_TABLE_NAME", tableName + "_a");
        updateParam.put("_MAJOR_FIELD", majorField);
        String id = auditParam.get(majorField.replace("_", "")).toString();
        updateParam.put("_ID", id);
        List<Language> languages = this.languageProvider.getSupportedLanguages();
        if (null != multiLanguageTable) {
            for (Language language : languages) {
                auditParam.put("_AUDIT_ID", IDGenerator.getInstance().generate());
                auditParam.put("_IS_MULTI_LANGUAGE", multiLanguageTable != null);
                auditParam.put("_LANGUAGE", language.getLangCode());
                updateParam.put("_LANG", language.getLangCode());
                this.doDB(auditParam, updateParam);
            }
        } else {
            auditParam.put("_LANGUAGE", localLanguage);
            auditParam.put("_IS_MULTI_LANGUAGE", multiLanguageTable != null);
            updateParam.put("_LANG", localLanguage);
            this.doDB(auditParam, updateParam);
        }
    }

    private Table checkTable(Class clazz) {
        Table tbl = clazz.getAnnotation(Table.class);
        if (tbl == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("@Table not found on dto class:" + clazz);
            }
            return null;
        }
        String tableName = tbl.name();
        if (StringUtils.isBlank((String)tableName)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Can not get tableName of dto class:" + clazz);
            }
            return null;
        }
        return tbl;
    }

    protected AuditMapper getTemplateMapper() {
        if (this.templateMapper == null) {
            this.templateMapper = (AuditMapper)this.beanFactory.getBean(AuditMapper.class);
        }
        return this.templateMapper;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public static String generateAndSetAuditSessionId() {
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        LOCAL_AUDIT_SESSION.set(id);
        return id;
    }

    public static void clearAuditSessionId() {
        LOCAL_AUDIT_SESSION.remove();
    }

    private void doDB(Map insertMap, Map updateMap) throws SQLException {
        try {
            AuditMapper mapper = this.getTemplateMapper();
            int count2 = mapper.auditUpdateTag(updateMap);
            int count = mapper.auditInsert(insertMap);
            if (count == 1 && count2 >= 1) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("audit result:1, normal.");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("audit result:{}, abnormal.", (Object)count);
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("audit error:" + e.getMessage());
            }
            throw e;
        }
    }
}

