/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.impl;

import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import com.hand.hap.system.dto.Language;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

@TopicMonitor(channel={"cache.language", "topic:cache:reloaded"})
public class LanguageProviderImpl
implements ILanguageProvider,
InitializingBean,
IMessageConsumer<String> {
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;
    private List<Language> languages = Collections.emptyList();
    private Logger logger = LoggerFactory.getLogger(LanguageProviderImpl.class);

    @Override
    public List<Language> getSupportedLanguages() {
        return this.languages;
    }

    public void afterPropertiesSet() throws Exception {
        this.reload();
    }

    private void reload() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        jdbcTemplate.afterPropertiesSet();
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Language.class);
        this.languages = jdbcTemplate.query("select * from sys_lang_b", (RowMapper)rowMapper);
    }

    @Override
    public void onMessage(String message, String pattern) {
        if ("cache.language".equals(pattern)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("language changed, now reload cache.", (Object)message);
            }
            this.reload();
        } else if ("topic:cache:reloaded".equals(pattern) && "language".equals(message)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("language reloaded, now reload cache.");
            }
            this.reload();
        }
    }
}

