/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.i18n;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.cache.impl.HashStringRedisCacheGroup;
import com.hand.hap.system.dto.Prompt;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractMessageSource;

public class CacheMessageSource
extends AbstractMessageSource {
    private static final String SINGLE_QUOTES_REPLACEMENT = "&#39;";
    private static final String DOUBLE_QUOTES_REPLACEMENT = "&#34;";
    @Autowired
    private ApplicationContext applicationContext;
    private HashStringRedisCacheGroup<Prompt> promptCache;

    public CacheMessageSource() {
        this.reload();
    }

    public void reload() {
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        return this.createMessageFormat(this.resolveCodeWithoutArguments(code, locale), locale);
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        if (this.promptCache == null) {
            this.promptCache = (HashStringRedisCacheGroup)this.applicationContext.getBean("promptCache");
        }
        String code2 = StringUtils.lowerCase((String)code);
        Prompt prompt = (Prompt)((HashStringRedisCache)this.promptCache.getGroup(locale.toString())).getValue(code2);
        if (prompt == null) {
            return code;
        }
        return this.replaceQuote(prompt.getDescription());
    }

    private String replaceQuote(String str) {
        int idx = -1;
        char c = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c != '\'' && c != '\"') continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            return str;
        }
        StrBuilder sb = new StrBuilder(str.length() + 32);
        sb.append(str.substring(0, idx));
        if (c == '\"') {
            sb.append(DOUBLE_QUOTES_REPLACEMENT);
        } else {
            sb.append(SINGLE_QUOTES_REPLACEMENT);
        }
        for (int i = idx + 1; i < str.length(); ++i) {
            c = str.charAt(i);
            if (c == '\"') {
                sb.append(DOUBLE_QUOTES_REPLACEMENT);
                continue;
            }
            if (c == '\'') {
                sb.append(SINGLE_QUOTES_REPLACEMENT);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

