/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.ResourcePropertySource;

public class CustomApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static Logger LOG = LoggerFactory.getLogger(CustomApplicationContextInitializer.class);
    private static final String PROPERTIES_FILE_LOAD_ORDER_FIRST = "FIRST";
    private static final String PROPERTIES_FILE_LOAD_ORDER_LAST = "LAST";
    private static final String PROPERTIES_FILE_LOAD_ORDER_DEFAULT = "FIRST";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        String propertiesFilePath = environment.getProperty("propertiesFile");
        String propertiesFileLoadOrder = this.getPropertiesFileLoadOrderFrom(environment);
        try {
            MutablePropertySources propertySources = environment.getPropertySources();
            if (propertiesFileLoadOrder.equalsIgnoreCase(PROPERTIES_FILE_LOAD_ORDER_LAST)) {
                propertySources.addLast((PropertySource)new ResourcePropertySource(propertiesFilePath));
            } else {
                propertySources.addFirst((PropertySource)new ResourcePropertySource(propertiesFilePath));
            }
            LOG.info(String.format("'%s' loaded into ApplicationContext with load order '%s'", propertiesFilePath, propertiesFileLoadOrder));
        }
        catch (IOException ioException) {
            LOG.info(String.format("Could not load '%s' with load order '%s' while trying to load into the ApplicationContext", propertiesFilePath, propertiesFileLoadOrder));
        }
    }

    private String getPropertiesFileLoadOrderFrom(ConfigurableEnvironment environment) {
        String propertiesFileLoadOrder = environment.getProperty("propertiesFileLoadOrder");
        if (propertiesFileLoadOrder == null || propertiesFileLoadOrder.isEmpty()) {
            return "FIRST";
        }
        if (!propertiesFileLoadOrder.equalsIgnoreCase("FIRST") && !propertiesFileLoadOrder.equalsIgnoreCase(PROPERTIES_FILE_LOAD_ORDER_LAST)) {
            return "FIRST";
        }
        return null;
    }
}

