/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.code.rule.dto.CodeRulesHeader;
import com.hand.hap.code.rule.dto.CodeRulesLine;
import com.hand.hap.code.rule.mapper.CodeRulesHeaderMapper;
import com.hand.hap.code.rule.mapper.CodeRulesLineMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SysCodeRuleCache
extends HashStringRedisCache<List<CodeRulesLine>> {
    private static final String SEQ_CATEGORY = "seq:";
    private final Logger logger = LoggerFactory.getLogger(SysCodeRuleCache.class);
    private String allEnableRuleSqlid = CodeRulesHeaderMapper.class.getName() + ".select";
    private String codeRuleLineSqlId = CodeRulesLineMapper.class.getName() + ".select";
    @Autowired
    private CodeRulesLineMapper lineMapper;

    @Override
    public void init() {
        this.strSerializer = this.getRedisTemplate().getStringSerializer();
        this.initLoad();
    }

    public void removeSeq(String key) {
        this.getRedisTemplate().execute(connection -> connection.del((byte[][])new byte[][]{this.strSerializer.serialize((Object)this.getSeqFullKey(key))}));
    }

    public void reload(CodeRulesHeader header) {
        block14: {
            CodeRulesLine lineCondition = new CodeRulesLine();
            lineCondition.setHeaderId(header.getHeaderId());
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                List lines = sqlSession.selectList(this.codeRuleLineSqlId, (Object)lineCondition);
                lines.sort((a, b) -> a.getFieldSequence().compareTo(b.getFieldSequence()));
                this.setValue(header.getRuleCode(), lines);
                lines.forEach(line -> {
                    if ("SEQUENCE".equalsIgnoreCase(line.getFiledType())) {
                        line.setRuleCode(header.getRuleCode());
                        byte[] fullSeqKey = this.strSerializer.serialize((Object)this.getSeqFullKey(header.getRuleCode()));
                        this.loadSeq((CodeRulesLine)line, fullSeqKey);
                    }
                });
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("reolad code rule cache exception: ", (Throwable)e);
            }
        }
    }

    public void updateLine(CodeRulesLine line) {
        List lines = (List)this.getValue(line.getRuleCode());
        int index = 0;
        for (CodeRulesLine t : lines) {
            if (t.getLineId().equals(line.getLineId())) {
                lines.set(index, line);
            }
            ++index;
        }
        this.setValue(line.getRuleCode(), lines);
    }

    public Long incr(CodeRulesLine line) {
        byte[] fullSeqKey = this.strSerializer.serialize((Object)this.getSeqFullKey(line.getRuleCode()));
        this.loadSeq(line, fullSeqKey);
        return (Long)this.getRedisTemplate().execute(connection -> connection.incr(fullSeqKey));
    }

    public Long decr(CodeRulesLine line) {
        byte[] fullSeqKey = this.strSerializer.serialize((Object)this.getSeqFullKey(line.getRuleCode()));
        return (Long)this.getRedisTemplate().execute(connection -> connection.decr(fullSeqKey));
    }

    public void reset(CodeRulesLine line) {
        Long resetValue = line.getStartValue() - 1L;
        byte[] fullSeqKey = this.strSerializer.serialize((Object)this.getSeqFullKey(line.getRuleCode()));
        byte[] seqValue = this.strSerializer.serialize((Object)resetValue.toString());
        this.getRedisTemplate().execute(connection -> {
            connection.set(fullSeqKey, seqValue);
            return null;
        });
        line.setCurrentValue(resetValue + 100L);
        line.setResetDate(new Date());
        this.lineMapper.updateByPrimaryKey(line);
        this.updateLine(line);
    }

    @Override
    protected void initLoad() {
        block18: {
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                CodeRulesHeader condition = new CodeRulesHeader();
                condition.setEnableFlag("Y");
                List enableRules = sqlSession.selectList(this.allEnableRuleSqlid, (Object)condition);
                CodeRulesLine lineCondition = new CodeRulesLine();
                if (enableRules == null) {
                    return;
                }
                enableRules.forEach(t -> {
                    lineCondition.setHeaderId(t.getHeaderId());
                    List lines = sqlSession.selectList(this.codeRuleLineSqlId, (Object)lineCondition);
                    lines.sort((a, b) -> a.getFieldSequence().compareTo(b.getFieldSequence()));
                    this.setValue(t.getRuleCode(), lines);
                    lines.forEach(line -> {
                        if ("SEQUENCE".equalsIgnoreCase(line.getFiledType())) {
                            line.setRuleCode(t.getRuleCode());
                            byte[] fullSeqKey = this.strSerializer.serialize((Object)this.getSeqFullKey(t.getRuleCode()));
                            this.loadSeq((CodeRulesLine)line, fullSeqKey);
                        }
                    });
                });
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block18;
                this.logger.error("init code rule cache exception: ", (Throwable)e);
            }
        }
    }

    @Override
    protected List<CodeRulesLine> stringToObject(String value) {
        try {
            return (List)this.getObjectMapper().readValue(value, this.getObjectMapper().getTypeFactory().constructParametricType(ArrayList.class, new Class[]{CodeRulesLine.class}));
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("invalid value: " + value);
            }
            throw new RuntimeException(e);
        }
    }

    protected String getSeqFullKey(String key) {
        return this.getCategory() + ":" + this.getName() + ":" + key;
    }

    private void loadSeq(CodeRulesLine line, byte[] fullSeqKey) {
        boolean exists = (Boolean)this.getRedisTemplate().execute(connection -> connection.exists(fullSeqKey));
        if (!exists) {
            if (line.getCurrentValue() == null) {
                line.setCurrentValue(line.getStartValue() - 1L);
            }
            this.getRedisTemplate().execute(connection -> {
                connection.set(fullSeqKey, this.strSerializer.serialize((Object)line.getCurrentValue().toString()));
                return null;
            });
            line.setCurrentValue(line.getCurrentValue() + 100L);
            this.lineMapper.updateByPrimaryKeySelective(line);
            this.updateLine(line);
        }
    }
}

