/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheGroup;
import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.cache.impl.RedisCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class HashStringRedisCacheGroup<T>
extends RedisCache<T>
implements CacheGroup<T> {
    private Logger logger = LoggerFactory.getLogger(HashStringRedisCacheGroup.class);
    private ObjectMapper objectMapper;
    private String[] groupField;
    private Map<String, HashStringRedisCache<T>> groupMap = new HashMap<String, HashStringRedisCache<T>>();

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getGroupValue(Object bean) {
        String key;
        block2: {
            key = null;
            try {
                key = HashStringRedisCacheGroup.getKeyOfBean(bean, this.groupField);
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return key;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public T getValue(String key) {
        return null;
    }

    @Override
    public void setValue(String key, T value) {
        String group = this.getGroupValue(value);
        Cache cache = this.getGroup(group);
        ((HashStringRedisCache)cache).setValue(key, value);
    }

    public List<T> getGroupAll(String group) {
        return ((HashStringRedisCache)this.getGroup(group)).getAll();
    }

    @Override
    public void remove(String key) {
    }

    @Override
    public HashStringRedisCache<T> getGroup(String group) {
        HashStringRedisCache<T> hashStringRedisCache = this.groupMap.get(group);
        if (hashStringRedisCache == null) {
            hashStringRedisCache = new HashStringRedisCache();
            hashStringRedisCache.setRedisTemplate(this.getRedisTemplate());
            hashStringRedisCache.setObjectMapper(this.objectMapper);
            hashStringRedisCache.setName(this.getName() + ":" + group);
            hashStringRedisCache.setCategory(this.getCategory());
            hashStringRedisCache.setKeyField(this.getKeyField());
            hashStringRedisCache.setType(this.getType());
            hashStringRedisCache.init();
            this.groupMap.put(group, hashStringRedisCache);
        }
        return hashStringRedisCache;
    }

    @Override
    public T getValue(String group, String key) {
        return ((HashStringRedisCache)this.getGroup(group)).getValue(key);
    }

    @Override
    public void setValue(String group, String key, T value) {
        ((HashStringRedisCache)this.getGroup(group)).setValue(key, value);
    }

    @Override
    public void remove(String group, String key) {
        ((HashStringRedisCache)this.getGroup(group)).remove(key);
    }

    @Override
    public void removeGroup(String group) {
        ((HashStringRedisCache)this.getGroup(group)).clear();
    }

    @Override
    protected void handleRow(Object row) {
        String group = this.getGroupValue(row);
        Cache cache = this.getGroup(group);
        ((HashStringRedisCache)cache).handleRow(row);
    }

    @Override
    public void clear() {
        super.clear();
        this.groupMap.forEach((k, v) -> v.clear());
    }
}

