/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.security.permission.dto.DataPermissionRule;
import com.hand.hap.security.permission.dto.DataPermissionRuleAssign;
import com.hand.hap.security.permission.dto.DataPermissionRuleDetail;
import com.hand.hap.security.permission.mapper.DataPermissionRuleAssignMapper;
import com.hand.hap.security.permission.mapper.DataPermissionRuleDetailMapper;
import com.hand.hap.security.permission.mapper.DataPermissionRuleMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPermissionRuleCache
extends HashStringRedisCache<Map> {
    private String ruleSql = DataPermissionRuleMapper.class.getName() + ".selectAll";
    private String ruleDetailSql = DataPermissionRuleDetailMapper.class.getName() + ".selectAll";
    private String ruleAssignSql = DataPermissionRuleAssignMapper.class.getName() + ".selectAll";
    private Logger logger = LoggerFactory.getLogger(DataPermissionRuleCache.class);

    @Override
    public void init() {
        this.setType(Map.class);
        this.strSerializer = this.getRedisTemplate().getStringSerializer();
        this.initLoad();
    }

    @Override
    public Map getValue(String key) {
        return (Map)super.getValue(key);
    }

    @Override
    public void setValue(String key, Map dataMaskRule) {
        super.setValue(key, dataMaskRule);
    }

    @Override
    protected void initLoad() {
        HashMap<String, DataPermissionRuleAssign> tempDataPermissionRuleAssign;
        HashMap<String, DataPermissionRuleDetail> tempDataPermissionRuleDetail;
        HashMap<String, DataPermissionRule> tempDataPermissionRule;
        HashMap<String, Map> ruleMaps;
        block14: {
            ruleMaps = new HashMap<String, Map>();
            tempDataPermissionRule = new HashMap<String, DataPermissionRule>();
            tempDataPermissionRuleDetail = new HashMap<String, DataPermissionRuleDetail>();
            tempDataPermissionRuleAssign = new HashMap<String, DataPermissionRuleAssign>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.ruleSql, resultContext -> {
                    DataPermissionRule dataMaskRuleManage = (DataPermissionRule)resultContext.getResultObject();
                    tempDataPermissionRule.put(dataMaskRuleManage.getRuleId().toString(), dataMaskRuleManage);
                });
                sqlSession.select(this.ruleDetailSql, resultContext -> {
                    DataPermissionRuleDetail dataMaskRuleManageDetail = (DataPermissionRuleDetail)resultContext.getResultObject();
                    tempDataPermissionRuleDetail.put(dataMaskRuleManageDetail.getDetailId().toString(), dataMaskRuleManageDetail);
                });
                sqlSession.select(this.ruleAssignSql, resultContext -> {
                    DataPermissionRuleAssign dataMaskRuleAssign = (DataPermissionRuleAssign)resultContext.getResultObject();
                    tempDataPermissionRuleAssign.put(dataMaskRuleAssign.getAssignId().toString(), dataMaskRuleAssign);
                });
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("init lov cache error:", e);
            }
        }
        this.doCreateCacheMap(tempDataPermissionRule, tempDataPermissionRuleDetail, tempDataPermissionRuleAssign, ruleMaps);
        ruleMaps.forEach((k, v) -> this.setValue((String)k, (Map)v));
    }

    public void doCreateCacheMap(Map<String, DataPermissionRule> tempDataMaskRuleManage, Map<String, DataPermissionRuleDetail> tempDataMaskRuleManageDetail, Map<String, DataPermissionRuleAssign> tempDataMaskRuleAssign, Map<String, Map> ruleMaps) {
        if (tempDataMaskRuleAssign.size() == 0) {
            tempDataMaskRuleManage.forEach((k, v) -> ruleMaps.put(v.getRuleId().toString(), new HashMap()));
            return;
        }
        tempDataMaskRuleAssign.forEach((k, v) -> {
            DataPermissionRuleDetail detail = (DataPermissionRuleDetail)tempDataMaskRuleManageDetail.get(v.getDetailId().toString());
            DataPermissionRule rule = (DataPermissionRule)tempDataMaskRuleManage.get(detail.getRuleId().toString());
            Map ruleDetail = Optional.ofNullable(ruleMaps.get(rule.getRuleId().toString())).orElseGet(() -> {
                HashMap map = new HashMap();
                ruleMaps.put(rule.getRuleId().toString(), map);
                return map;
            });
            Map rangeMask = Optional.ofNullable(ruleDetail.get(v.getAssignField().toString())).orElseGet(() -> {
                HashMap map = new HashMap();
                ruleDetail.put(v.getAssignField(), map);
                return map;
            });
            Set ruleAssign = Optional.ofNullable(rangeMask.get(v.getAssignFieldValue().toString())).orElseGet(() -> {
                HashSet set = new HashSet();
                rangeMask.put(v.getAssignFieldValue(), set);
                return set;
            });
            if (null != detail.getPermissionFieldSqlValue()) {
                ruleAssign.add(detail.getPermissionFieldSqlValue());
            } else if (null != detail.getPermissionFieldValue()) {
                ruleAssign.add(detail.getPermissionFieldValue().toString());
            }
        });
    }
}

