/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.mapper.ApiInterfaceMapper;
import com.hand.hap.api.gateway.mapper.ApiServerMapper;
import com.hand.hap.cache.impl.ApiConfigCache;
import com.hand.hap.cache.impl.RedisCache;
import com.hand.hap.core.BaseConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnection;

public class ApiServerCache
extends RedisCache<ApiServer>
implements BaseConstants {
    private static final Logger logger = LoggerFactory.getLogger(ApiConfigCache.class);
    private static final String REDIS_CATALOG = "hap:cache:api_config:";
    private static final String CACHE_HEAD = "Head:";
    private String getServerAndInterface = ApiServerMapper.class.getName() + ".getServerAndInterfaceByServerId";
    private String serverSelectAll = ApiServerMapper.class.getName() + ".selectAll";
    private String interfaceSelectAll = ApiInterfaceMapper.class.getName() + ".selectAll";
    private ObjectMapper objectMapper;

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void init() {
        this.setType(ApiServer.class);
        this.strSerializer = this.getRedisTemplate().getStringSerializer();
        this.initLoad();
    }

    public ApiServer getValue(String serverUrl, String interfaceUrl) {
        String key = REDIS_CATALOG + serverUrl;
        String headKey = CACHE_HEAD + serverUrl;
        ApiServer server = (ApiServer)this.getRedisTemplate().execute(connection -> {
            Object serverObject = this.hMGet(connection, key, headKey, ApiServer.class);
            if (serverObject != null) {
                ApiServer s = (ApiServer)serverObject;
                Object interfaceObject = this.hMGet(connection, key, interfaceUrl, ApiInterface.class);
                if (interfaceObject != null) {
                    ApiInterface i = (ApiInterface)interfaceObject;
                    s.setApiInterface(i);
                    return s;
                }
            }
            return null;
        });
        return server;
    }

    public void reload(Object o) {
        block15: {
            logger.info("reload cache serverId:{}", o);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                ApiServer server = (ApiServer)sqlSession.selectOne(this.getServerAndInterface, o);
                if (server != null) {
                    this.setValue(server);
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block15;
                logger.error("reload server cache error:", (Throwable)e);
            }
        }
    }

    public void setValue(ApiServer server) {
        List<ApiInterface> interfaces = server.getInterfaces();
        String key = REDIS_CATALOG + server.getMappingUrl();
        this.getRedisTemplate().execute(connection -> {
            String headKey = CACHE_HEAD + server.getMappingUrl();
            server.setInterfaces(null);
            String serverString = this.objectToString(server);
            HashMap<byte[], byte[]> serverMap = new HashMap<byte[], byte[]>();
            serverMap.put(this.strSerializer.serialize((Object)headKey), this.strSerializer.serialize((Object)serverString));
            connection.hMSet(this.strSerializer.serialize((Object)key), serverMap);
            if (interfaces != null && interfaces.size() > 0) {
                HashMap<byte[], byte[]> interfaceMap = new HashMap<byte[], byte[]>();
                for (ApiInterface srInterface : interfaces) {
                    String interfaceKey = srInterface.getMappingUrl();
                    String interfaceString = this.objectToString(srInterface);
                    interfaceMap.put(this.strSerializer.serialize((Object)interfaceKey), this.strSerializer.serialize((Object)interfaceString));
                }
                connection.hMSet(this.strSerializer.serialize((Object)key), interfaceMap);
            }
            return null;
        });
    }

    @Override
    public void initLoad() {
        block14: {
            HashMap<Long, ApiServer> serverMap = new HashMap<Long, ApiServer>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.serverSelectAll, resultContext -> {
                    ApiServer server = (ApiServer)resultContext.getResultObject();
                    serverMap.put(server.getServerId(), server);
                });
                sqlSession.select(this.interfaceSelectAll, resultContext -> {
                    ApiInterface item = (ApiInterface)resultContext.getResultObject();
                    ApiServer server = (ApiServer)serverMap.get(item.getServerId());
                    if (server != null) {
                        List<ApiInterface> interfaces = server.getInterfaces();
                        if (interfaces == null) {
                            interfaces = new ArrayList<ApiInterface>();
                            server.setInterfaces(interfaces);
                        }
                        interfaces.add(item);
                    }
                });
                serverMap.forEach((k, v) -> this.setValue((ApiServer)v));
                serverMap.clear();
            }
            catch (Throwable e) {
                if (!logger.isErrorEnabled()) break block14;
                logger.error("init lov cache error:", e);
            }
        }
    }

    public void remove(ApiServer server) {
        String key = REDIS_CATALOG + server.getMappingUrl();
        this.getRedisTemplate().execute(connection -> {
            byte[] keyBytes = this.strSerializer.serialize((Object)key);
            connection.del((byte[][])new byte[][]{keyBytes});
            return null;
        });
    }

    protected String objectToString(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            if (logger.isWarnEnabled()) {
                logger.warn("invalid json: " + value);
            }
            throw new RuntimeException(e);
        }
    }

    protected Object stringToObject(String value, Class type) {
        try {
            return this.objectMapper.readValue(value, type);
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("invalid value: " + value);
            }
            throw new RuntimeException(e);
        }
    }

    protected Object hMGet(RedisConnection connection, String mapKey, String pName, Class type) {
        byte[] mapKeyBytes = this.strSerializer.serialize((Object)mapKey);
        List result = connection.hMGet(mapKeyBytes, (byte[][])new byte[][]{this.strSerializer.serialize((Object)pName)});
        if (result.isEmpty() || result.get(0) == null) {
            return null;
        }
        String string = (String)this.strSerializer.deserialize((byte[])result.get(0));
        Object obj = this.stringToObject(string, type);
        return obj;
    }
}

