/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.mapper.HapInterfaceHeaderMapper;
import com.hand.hap.intergration.mapper.HapInterfaceLineMapper;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiConfigCache<T>
extends HashStringRedisCache<HapInterfaceHeader> {
    private static final Logger logger = LoggerFactory.getLogger(ApiConfigCache.class);
    private String apiSql = HapInterfaceHeaderMapper.class.getName() + ".getAllHeaderAndLine";
    private String lineSql = HapInterfaceLineMapper.class.getName() + ".getHeaderLineByLineId";

    @Override
    public void init() {
        this.setType(HapInterfaceHeader.class);
        this.strSerializer = this.getRedisTemplate().getStringSerializer();
        this.initLoad();
    }

    @Override
    public HapInterfaceHeader getValue(String key) {
        return (HapInterfaceHeader)super.getValue(key);
    }

    @Override
    public void setValue(String key, HapInterfaceHeader headerAndLineDTO) {
        super.setValue(key, headerAndLineDTO);
    }

    @Override
    public void initLoad() {
        block14: {
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.apiSql, resultContext -> {
                    HapInterfaceHeader headerAndLineDTO = (HapInterfaceHeader)resultContext.getResultObject();
                    logger.info("cache result:{}", (Object)(headerAndLineDTO.getInterfaceCode() + headerAndLineDTO.getLineCode()));
                    this.setValue(headerAndLineDTO.getInterfaceCode() + headerAndLineDTO.getLineCode(), headerAndLineDTO);
                });
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block14;
                logger.error("init api cache error:", (Throwable)e);
            }
        }
    }

    public void reload(Object lineId) {
        block15: {
            logger.info("test  lineId:{}", lineId);
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                HapInterfaceHeader headerAndLineDTO = (HapInterfaceHeader)sqlSession.selectOne(this.lineSql, lineId);
                if (headerAndLineDTO != null) {
                    this.setValue(headerAndLineDTO.getInterfaceCode() + ":" + headerAndLineDTO.getLineCode(), headerAndLineDTO);
                }
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block15;
                logger.error("reload api cache error:", (Throwable)e);
            }
        }
    }
}

