/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.audit.controllers;

import com.hand.hap.audit.dto.Audit;
import com.hand.hap.audit.service.IAuditService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AuditController
extends BaseController {
    @Autowired
    private IAuditService auditService;

    @RequestMapping(value={"/sys/audit/queryAll"})
    @ResponseBody
    public ResponseData getUserRoleIds(HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.auditService.selectAuditEntityAll(requestContext));
    }

    @RequestMapping(value={"/sys/audit/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData submitUserRole(HttpServletRequest request, @RequestBody List<Audit> audits, BindingResult result) throws BaseException {
        this.getValidator().validate(audits, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.auditService.saveAuditEntityAll(requestContext, audits));
    }
}

