/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.service.impl;

import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.impl.ApiSoapInvokeServiceImpl;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.mybatis.util.StringUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpRequestAuthorization {
    private Logger logger = LoggerFactory.getLogger(ApiSoapInvokeServiceImpl.class);
    @Autowired
    private IHapAuthenticationService authenticationService;

    public void setHttpRequestAuthorization(HttpRequest httpRequest, ApiServer server) {
        if ("BASIC".equalsIgnoreCase(server.getAuthType())) {
            String e1 = server.getAuthUsername() + ":" + server.getAuthPassword();
            String basicBase64 = new String(Base64.encodeBase64((byte[])e1.getBytes()));
            httpRequest.setHeader("Authorization", "Basic " + basicBase64);
        } else if ("OAUTH2".equalsIgnoreCase(server.getAuthType())) {
            String accessToken = this.getToken(server);
            httpRequest.setHeader("Authorization", "Bearer " + accessToken);
        }
    }

    public String getToken(ApiServer server) {
        String accessToken = this.authenticationService.getToken(server);
        if (StringUtil.isEmpty(accessToken)) {
            this.logger.error("get access_token failure,check your config");
            throw new RuntimeException("get access_token failure,check your config");
        }
        return accessToken;
    }

    public void updateToken(HttpRequest httpRequest, ApiServer server) {
        this.authenticationService.updateToken(server);
        String accessToken = this.getToken(server);
        httpRequest.setHeader("Authorization", "Bearer " + accessToken);
    }
}

