/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.service.impl;

import com.github.pagehelper.StringUtil;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiInvokeService;
import com.hand.hap.api.gateway.service.impl.HttpRequestAuthorization;
import com.hand.hap.core.ProxySelf;
import com.hand.hap.intergration.beans.HapTransferDataMapper;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.intergration.util.JSONAndMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiRestInvokeServiceImpl
implements IApiInvokeService,
ProxySelf<IApiInvokeService> {
    private static final Logger logger = LoggerFactory.getLogger(ApiRestInvokeServiceImpl.class);
    @Autowired
    private IHapAuthenticationService authenticationService;
    @Autowired
    HttpRequestAuthorization httpRequestAuthorization;

    @Override
    public String serverType() {
        return "REST";
    }

    @Override
    public Object invoke(ApiServer server, JSONObject inbound) throws Exception {
        logger.info("inbound:{}", (Object)inbound);
        String params = this.getRequestParams(server, inbound);
        String responseData = ((IApiInvokeService)this.self()).apiInvoke(server, params);
        responseData = responseData.toString().replaceAll("null", "\"\"");
        return StringUtils.isEmpty((String)responseData) ? responseData : JSONObject.fromObject((Object)responseData);
    }

    @Override
    public String apiInvoke(ApiServer server, String params) throws Exception {
        return this.sentRequest(server, params);
    }

    private String sentRequest(ApiServer server, String params) throws Exception {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpRequestBase httpRequest = this.getHttpRequest(server, params);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpRequest);
            HapTransferDataMapper mapper = this.getHapTransferDataMapper(server);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401 && "OAUTH2".equalsIgnoreCase(server.getAuthType())) {
                this.httpRequestAuthorization.updateToken((HttpRequest)httpRequest, server);
                response = client.execute((HttpUriRequest)httpRequest);
            }
            statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String responseData = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (statusCode != 200) {
                throw new HapApiException("API_THIRD_PARTY_REQUEST_" + statusCode, responseData);
            }
            if (null != mapper) {
                responseData = mapper.responseDataMap(responseData);
            } else {
                Header[] head = response.getHeaders("Content-Type");
                if (head[0].getValue().contains("xml")) {
                    responseData = this.responseDataMap(responseData);
                }
            }
            String string = responseData;
            return string;
        }
    }

    private HapTransferDataMapper getHapTransferDataMapper(ApiServer server) throws Exception {
        HapTransferDataMapper mapper = null;
        if (StringUtil.isNotEmpty(server.getApiInterface().getMappingClass())) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> c = cl.loadClass(server.getApiInterface().getMappingClass());
                mapper = (HapTransferDataMapper)c.newInstance();
            }
            catch (IllegalAccessException e) {
                logger.error("IllegalAccessException:" + e.getMessage());
                throw e;
            }
        }
        return mapper;
    }

    private String getRequestParams(ApiServer server, JSONObject inbound) throws Exception {
        String params = "";
        String method = server.getApiInterface().getRequestMethod();
        String url = server.getDomainUrl() + server.getApiInterface().getInterfaceUrl();
        url = this.convertUrl(url, inbound);
        String key = null;
        String value = "";
        if (null != inbound) {
            if ("DELETE".equalsIgnoreCase(method) || "GET".equalsIgnoreCase(method)) {
                params = params + "?";
                Iterator iterator = inbound.keys();
                while (iterator.hasNext()) {
                    key = (String)iterator.next();
                    value = inbound.getString(key);
                    params = params + key + "=" + value + "&";
                }
                params = params.substring(0, params.length() - 1);
            } else {
                String contentType = "application/json";
                String head = server.getApiInterface().getRequestHead();
                JSONArray jsonArray = JSONArray.fromObject((Object)head);
                int j = jsonArray.size();
                for (int i = 0; i < j; ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    contentType = jsonObject.get("Content-Type").toString();
                }
                HapTransferDataMapper mapper = this.getHapTransferDataMapper(server);
                if (null != mapper) {
                    params = params + mapper.requestDataMap(inbound);
                } else {
                    params = params + inbound.toString();
                    if ("application/x-www-form-urlencoded".equalsIgnoreCase(contentType)) {
                        params = params + this.requestDataMap(inbound);
                    }
                }
            }
        }
        server.setMappingUrl(url);
        return params;
    }

    private HttpRequestBase getHttpRequest(ApiServer server, String params) throws UnsupportedEncodingException {
        StringEntity entity = null;
        HttpGet httpRequest = null;
        String method = server.getApiInterface().getRequestMethod();
        String url = server.getMappingUrl();
        if (!StringUtils.isEmpty((String)params)) {
            if ("DELETE".equalsIgnoreCase(method) || "GET".equalsIgnoreCase(method)) {
                url = url + params;
            } else {
                entity = new StringEntity(params, "UTF-8");
            }
        }
        switch (method.toUpperCase()) {
            case "GET": {
                httpRequest = new HttpGet(url);
                break;
            }
            case "POST": {
                HttpPost post = new HttpPost(url);
                if (null != entity) {
                    post.setEntity((HttpEntity)entity);
                }
                httpRequest = post;
                break;
            }
            case "DELETE": {
                httpRequest = new HttpDelete(url);
                break;
            }
            case "PUT": {
                HttpPut put = new HttpPut(url);
                if (null != entity) {
                    put.setEntity((HttpEntity)entity);
                }
                httpRequest = put;
                break;
            }
        }
        httpRequest.setHeader("charset", "UTF-8");
        String contentType = "application/json";
        String head = server.getApiInterface().getRequestHead();
        JSONArray jsonArray = JSONArray.fromObject((Object)head);
        int j = jsonArray.size();
        for (int i = 0; i < j; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            contentType = jsonObject.get("Content-Type").toString();
        }
        if (!StringUtils.isEmpty((String)contentType)) {
            httpRequest.setHeader("Content-Type", contentType);
        }
        return httpRequest;
    }

    private String convertUrl(String url, JSONObject inbound) {
        Pattern pattern = Pattern.compile("\\{[A-z]{0,}\\}");
        Matcher matcher = pattern.matcher(url);
        String str = null;
        String key = null;
        while (matcher.find()) {
            str = matcher.group();
            key = str.substring(1, str.length() - 1);
            Object obj = inbound.get(key);
            if (null == obj) continue;
            url = url.replace(str, obj.toString());
            inbound.remove(key);
        }
        return url;
    }

    private void setToken(HttpRequestBase http, ApiServer server) {
        if ("BASIC".equalsIgnoreCase(server.getAuthType())) {
            String e1 = server.getAuthUsername() + ":" + server.getAuthPassword();
            String basicBase64 = new String(Base64.encodeBase64((byte[])e1.getBytes()));
            http.setHeader("Authorization", "Basic " + basicBase64);
        } else if ("OAUTH2".equalsIgnoreCase(server.getAuthType())) {
            String accessToken = this.authenticationService.getToken(server);
            if (com.hand.hap.mybatis.util.StringUtil.isEmpty(accessToken)) {
                logger.error("get access_token failure,check your config");
                throw new RuntimeException("get access_token failure,check your config");
            }
            http.setHeader("Authorization", "Bearer " + accessToken);
        }
    }

    private void reSetToken(HttpRequestBase http, ApiServer server) {
        this.authenticationService.updateToken(server);
        this.setToken(http, server);
    }

    private String requestDataMap(JSONObject params) {
        String resultData = "";
        if (params != null && params.size() > 0) {
            Iterator iterator = params.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                try {
                    resultData = resultData + key + "=" + URLEncoder.encode(params.get(key).toString(), "UTF-8") + "&";
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
        return resultData.substring(0, resultData.length() - 1);
    }

    public String responseDataMap(String params) {
        Map map;
        try {
            map = JSONAndMap.xml2map(params);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        JSONObject jsonObject = new JSONObject();
        if (map != null && map.size() > 0) {
            jsonObject = JSONObject.fromObject((Object)map);
        }
        return jsonObject.toString();
    }
}

