/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiImportService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="restImportServer")
public class ApiRestImportServiceImpl
implements IApiImportService {
    private final Logger logger = LoggerFactory.getLogger(ApiRestImportServiceImpl.class);
    private static final String SCHEMES = "schemes";
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public ApiServer importServer(ApiServer server) {
        String importUrl = server.getImportUrl();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(importUrl);
        HttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpGet);
            if (response.getStatusLine().getStatusCode() == 200) {
                String conResult = EntityUtils.toString((HttpEntity)response.getEntity());
                JsonNode jsonNode = (JsonNode)this.objectMapper.readValue(conResult, JsonNode.class);
                String serverName = jsonNode.get("info").get("title").asText();
                String url = null;
                url = null != url ? url : "http://";
                String serverUrl = url + jsonNode.get("host").asText() + jsonNode.get("basePath").asText();
                server.setCode(StringUtils.replace((String)serverName, (String)" ", (String)""));
                server.setName(serverName);
                server.setServiceType("REST");
                server.setDomainUrl(serverUrl);
                server.setMappingUrl(server.getCode());
                ArrayList<ApiInterface> interfaceList = new ArrayList<ApiInterface>();
                Iterator it = jsonNode.get("paths").fields();
                while (it.hasNext()) {
                    boolean isGetAndPost;
                    Map.Entry path = (Map.Entry)it.next();
                    Iterator itM = ((JsonNode)path.getValue()).fields();
                    int methodSzie = ((JsonNode)path.getValue()).size();
                    boolean bl = isGetAndPost = 7 == methodSzie;
                    while (itM.hasNext()) {
                        Map.Entry method = (Map.Entry)itM.next();
                        String methodType = (String)method.getKey();
                        if (isGetAndPost && !"POST".equalsIgnoreCase(methodType) && !"GET".equalsIgnoreCase(methodType)) continue;
                        ApiInterface ife = new ApiInterface();
                        String code = ((JsonNode)method.getValue()).get("operationId").asText();
                        ife.setCode(code.toUpperCase());
                        ife.setName(((JsonNode)method.getValue()).get("summary").asText());
                        ife.setInterfaceUrl((String)path.getKey());
                        ife.setMappingUrl(code);
                        ife.setEnableFlag("Y");
                        ife.setRequestMethod(methodType.toUpperCase());
                        this.processRequestHeader(ife, (JsonNode)method.getValue());
                        interfaceList.add(ife);
                    }
                }
                server.setInterfaces(interfaceList);
            }
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return server;
    }

    private void processRequestHeader(ApiInterface ife, JsonNode method) throws JsonProcessingException {
        ArrayList requestHeader = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        JsonNode consumes = method.get("consumes");
        if (null != consumes) {
            if (consumes.isTextual()) {
                map.put("Content-Type", consumes.textValue());
                requestHeader.add(map);
            } else if (consumes.isArray()) {
                Iterator itTemp = consumes.iterator();
                String contentType = null;
                boolean isFirst = true;
                while (itTemp.hasNext()) {
                    String value = ((JsonNode)itTemp.next()).asText();
                    contentType = isFirst ? value : contentType;
                    isFirst = false;
                    if (!"application/json".equalsIgnoreCase(value)) continue;
                    contentType = value;
                }
                map = new HashMap();
                map.put("Content-Type", contentType);
                requestHeader.add(map);
            }
        } else {
            map.put("Content-Type", "application/json");
            requestHeader.add(map);
        }
        if (!requestHeader.isEmpty()) {
            ife.setRequestHead(this.objectMapper.writeValueAsString(requestHeader));
        }
    }
}

