/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.controllers;

import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.service.IApiInterfaceService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/gateway/interface", "/api/sys/gateway/interface"})
public class ApiInterfaceController
extends BaseController {
    @Autowired
    private IApiInterfaceService service;

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<ApiInterface> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/getInterfacesByServerId"})
    @ResponseBody
    public ResponseData getInterfacesByServerId(ApiInterface dto, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectByServerId(requestContext, dto));
    }

    @RequestMapping(value={"/getInterfacesByServerCode/{clientId}/{serverId}"})
    @ResponseBody
    public ResponseData getInterfacesByServerCode(@PathVariable String clientId, @PathVariable Long serverId, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectByServerIdWithLimit(requestContext, clientId, serverId));
    }
}

