/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.application.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.api.application.dto.ApiApplication;
import com.hand.hap.api.application.mapper.ApiApplicationMapper;
import com.hand.hap.api.application.service.IApiAccessLimitService;
import com.hand.hap.api.application.service.IApiApplicationService;
import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiInterfaceService;
import com.hand.hap.api.gateway.service.IApiServerService;
import com.hand.hap.core.IRequest;
import com.hand.hap.security.oauth.dto.Oauth2ClientDetails;
import com.hand.hap.security.oauth.service.IOauth2ClientDetailsService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApiApplicationServiceImpl
extends BaseServiceImpl<ApiApplication>
implements IApiApplicationService {
    @Autowired
    private ApiApplicationMapper applicationMapper;
    @Autowired
    private IOauth2ClientDetailsService clientService;
    @Autowired
    private IApiServerService serverService;
    @Autowired
    private IApiAccessLimitService accessLimitService;
    @Autowired
    private IApiInterfaceService apiInterfaceService;

    @Override
    public ApiApplication selectById(IRequest request, Long applicationId) {
        ApiApplication application = this.applicationMapper.selectById(applicationId);
        String[] ids = StringUtils.commaDelimitedListToStringArray((String)application.getClient().getScope());
        if (ids != null && ids.length > 0) {
            application.setServers(this.serverService.selectByCodes(request, Arrays.asList(ids)));
        }
        return application;
    }

    @Override
    public List<ApiApplication> selectApplications(IRequest request, ApiApplication apiApplication, int page, int pageSize) {
        PageHelper.startPage(page, pageSize);
        return this.applicationMapper.selectApplications(apiApplication);
    }

    @Override
    public List<ApiServer> selectNotExistsServerByApp(IRequest request, String exitsCodes, ApiServer server, int page, int pageSize) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)exitsCodes)) {
            params.put("codeList", StringUtils.commaDelimitedListToStringArray((String)exitsCodes));
        }
        params.put("server", server);
        PageHelper.startPage(page, pageSize);
        return this.applicationMapper.selectNotExistsServerByApp(params);
    }

    @Override
    public List<ApiApplication> batchUpdate(IRequest request, List<ApiApplication> list) {
        for (ApiApplication application : list) {
            if (application.getApplicationId() != null) {
                ((IApiApplicationService)this.self()).updateApplication(request, application);
                continue;
            }
            ((IApiApplicationService)this.self()).addApplication(request, application);
        }
        return list;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public ApiApplication addApplication(IRequest request, ApiApplication application) {
        application.getClient().setApplicationCode(application.getCode());
        Oauth2ClientDetails client = this.clientService.insertSelective(request, application.getClient());
        application.setCliId(client.getId());
        this.applicationMapper.insertSelective(application);
        this.accessLimitService.updateByApplication("", application);
        return application;
    }

    @Override
    public ApiApplication updateApplication(IRequest request, ApiApplication application) {
        Oauth2ClientDetails oauth2ClientDetails = this.clientService.selectByClientId(application.getClient().getClientId());
        this.clientService.updateClient(request, application.getClient());
        String before = oauth2ClientDetails.getScope();
        this.accessLimitService.updateByApplication(before, application);
        this.accessLimitService.updateAccessLimit(application);
        return application;
    }

    private ApiApplication processServers(ApiApplication application) {
        List<ApiServer> servers = application.getServers();
        ArrayList ids = new ArrayList();
        if (servers != null && !servers.isEmpty()) {
            servers.forEach(t -> ids.add(t.getCode()));
            application.getClient().setScope(StringUtils.collectionToCommaDelimitedString(ids));
        }
        return application;
    }

    @Override
    public int deleteByPrimaryKey(ApiApplication record) {
        Long cliId = record.getCliId();
        Oauth2ClientDetails clientDetails = new Oauth2ClientDetails();
        clientDetails.setId(cliId);
        this.accessLimitService.deleteByClientId(cliId);
        this.clientService.deleteByPrimaryKey(clientDetails);
        return this.applicationMapper.deleteByPrimaryKey(record);
    }
}

