/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.adaptor.impl;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.RoleException;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.adaptor.ILoginAdaptor;
import com.hand.hap.core.components.CaptchaConfig;
import com.hand.hap.core.components.SysConfigManager;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.util.TimeZoneUtil;
import com.hand.hap.security.IUserSecurityStrategy;
import com.hand.hap.security.TokenUtils;
import com.hand.hap.security.captcha.ICaptchaManager;
import com.hand.hap.security.service.impl.UserSecurityStrategyManager;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.WebUtils;

public class DefaultLoginAdaptor
implements ILoginAdaptor {
    private static final boolean VALIDATE_CAPTCHA = true;
    private static final String KEY_VERIFICODE = "verifiCode";
    private static final String VIEW_INDEX = "/";
    private static final String VIEW_LOGIN = "/login";
    private static final String VIEW_ROLE_SELECT = "/role";
    @Autowired
    private ICaptchaManager captchaManager;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;
    @Autowired
    private IUserService userService;
    @Autowired
    private CaptchaConfig captchaConfig;
    @Autowired
    private SysConfigManager sysConfigManager;
    @Autowired
    UserSecurityStrategyManager userSecurityStrategyManager;

    public ModelAndView doLogin(User user, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView view = new ModelAndView();
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        view.setViewName(this.getLoginView(request));
        try {
            this.beforeLogin(view, user, request, response);
            this.checkCaptcha(view, user, request, response);
            user = this.userService.login(user);
            HttpSession session = request.getSession(true);
            session.setAttribute("userId", (Object)user.getUserId());
            session.setAttribute("userName", (Object)user.getUserName());
            session.setAttribute("locale", (Object)locale.toString());
            this.setTimeZoneFromPreference(session, user.getUserId());
            this.generateSecurityKey(session);
            this.afterLogin(view, user, request, response);
        }
        catch (UserException e) {
            view.addObject("msg", (Object)this.messageSource.getMessage(e.getCode(), e.getParameters(), locale));
            view.addObject("code", (Object)e.getCode());
            this.processLoginException(view, user, e, request, response);
        }
        return view;
    }

    private void setTimeZoneFromPreference(HttpSession session, Long accountId) {
        String tz = "GMT+0800";
        if (StringUtils.isBlank((String)tz)) {
            tz = TimeZoneUtil.toGMTFormat(TimeZone.getDefault());
        }
        session.setAttribute("timeZone", (Object)tz);
    }

    private String generateSecurityKey(HttpSession session) {
        return TokenUtils.setSecurityKey(session);
    }

    protected void beforeLogin(ModelAndView view, User account, HttpServletRequest request, HttpServletResponse response) throws UserException {
    }

    protected void processLoginException(ModelAndView view, User account, UserException e, HttpServletRequest request, HttpServletResponse response) {
    }

    private void checkCaptcha(ModelAndView view, User user, HttpServletRequest request, HttpServletResponse response) throws UserException {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.captchaManager.getCaptchaKeyName());
        String captchaCode = request.getParameter(KEY_VERIFICODE);
        if (cookie == null || StringUtils.isEmpty((String)captchaCode) || !this.captchaManager.checkCaptcha(cookie.getValue(), captchaCode)) {
            throw new UserException("error.login.verification_code_error", "error.login.verification_code_error", null);
        }
    }

    protected void afterLogin(ModelAndView view, User user, HttpServletRequest request, HttpServletResponse response) throws UserException {
        view.setViewName("redirect:" + this.getRoleView(request));
        Cookie cookie = new Cookie("userName", user.getUserName());
        cookie.setPath(StringUtils.defaultIfEmpty((String)request.getContextPath(), (String)VIEW_INDEX));
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
    }

    @Override
    public ModelAndView doSelectRole(IRole role, HttpServletRequest request, HttpServletResponse response) throws RoleException {
        ModelAndView result = new ModelAndView();
        HttpSession session = request.getSession(false);
        if (session != null && role != null && role.getRoleId() != null) {
            Long userId = (Long)session.getAttribute("userId");
            this.roleService.checkUserRoleExists(userId, role.getRoleId());
            if (!this.sysConfigManager.getRoleMergeFlag()) {
                Long[] ids = new Long[]{role.getRoleId()};
                session.setAttribute("roleIds", (Object)ids);
            }
            session.setAttribute("roleId", (Object)role.getRoleId());
            result.setViewName("redirect:" + this.getIndexView(request));
        } else {
            result.setViewName("redirect:" + this.getLoginView(request));
        }
        return result;
    }

    protected String getIndexView(HttpServletRequest request) {
        return VIEW_INDEX;
    }

    protected String getLoginView(HttpServletRequest request) {
        return VIEW_LOGIN;
    }

    protected String getRoleView(HttpServletRequest request) {
        return VIEW_ROLE_SELECT;
    }

    public IUserService getUserService() {
        return this.userService;
    }

    @Override
    public ModelAndView indexView(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        ModelAndView mav = this.indexModelAndView(request, response);
        if (session != null) {
            Long userId = (Long)session.getAttribute("userId");
            if (userId != null) {
                if (session.getAttribute("login_change_index") != null) {
                    User user = new User();
                    user.setUserId(userId);
                    user = this.userService.selectByPrimaryKey(RequestHelper.createServiceRequest(request), user);
                    List<IUserSecurityStrategy> userSecurityStrategies = this.userSecurityStrategyManager.getUserSecurityStrategyList();
                    for (IUserSecurityStrategy userSecurityStrategy : userSecurityStrategies) {
                        ModelAndView mv = userSecurityStrategy.loginVerifyStrategy(user, request);
                        if (mv == null) continue;
                        return mv;
                    }
                    session.removeAttribute("login_change_index");
                }
            } else {
                return new ModelAndView("redirect:" + this.getLoginView(request));
            }
            if (!this.sysConfigManager.getRoleMergeFlag()) {
                Long roleId = (Long)session.getAttribute("roleId");
                if (roleId == null) {
                    return new ModelAndView("redirect:" + this.getRoleView(request));
                }
                User user = new User();
                user.setUserId(userId);
                List<IRole> roles = this.roleService.selectActiveRolesByUser(RequestHelper.createServiceRequest(request), user);
                mav.addObject("SYS_USER_ROLES", roles);
                mav.addObject("CURRENT_USER_ROLE", (Object)roleId);
            }
        }
        String sysTitle = this.sysConfigManager.getSysTitle();
        mav.addObject("SYS_TITLE", (Object)sysTitle);
        return mav;
    }

    public ModelAndView indexModelAndView(HttpServletRequest request, HttpServletResponse response) {
        return new ModelAndView("index");
    }

    @Override
    public ModelAndView loginView(HttpServletRequest request, HttpServletResponse response) {
        Throwable exception;
        ModelAndView view = new ModelAndView(this.getLoginView(request));
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)"loginKey");
        if (this.captchaConfig.getWrongTimes() > 0 && cookie == null) {
            String uuid = UUID.randomUUID().toString();
            cookie = new Cookie("loginKey", uuid);
            cookie.setPath(StringUtils.defaultIfEmpty((String)request.getContextPath(), (String)VIEW_INDEX));
            cookie.setMaxAge(this.captchaConfig.getExpire().intValue());
            response.addCookie(cookie);
            this.captchaConfig.updateLoginFailureInfo(cookie);
        }
        view.addObject("ENABLE_CAPTCHA", (Object)this.captchaConfig.isEnableCaptcha(cookie));
        view.addObject("SYS_TITLE", (Object)this.sysConfigManager.getSysTitle());
        Boolean error = (Boolean)request.getAttribute("error");
        for (exception = (Exception)request.getAttribute("exception"); exception != null && exception.getCause() != null; exception = exception.getCause()) {
        }
        String code = "error.login.name_password_not_match";
        if (exception instanceof BaseException) {
            code = ((BaseException)exception).getDescriptionKey();
        }
        if (error != null && error.booleanValue()) {
            Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
            String msg = this.messageSource.getMessage(code, null, locale);
            view.addObject("msg", (Object)msg);
        }
        return view;
    }

    @Override
    public ModelAndView roleView(HttpServletRequest request, HttpServletResponse response) {
        Long userId;
        ModelAndView mv = new ModelAndView(this.getRoleView(request));
        HttpSession session = request.getSession(false);
        mv.addObject("SYS_TITLE", (Object)this.sysConfigManager.getSysTitle());
        if (session != null && (userId = (Long)session.getAttribute("userId")) != null) {
            User user = new User();
            user.setUserId(userId);
            session.setAttribute("userId", (Object)userId);
            this.addCookie("userId", userId.toString(), request, response);
            List<IRole> roles = this.roleService.selectActiveRolesByUser(RequestHelper.createServiceRequest(request), user);
            mv.addObject("roles", roles);
        }
        return mv;
    }

    protected void addCookie(String cookieName, String cookieValue, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setPath(StringUtils.defaultIfEmpty((String)request.getContextPath(), (String)VIEW_INDEX));
        cookie.setMaxAge(-1);
        response.addCookie(cookie);
    }

    @Override
    public ResponseData sessionExpiredLogin(User account, HttpServletRequest request, HttpServletResponse response) throws RoleException {
        ResponseData data = new ResponseData();
        ModelAndView view = this.doLogin(account, request, response);
        ModelMap mm = view.getModelMap();
        if (mm.containsAttribute("code")) {
            data.setSuccess(false);
            data.setCode((String)mm.get((Object)"code"));
            data.setMessage((String)mm.get((Object)"msg"));
        } else {
            String userIdObj = request.getParameter("userId");
            String roleIdObj = request.getParameter("roleId");
            if (userIdObj != null && roleIdObj != null) {
                Long userId = Long.valueOf(userIdObj.toString());
                Long roleId = Long.valueOf(roleIdObj.toString());
                this.roleService.checkUserRoleExists(userId, roleId);
                HttpSession session = request.getSession();
                session.setAttribute("userId", (Object)userId);
                session.setAttribute("roleId", (Object)roleId);
            }
        }
        return data;
    }
}

