/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.event.components;

import com.hand.hap.activiti.event.TaskRecallEvent;
import com.hand.hap.activiti.event.TaskRecallListener;
import com.hand.hap.activiti.event.dto.TaskRecallInfo;
import com.hand.hap.core.AppContextInitListener;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class TaskRecallEventListener
implements AppContextInitListener {
    private List<TaskRecallListener> listeners;

    @EventListener
    public void handleTaskRecall(TaskRecallEvent event) {
        TaskRecallInfo taskRecallInfo = (TaskRecallInfo)event.getSource();
        this.listeners.forEach(t -> {
            if (taskRecallInfo.getProcessDefinitionKey().equals(t.processDefinitionKey())) {
                t.doRecall(event.getiRequest(), taskRecallInfo);
                return;
            }
        });
    }

    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        this.listeners = new ArrayList(applicationContext.getBeansOfType(TaskRecallListener.class).values());
    }
}

