/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetExpressionValueCmd
implements Command,
Serializable {
    Logger logger = LoggerFactory.getLogger(GetExpressionValueCmd.class);
    private String expression;
    private String executionId;
    private Map<String, Object> variables;

    public GetExpressionValueCmd(String executionId, String expression, Map<String, Object> variables) {
        this.executionId = executionId;
        this.expression = expression;
        this.variables = variables;
    }

    public Object execute(CommandContext commandContext) {
        Object result = null;
        try {
            ExecutionEntity execution;
            ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
            ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
            if (StringUtils.isNotEmpty((String)this.executionId)) {
                execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
            } else {
                execution = (ExecutionEntity)commandContext.getExecutionEntityManager().create();
                execution.setVariables(this.variables);
            }
            result = expressionManager.createExpression(this.expression).getValue((VariableScope)execution);
        }
        catch (Exception e) {
            result = this.expression;
            this.logger.warn("property not found in task description expression " + e.getMessage());
        }
        return result;
    }
}

