/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.components.ApprovalRule;
import com.hand.hap.activiti.core.IActivitiConstants;
import com.hand.hap.activiti.util.ActivitiUtils;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior
implements IActivitiConstants {
    @Autowired
    private ApprovalRule approvalRule;

    public CustomParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    protected int createInstances(DelegateExecution execution) {
        UserTask task;
        if (execution.getCurrentFlowElement() instanceof UserTask && !ActivitiUtils.isAddApproveChain(task = (UserTask)execution.getCurrentFlowElement())) {
            this.setLoopVariable(execution, "approvalCandidates", this.approvalRule.getApprovalRule(execution));
        }
        int ret = super.createInstances(execution);
        this.setLoopVariable(execution, "nrOfRejected", 0);
        this.setLoopVariable(execution, "nrOfApproved", 0);
        return ret;
    }

    public void leave(DelegateExecution execution) {
        String approveResult = String.valueOf(execution.getVariable("approveResult"));
        DelegateExecution rootExecution = this.getMultiInstanceRootExecution(execution);
        if (this.isRejected(approveResult)) {
            this.setLoopVariable(rootExecution, "nrOfRejected", this.getLoopVariable(rootExecution, "nrOfRejected") + 1);
        } else if (this.isApproved(approveResult)) {
            this.setLoopVariable(rootExecution, "nrOfApproved", this.getLoopVariable(rootExecution, "nrOfApproved") + 1);
        }
        super.leave(execution);
    }
}

