/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.account.constants.UserConstants;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.mapper.UserMapper;
import com.hand.hap.account.service.IUserInfoService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.mail.ReceiverTypeEnum;
import com.hand.hap.mail.dto.MessageReceiver;
import com.hand.hap.mail.service.IMessageService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.security.service.impl.UserSecurityStrategyManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserInfoServiceImpl
implements IUserInfoService {
    private final Logger logger = LoggerFactory.getLogger(UserInfoServiceImpl.class);
    private static final Long BASE_MENBER_EIGHT = 8L;
    @Autowired
    private IUserService userService;
    @Autowired
    private IMessageService messageService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    UserSecurityStrategyManager userSecurityStrategyManager;

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User create(IRequest request, User user) throws Exception {
        String tmpPassword = this.generateRandomPassword();
        user.setPassword(tmpPassword);
        user = this.userService.insertSelective(request, user);
        if (user == null) {
            throw new UserException("error.system.user_insert_fail", null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("create user {}", (Object)user.toString());
        }
        ArrayList<MessageReceiver> receiverlist = new ArrayList<MessageReceiver>();
        MessageReceiver receiver = new MessageReceiver();
        HashMap<String, Object> data = new HashMap<String, Object>();
        receiver.setMessageAddress(user.getEmail());
        receiver.setMessageType(ReceiverTypeEnum.NORMAL.getCode());
        receiver.setReceiverId(user.getUserId());
        receiverlist.add(receiver);
        data.put("tmpPassword", tmpPassword);
        data.put("limit", UserConstants.DEFAULT_PAGE);
        data.put("userName", user.getUserName());
        this.messageService.sendEmailMessage(-1L, null, "EMAIL_USER_TEMP_PWD", "PASSWORD", data, receiverlist, null);
        return user;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public User update(IRequest request, User user) throws BaseException {
        Criteria criteria = new Criteria(user);
        criteria.update("email", "phone");
        user = this.userService.updateByPrimaryKeyOptions(request, user, criteria);
        return user;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public List<User> getUsers(IRequest request, User user, int page, int pagesize) throws UserException {
        PageHelper.startPage(page, pagesize);
        return this.userMapper.select(user);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public User selectUserByPrimaryKey(IRequest request, Long userId) throws UserException {
        User user = new User();
        user.setUserId(userId);
        List<User> checkUsers = this.userService.select(request, user, UserConstants.DEFAULT_PAGE, UserConstants.DEFAULT_PAGE_SIZE);
        if (checkUsers.isEmpty()) {
            throw new UserException("error.system.user_not_exist", null);
        }
        User checkUser = checkUsers.get(0);
        if (!"ACTV".equals(checkUser.getStatus())) {
            throw new UserException("error.system.user_expired", null);
        }
        return checkUser;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, rollbackFor={Exception.class})
    public User selectUserByName(IRequest request, String userName) throws UserException {
        User user = new User();
        user.setUserName(userName);
        User checkUser = this.userMapper.selectByUserName(userName);
        if (checkUser == null) {
            throw new UserException("error.system.user_not_exist", null);
        }
        if (!"ACTV".equals(checkUser.getStatus())) {
            throw new UserException("error.system.user_expired", null);
        }
        return checkUser;
    }

    private List<User> validateUser(IRequest request, User user) throws UserException {
        if (!user.getUserName().matches("^[A-Za-z0-9]{6,20}$")) {
            throw new UserException("error.user.user_format", new Object[0]);
        }
        User checkUser = new User();
        checkUser.setUserName(user.getUserName());
        List<User> list = this.userMapper.select(checkUser);
        return list;
    }

    private List<User> validateEmail(IRequest request, User user) throws UserException {
        this.userService.validateEmail(user.getEmail());
        List<User> list = new ArrayList<User>();
        if ("INNER".equals(user.getUserType())) {
            User checkUser = new User();
            checkUser.setEmail(user.getEmail());
            list = this.userMapper.select(checkUser);
        }
        return list;
    }

    private List<User> validatePhone(IRequest request, User user) throws UserException {
        this.userService.validatePhone(user.getPhone());
        List<User> list = new ArrayList<User>();
        if ("INNER".equals(user.getUserType())) {
            User checkUser = new User();
            checkUser.setPhone(user.getPhone());
            list = this.userMapper.select(checkUser);
        }
        return list;
    }

    private String generateRandomPassword() {
        StringBuilder password = new StringBuilder();
        int i = 0;
        while ((long)i < BASE_MENBER_EIGHT) {
            password.append((int)(Math.random() * 9.0));
            ++i;
        }
        return password.toString();
    }
}

