/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.ocr.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.hand.app.ocr.service.IOcrService;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.service.ISysConfigService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/r/api"})
public class OcrStatelessController
extends BaseController {
    private Logger logger = LoggerFactory.getLogger(OcrStatelessController.class);
    @Autowired
    IOcrService ocrService;
    @Autowired
    ISysConfigService sysConfigService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/upload/ocr/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrIdCardByUpload(HttpServletRequest request) throws HapApiException, IOException {
        String apiName = request.getParameter("ocrType");
        JSONObject json = new JSONObject();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            MultipartHttpServletRequest req;
            Map fileMap;
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                json.put("code", (Object)"E");
                json.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (request instanceof MultipartHttpServletRequest && (fileMap = (req = (MultipartHttpServletRequest)request).getFileMap()) != null) {
                for (Map.Entry next : fileMap.entrySet()) {
                    String fileKey = (String)next.getKey();
                    MultipartFile filePart = (MultipartFile)next.getValue();
                    Long size = filePart.getSize();
                    inputStream = filePart.getInputStream();
                    String fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase();
                    String tomcatPath = this.sysConfigService.getConfigValue("OCR.PICTURE.PATH");
                    File file = new File(tomcatPath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    tomcatPath = tomcatPath + File.separator + fileName;
                    outputStream = new FileOutputStream(tomcatPath);
                    int len = -1;
                    byte[] bytes = new byte[1024];
                    while ((len = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, len);
                    }
                    outputStream.flush();
                    outputStream.close();
                    inputStream.close();
                    this.logger.info(tomcatPath);
                    if (apiName.equals("bankcard")) {
                        json = this.ocrService.ocrBankcard(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("idCard")) {
                        json = this.ocrService.ocrIdcard(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("businessLicense")) {
                        json = this.ocrService.ocrBusinessLicense(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("drivingLicense")) {
                        json = this.ocrService.ocrDrivingLicense(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("organizationCode")) {
                        json = this.ocrService.ocrOrganizationCode(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("vehicleLicense")) {
                        json = this.ocrService.ocrVehicleLicense(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("general")) {
                        json = this.ocrService.ocrGeneral(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("idcardMask")) {
                        json = this.ocrService.ocrIdcardMask(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("vatInvoice")) {
                        json = this.ocrService.ocrVatInvoice(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("expressReceipt")) {
                        json = this.ocrService.ocrExpressReceipt(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("carSalesInvoice")) {
                        json = this.ocrService.ocrCarSalesInvoice(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("medicalDoc")) {
                        json = this.ocrService.ocrMedicalDoc(tomcatPath);
                        continue;
                    }
                    if (apiName.equals("licensePlate")) {
                        json = this.ocrService.ocrLicensePlate(tomcatPath);
                        continue;
                    }
                    json.put("code", (Object)"E");
                    json.put("error", (Object)"\u6ca1\u6709\u5bf9\u5e94\u7c7b\u578b\u7684OCR\u63a5\u53e3");
                }
            }
        }
        catch (Exception e) {
            this.logger.info(e.toString());
            json.put("code", (Object)"E");
            json.put("error", (Object)e.getMessage());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return json;
    }

    @RequestMapping(value={"/ocr/bankcard/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrBankcard(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrBankcard(imgPath);
    }

    @RequestMapping(value={"/ocr/idcard/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrIdCard(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrIdcard(imgPath);
    }

    @RequestMapping(value={"/ocr/business_license/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrBusinessLicense(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrBusinessLicense(imgPath);
    }

    @RequestMapping(value={"/ocr/driving_license/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrDrivingLicense(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrDrivingLicense(imgPath);
    }

    @RequestMapping(value={"/ocr/organization_code/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrOrganizationCode(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrOrganizationCode(imgPath);
    }

    @RequestMapping(value={"/ocr/vehicle_license/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrVehicleLicense(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrVehicleLicense(imgPath);
    }

    @RequestMapping(value={"/ocr/general/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrGeneral(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrGeneral(imgPath);
    }

    @RequestMapping(value={"/ocr/idcard_mask/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrIdcardMask(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrIdcardMask(imgPath);
    }

    @RequestMapping(value={"/ocr/vat_invoice/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrVatInvoice(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrVatInvoice(imgPath);
    }

    @RequestMapping(value={"/ocr/express_receipt/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrExpressReceipt(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrExpressReceipt(imgPath);
    }

    @RequestMapping(value={"/ocr/car_sales_invoice/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrCarSalesInvoice(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrCarSalesInvoice(imgPath);
    }

    @RequestMapping(value={"/ocr/medical_doc/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrMedicalDoc(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrMedicalDoc(imgPath);
    }

    @RequestMapping(value={"/ocr/license_plate/stateless"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrLicensePlate(HttpServletRequest requests, @RequestBody(required=false) JSONObject params) throws Exception {
        this.logger.info("requestBody:{}", (Object)params);
        String imgPath = params.getString("imgPath");
        return this.ocrService.ocrLicensePlate(imgPath);
    }

    @RequestMapping(value={"/app/silentDetection"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject ocrLivenessImageVerification(HttpServletRequest request) {
        JSONObject json = new JSONObject();
        String name = request.getParameter("name");
        String idnumber = request.getParameter("idnumber");
        try {
            MultipartHttpServletRequest req;
            Map fileMap;
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                json.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (request instanceof MultipartHttpServletRequest && (fileMap = (req = (MultipartHttpServletRequest)request).getFileMap()) != null) {
                for (Map.Entry next : fileMap.entrySet()) {
                    int len;
                    MultipartFile filePart = (MultipartFile)next.getValue();
                    InputStream inputStream = filePart.getInputStream();
                    String fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase() + ".mp4";
                    String path = this.sysConfigService.getConfigValue("OCR.PICTURE.PATH");
                    File file = new File(path);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    path = path + File.separator + fileName;
                    FileOutputStream outputStream = new FileOutputStream(path);
                    byte[] bytes = new byte[1024];
                    while ((len = inputStream.read(bytes)) != -1) {
                        ((OutputStream)outputStream).write(bytes, 0, len);
                    }
                    outputStream.flush();
                    ((OutputStream)outputStream).close();
                    inputStream.close();
                    json = this.ocrService.silentDetection(path, name, idnumber);
                }
            }
        }
        catch (Exception e) {
            json.put("error", (Object)e.getMessage());
        }
        return json;
    }
}

