/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.hms.service.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PureNetUtilImpl {
    public static String get(String url) {
        return PureNetUtilImpl.post(url, null);
    }

    public static String get(String url, String charset) {
        return PureNetUtilImpl.post(url, null, charset);
    }

    public static String post(String url, String file_path) {
        return PureNetUtilImpl.post(url, file_path, null);
    }

    public static String urlencode(String data) {
        JSONObject json = JSONObject.fromObject((Object)data);
        Iterator iterator = json.keys();
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                sb.append(key).append("=").append(URLEncoder.encode(json.get(key) + "", "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String compressPhoto(int width, int height, String originalFilePath) {
        String compressFilePath = originalFilePath + "_" + width + "_" + height + ".jpg";
        try {
            File compressPhotoFile = new File(compressFilePath);
            if (!compressPhotoFile.exists()) {
                File originalPhotoFile = new File(originalFilePath);
                BufferedImage buff = ImageIO.read(new FileInputStream(originalPhotoFile));
                int originalWidth = buff.getWidth();
                int originalHeight = buff.getHeight();
                width = (int)((double)originalWidth * 0.9);
                height = (int)((double)originalHeight * 0.9);
                if (originalWidth > width) {
                    double percentDouble = (double)width / (double)originalWidth;
                    BufferedImage bufferedImage = Thumbnails.of((File[])new File[]{originalPhotoFile}).scale(percentDouble).outputQuality(1.0).outputFormat("jpg").asBufferedImage();
                    if (bufferedImage.getHeight() > height) {
                        Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).scale(1.0).outputQuality(1.0).sourceRegion(0, 0, bufferedImage.getWidth(), height).toFile(compressPhotoFile);
                    } else {
                        Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).scale(1.0).outputQuality(1.0).toFile(compressPhotoFile);
                    }
                } else if (originalHeight > height) {
                    BufferedImage bufferedImage = Thumbnails.of((File[])new File[]{originalPhotoFile}).scale(1.0).outputQuality(1.0).outputFormat("jpg").asBufferedImage();
                    Thumbnails.of((BufferedImage[])new BufferedImage[]{bufferedImage}).scale(1.0).outputQuality(1.0).sourceRegion(0, 0, originalWidth, height).toFile(compressPhotoFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return compressFilePath;
    }

    public static String GenerateImage(String baseStr, String picture_path) {
        BASE64Decoder decoder = new BASE64Decoder();
        String path = picture_path;
        String name = PureNetUtilImpl.getRandomString();
        String filepath = path + name;
        try {
            byte[] b = decoder.decodeBuffer(baseStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            String imgFilePath = filepath;
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.print(filepath);
        return PureNetUtilImpl.compressPhoto(1024, 768, filepath);
    }

    public static String getRandomString() {
        return UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String file_path, String outCharset) {
        if (outCharset == null) {
            outCharset = "UTF-8";
        }
        String resultDate = "";
        HttpURLConnection conn = null;
        try {
            File file = new File(file_path);
            FileInputStream inputStream = new FileInputStream(file);
            int sum = 0;
            sum = inputStream.available();
            url = url + sum;
            URL httpurl = new URL(url);
            HttpURLConnection con = (HttpURLConnection)httpurl.openConnection();
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestMethod("POST");
            OutputStream out = con.getOutputStream();
            byte[] data = new byte[2048];
            int len = 0;
            while ((len = inputStream.read(data)) != -1) {
                out.write(data, 0, len);
            }
            System.out.println("upload size=" + sum);
            out.flush();
            inputStream.close();
            out.close();
            int code = con.getResponseCode();
            if (code == 200) {
                InputStream inputStream2 = con.getInputStream();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                while ((len = inputStream2.read(data)) != -1) {
                    bos.write(data, 0, len);
                }
                System.out.println("result =" + bos.toString());
                inputStream2.close();
                bos.close();
                resultDate = bos.toString();
            }
            con.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return resultDate;
    }

    public static String GetImageStr(String imgFilePath) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgFilePath);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static String GetBase64(String imgFilePath) {
        FileInputStream in = null;
        byte[] data = null;
        try {
            in = new FileInputStream(imgFilePath);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(Base64.encodeBase64(data));
    }
}

