/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.hms.service.impl;

import com.hand.app.hms.service.IHmsFtpService;
import com.hand.hap.system.service.ISysConfigService;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.InputStream;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HmsFtpServiceImpl
implements IHmsFtpService {
    @Autowired
    ISysConfigService ISysConfigService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private Session sshSession;
    private ChannelSftp sftp;
    private String host = null;
    private String port = null;
    private String username = null;
    private String password = null;
    private String uploadDir = null;

    private void loadConfig() {
        this.host = this.ISysConfigService.getConfigValue("FTP.HOST");
        this.port = this.ISysConfigService.getConfigValue("FTP.PORT");
        this.username = this.ISysConfigService.getConfigValue("FTP.USERNAME");
        this.password = this.ISysConfigService.getConfigValue("FTP.PASSWORD");
        this.uploadDir = this.ISysConfigService.getConfigValue("FTP.UPLOADDIR");
    }

    @Override
    public Boolean connect() {
        this.loadConfig();
        try {
            JSch jsch = new JSch();
            jsch.getSession(this.username, this.host, Integer.parseInt(this.port));
            this.sshSession = jsch.getSession(this.username, this.host, Integer.parseInt(this.port));
            this.sshSession.setPassword(this.password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            this.sshSession.setConfig(sshConfig);
            this.sshSession.connect();
            Channel channel = this.sshSession.openChannel("sftp");
            channel.connect();
            this.sftp = (ChannelSftp)channel;
            this.logger.info("Connected to " + this.host + ".");
            return true;
        }
        catch (Exception e) {
            this.logger.error("sftp connect fail");
            this.disconnect();
            return false;
        }
    }

    @Override
    public void disconnect() {
        if (this.sftp != null) {
            this.sftp.exit();
        }
        if (this.sshSession != null) {
            this.sshSession.disconnect();
        }
        this.logger.info("sshSession disconnect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String upload(String directory, InputStream in, String fileName) {
        this.connect();
        if (fileName.isEmpty()) {
            fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase();
        }
        String dir = directory;
        try {
            this.sftp.cd(dir);
        }
        catch (Exception e) {
            try {
                this.sftp.mkdir(dir);
                this.sftp.cd(dir);
            }
            catch (SftpException e1) {
                e1.printStackTrace();
            }
        }
        try {
            this.sftp.put(in, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.disconnect();
        }
        return dir + fileName;
    }

    @Override
    public InputStream download(String downloadFile) {
        try {
            InputStream in = this.sftp.get(downloadFile);
            return in;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void delete(String directory, String deleteFile) {
        try {
            this.sftp.cd(directory);
            this.sftp.rm(deleteFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void mkDir(String basePath, String dirName) {
        String[] dirs = dirName.split("/");
        try {
            this.sftp.cd(basePath);
            for (int i = 0; i < dirs.length; ++i) {
                boolean dirExists = this.openDir(dirs[i]);
                if (dirExists) continue;
                this.sftp.mkdir(dirs[i]);
                this.sftp.cd(dirs[i]);
            }
        }
        catch (SftpException e) {
            this.logger.error("mkDir Exception : " + (Object)((Object)e));
        }
    }

    @Override
    public boolean openDir(String directory) {
        try {
            this.sftp.cd(directory);
            return true;
        }
        catch (SftpException e) {
            this.logger.error("openDir Exception : " + (Object)((Object)e));
            return false;
        }
    }

    @Override
    public void rename(String oldPath, String newPath) {
        try {
            this.sftp.rename(oldPath, newPath);
        }
        catch (Exception e) {
            this.logger.error("openDir Exception\uff1a" + e);
        }
    }
}

