/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.file.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.github.pagehelper.StringUtil;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapAuthenticationService;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class FileDownloadController
extends BaseController {
    private Logger logger = LoggerFactory.getLogger(FileDownloadController.class);
    private static int CONNECT_SUCCESS = 200;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    IHapAuthenticationService hapAuthenticationService;
    @Value(value="${markImgPath}")
    private String markImgPath;

    @RequestMapping(value={"/app/fileDownload"})
    @ResponseBody
    public void fileDownload(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="fileId") String fileId, @RequestParam(value="token") String token) {
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        String charset = "UTF-8";
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        try {
            JSONObject json = new JSONObject();
            json.put("fileId", (Object)fileId);
            json.put("token", (Object)token);
            String params = json.toString();
            URL myURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)myURL.openConnection();
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestMethod("POST");
            if (!params.isEmpty()) {
                connection.setDoOutput(true);
            }
            if (hapInterfaceHeader.getAuthFlag().equals("Y")) {
                this.processAuthAuthorization(hapInterfaceHeader, connection);
            }
            connection.connect();
            if (!params.isEmpty()) {
                OutputStream responseCode = connection.getOutputStream();
                responseCode.write(params.getBytes("UTF-8"));
                responseCode.flush();
                responseCode.close();
            }
            if (connection.getResponseCode() != CONNECT_SUCCESS) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }
            InputStream in = connection.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            String cacheControl = connection.getHeaderField("cache-control");
            String contentType = connection.getHeaderField("Content-Type");
            String contentLength = connection.getHeaderField("Content-Length");
            String disposition = connection.getHeaderField("Content-disposition");
            response.setContentType(contentType);
            response.setContentLength(Integer.valueOf(contentLength).intValue());
            response.setHeader("cache-control", cacheControl);
            response.setHeader("pragma", "public");
            response.setHeader("Content-Disposition", disposition);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("IOException", (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"/app/hap/fileUpload"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject fileUpload(HttpServletRequest request) {
        JSONObject json = new JSONObject();
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                json.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest)request;
                Map fileMap = req.getFileMap();
                HashMap<String, String> textMap = new HashMap<String, String>();
                if (fileMap != null) {
                    for (Map.Entry next : fileMap.entrySet()) {
                        String result;
                        String fileKey = (String)next.getKey();
                        MultipartFile filePart = (MultipartFile)next.getValue();
                        String fileName = ((CommonsMultipartFile)filePart).getFileItem().getName();
                        InputStream inputStream = filePart.getInputStream();
                        Map parameterMap = request.getParameterMap();
                        if (parameterMap != null) {
                            Set entries = parameterMap.entrySet();
                            for (Map.Entry entry : entries) {
                                String key = (String)entry.getKey();
                                String[] value = (String[])entry.getValue();
                                if (value == null || value.length <= 0) continue;
                                textMap.put(key, value[0]);
                            }
                        }
                        if ((result = this.formUpload(hapInterfaceHeader, textMap, fileName, inputStream, "files")) != "-1") {
                            json.put("result", (Object)"S");
                            textMap.put("attachments", result);
                            json.put("response", textMap);
                            continue;
                        }
                        json.put("result", (Object)"E");
                    }
                }
            }
        }
        catch (Exception e) {
            json.put("result", (Object)"E");
            json.put("error", (Object)e.getMessage());
        }
        return json;
    }

    private void processAuthAuthorization(HapInterfaceHeader headerAndLineDTO, HttpURLConnection connection) {
        if ("BASIC_AUTH".equalsIgnoreCase(headerAndLineDTO.getAuthType())) {
            String e = headerAndLineDTO.getAuthUsername() + ":" + headerAndLineDTO.getAuthPassword();
            String accessToken = new String(Base64.encodeBase64((byte[])e.getBytes()));
            connection.setRequestProperty("Authorization", "Basic " + accessToken);
        } else {
            String accessToken = this.hapAuthenticationService.getToken(headerAndLineDTO);
            if (StringUtil.isEmpty(accessToken)) {
                this.logger.error("get access_token failure,check your config");
                throw new RuntimeException("get access_token failure,check your config");
            }
            connection.setRequestProperty("Authorization", "Bearer " + accessToken);
        }
    }

    @RequestMapping(value={"/app/fileUploadSvc"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject fileUploadRequest(HttpServletRequest request) {
        InputStream inputStream = null;
        JSONObject json = new JSONObject();
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        String markFlag = request.getParameter("markFlag");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        try {
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                json.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest req = (MultipartHttpServletRequest)request;
                Map fileMap = req.getFileMap();
                HashMap<String, String> textMap = new HashMap<String, String>();
                if (fileMap != null) {
                    for (Map.Entry next : fileMap.entrySet()) {
                        String result;
                        String fileKey = (String)next.getKey();
                        MultipartFile filePart = (MultipartFile)next.getValue();
                        String fileName = ((CommonsMultipartFile)filePart).getFileItem().getName();
                        inputStream = filePart.getInputStream();
                        Map parameterMap = request.getParameterMap();
                        if (parameterMap != null) {
                            Set entries = parameterMap.entrySet();
                            for (Map.Entry entry : entries) {
                                String key = (String)entry.getKey();
                                String[] value = (String[])entry.getValue();
                                if (value == null || value.length <= 0) continue;
                                textMap.put(key, value[0]);
                            }
                        }
                        if ((result = this.formUpload(hapInterfaceHeader, textMap, fileName, inputStream, "file")) != "-1") {
                            json.put("result", (Object)"S");
                            textMap.put("attachment_id", result);
                            json.put("response", textMap);
                            continue;
                        }
                        json.put("result", (Object)"E");
                    }
                }
            }
        }
        catch (Exception e) {
            json.put("result", (Object)"E");
            json.put("error", (Object)e.getMessage());
        }
        return json;
    }

    @RequestMapping(value={"/app/fileViewSvc"})
    @ResponseBody
    @Timed
    public void fileViewSvc(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="attachment_id") String attId) {
        String charset = "UTF-8";
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        try {
            url = url + (url.indexOf("?") > 0 ? "&attachment_id=" : "?attachment_id=") + attId;
            URL myURL = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)myURL.openConnection();
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + connection.getResponseCode());
            }
            InputStream in = connection.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            String cacheControl = connection.getHeaderField("cache-control");
            String contentType = connection.getHeaderField("Content-Type");
            String contentLength = connection.getHeaderField("Content-Length");
            String disposition = connection.getHeaderField("Content-disposition");
            response.setContentType(contentType);
            response.setContentLength(Integer.valueOf(contentLength).intValue());
            response.setHeader("cache-control", cacheControl);
            response.setHeader("pragma", "public");
            response.setHeader("Content-Disposition", disposition);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formUpload(HapInterfaceHeader headerAndLineDTO, Map<String, String> textMap, String fileName, InputStream inputStream, String files) {
        String res = "";
        HttpURLConnection conn = null;
        String uploadUrl = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        String BOUNDARY = "----******************************";
        try {
            StringBuffer strBuf;
            URL url = new URL(uploadUrl);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            if (headerAndLineDTO.getAuthFlag().equals("Y")) {
                this.processAuthAuthorization(headerAndLineDTO, conn);
            }
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (textMap != null) {
                StringBuffer strBuf2 = new StringBuffer();
                for (Map.Entry<String, String> entry : textMap.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    strBuf2.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf2.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                    strBuf2.append(inputValue);
                }
                ((OutputStream)out).write(strBuf2.toString().getBytes());
            }
            if (fileName != "") {
                String filename = fileName;
                strBuf = new StringBuffer();
                strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                if (files.equals("files")) {
                    strBuf.append("Content-Disposition: form-data; name=\"files\"; filename=\"" + filename + "\"\r\n");
                } else {
                    strBuf.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + filename + "\"\r\n");
                }
                this.logger.info("filename======>" + filename);
                String contentType = this.getContentType(filename);
                strBuf.append("Content-Type:" + contentType + "\r\n\r\n");
                this.logger.info("contentType======>" + contentType);
                ((OutputStream)out).write(strBuf.toString().getBytes());
                DataInputStream in = new DataInputStream(inputStream);
                int bytes = 0;
                byte[] bufferOut = new byte[1024];
                while ((bytes = in.read(bufferOut)) != -1) {
                    ((OutputStream)out).write(bufferOut, 0, bytes);
                }
                in.close();
            }
            byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
            ((OutputStream)out).write(endData);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            strBuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line);
            }
            res = strBuf.toString();
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\u8fd4\u56de\u4fe1\u606f====>" + res);
            reader.close();
            reader = null;
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\uff0c\u8fd4\u56de\u72b6\u6001\u7801====>" + conn.getResponseCode());
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\uff0c\u53d1\u9001POST\u8bf7\u6c42\u51fa\u9519==>" + uploadUrl);
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\uff0c\u5f02\u5e38\u4fe1\u606f==>" + e.getMessage());
            this.logger.info("Exception", e.fillInStackTrace());
            String string = "-1";
            return string;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return res;
    }

    private String getContentType(String filename) {
        String type = null;
        Path path = Paths.get(filename, new String[0]);
        try {
            type = Files.probeContentType(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return type;
    }

    public static void main(String[] args) {
        String fileName = "\u6d4b\u8bd5.jpg";
        Path path = Paths.get(fileName, new String[0]);
        String fileType = "";
        try {
            fileType = Files.probeContentType(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.print(fileType);
    }

    public void markFont(BufferedImage bufImg, Image img, String text, Font font, Color color, int x, int y) {
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(img, 0, 0, bufImg.getWidth(), bufImg.getHeight(), null);
        g.setColor(color);
        g.setFont(font);
        g.drawString(text, x, y);
        g.dispose();
    }

    public void markImg(BufferedImage bufImg, Image img, Image markImg, int width, int height, int x, int y) {
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(img, 0, 0, bufImg.getWidth(), bufImg.getHeight(), null);
        g.drawImage(markImg, x, y, width, height, null);
        g.dispose();
    }

    public InputStream addFontMark(InputStream inputStream, String text, String fileTypeName, Font font, Color color, int x, int y) {
        ByteArrayInputStream inputStreamMark = null;
        try {
            BufferedImage img = null;
            if (inputStream != null) {
                img = ImageIO.read(inputStream);
            }
            int imgWidth = ((Image)img).getWidth(null);
            int imgHeight = ((Image)img).getHeight(null);
            BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, 1);
            this.markFont(bufImg, img, text, font, color, x, y);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutput = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageIO.write((RenderedImage)bufImg, fileTypeName, imageOutput);
            inputStreamMark = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return inputStreamMark;
    }

    public InputStream addImgMark(InputStream inputStream, String markImg, String fileTypeName, int x, int y) {
        ByteArrayInputStream inputStreamMark = null;
        File markImgFile = null;
        BufferedImage img = null;
        Image mark = null;
        try {
            if (markImg != null) {
                markImgFile = new File(markImg);
            }
            if (inputStream != null) {
                img = ImageIO.read(inputStream);
            }
            if (markImgFile != null && markImgFile.exists() && markImgFile.isFile() && markImgFile.canRead()) {
                mark = ImageIO.read(markImgFile);
            }
            int imgWidth = ((Image)img).getWidth(null);
            int imgHeight = ((Image)img).getHeight(null);
            int srcImgMarkWidth = mark.getWidth(null);
            int srcImgMarkHeight = mark.getHeight(null);
            BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, 1);
            this.markImg(bufImg, img, mark, srcImgMarkWidth, srcImgMarkHeight, x, y);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageOutputStream imageOutput = ImageIO.createImageOutputStream(byteArrayOutputStream);
            ImageIO.write((RenderedImage)bufImg, fileTypeName, imageOutput);
            inputStreamMark = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return inputStreamMark;
    }
}

