/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.faceCard.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.faceCard.dto.FaceCard;
import com.hand.app.faceCard.service.IFaceCardService;
import com.hand.app.faceCard.utils.HttpUtil;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.ISysConfigService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FaceCardServiceImpl
extends BaseServiceImpl<FaceCard>
implements IFaceCardService {
    private static String CARD_URL = "http://faceid.shumaidata.com/face_idcard/verify";
    @Autowired
    ISysConfigService sysConfigService;
    @Value(value="#{configProperties['face.check.enable']}")
    private String enableFace;

    @Override
    public JSONObject faceCheck(IRequest request, FaceCard faceCard) {
        JSONObject jsonResult = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("idcard", (Object)faceCard.getIdNumber());
        param.put("image", (Object)faceCard.getFaceImage());
        param.put("name", (Object)faceCard.getName());
        String appCode = this.sysConfigService.getConfigValue("ALY.FACEID.APPCODE");
        if (this.enableFace.equals("true")) {
            jsonResult = HttpUtil.postJson(CARD_URL, param, appCode);
        }
        return this.jsonToFace(jsonResult, faceCard);
    }

    JSONObject jsonToFace(JSONObject json, FaceCard face) {
        JSONObject resultJson = new JSONObject();
        face.setFaceId(UUID.randomUUID().toString());
        if (json != null) {
            JSONObject result;
            if (json.containsKey((Object)"code") && json.containsKey((Object)"message")) {
                face.setCode(json.getString("code"));
                face.setMessage(json.getString("message"));
            }
            if (json.containsKey((Object)"result")) {
                result = json.getJSONObject("result");
                face.setRes(result.getString("res"));
                face.setDescription(result.getString("description"));
                if (result.containsKey((Object)"score")) {
                    face.setScore(result.getString("score"));
                }
                resultJson.put("return", (Object)json.getJSONObject("result"));
            }
            resultJson.put("code", (Object)"S");
            resultJson.put("message", (Object)"\u4eba\u8bc1\u5bf9\u6bd4\u6210\u529f");
            if (this.enableFace.equals("false")) {
                result = new JSONObject();
                result.put("score", (Object)"0.98232");
                resultJson.put("return", (Object)result);
            }
        } else if (this.enableFace.equals("false")) {
            resultJson.put("code", (Object)"S");
            resultJson.put("message", (Object)"\u4eba\u8bc1\u5bf9\u6bd4\u6210\u529f");
            JSONObject result = new JSONObject();
            result.put("score", (Object)"0.98232");
            resultJson.put("return", (Object)result);
        } else {
            resultJson.put("code", (Object)"E");
            resultJson.put("message", (Object)"\u4eba\u8bc1\u5bf9\u6bd4\u5931\u8d25");
        }
        face.set__status("add");
        this.mapper.insertSelective(face);
        return resultJson;
    }
}

