/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esignHclc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.esign.utils.AlgorithmHelper;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.mapper.SignInfoHclcMapper;
import com.hand.app.esignHclc.service.IOrganSignInfoHclcService;
import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.app.esignHclc.utils.SignHclcUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.intergration.utils.HttpUtil;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrganSignInfoHclcServiceImpl
extends BaseServiceImpl<SignUserInfoHclc>
implements IOrganSignInfoHclcService {
    @Value(value="${tsign.project.id}")
    private String projectId;
    @Value(value="${tsign.project.secret}")
    private String projectSecret;
    @Value(value="${tsign.api.notifyUrl}")
    private String notifyUrl;
    @Value(value="${tsign.face.api.appId}")
    private String appId;
    @Value(value="${tsign.face.api.secret}")
    private String secret;
    @Autowired
    private ISignInfoHclcFaceService signInfoHclcFaceService;
    @Autowired
    private ISignInfoHclcService iSignInfoHclcService;
    @Autowired
    private SignInfoHclcMapper signInfoHclcMapper;
    public static final String indivSysName = "HCLC_FACE_API";
    public static final String tokenApiName = "getToken";
    public static final String orgApiName = "getOrgAuthUrl";
    public static final String getOrgIdApiName = "getOrgByThirdId";
    public static final String signatureSysName = "HCLC_ELECTRONIC_SIGNATURE";
    public static final String organsApiName = "outerOrgans";
    public static final String deleteApiName = "organizationsDelete";
    public static final String unBindApiName = "orgUnbindAcc";
    public static final String bindApiName = "orgBindAcc";
    private static final String HASH_ALGORITHM = "HmacSHA256";
    public static final String hclcSysName = "HCL_UPLOAD_FILE";
    public static final String getManagerStatus = "GetAdminFlag";
    private static final int HTTP_OK = 200;
    @Autowired
    IHapInterfaceHeaderService headerService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Map<String, Object> getOrganIndividualFaceUrl(IRequest iRequest, SignUserInfoHclc info) {
        SignUserInfoHclc signInfoHclc;
        Map<String, Object> mapOrgan;
        block57: {
            String accountStatus;
            block56: {
                String isManager;
                mapOrgan = new HashMap<String, Object>();
                if (Objects.isNull(info.getOpenId()) || "undefined".equalsIgnoreCase(info.getOpenId())) {
                    this.logger.error("\u5173\u952e\u53c2\u6570openId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25!");
                    mapOrgan.put("code", "1");
                    mapOrgan.put("message", "\u5173\u952e\u53c2\u6570openId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25!");
                    return mapOrgan;
                }
                signInfoHclc = (SignUserInfoHclc)this.mapper.selectByPrimaryKey(info);
                accountStatus = null;
                String getUrlType = null;
                if (info.getAgentType().compareTo(1L) == 0) {
                    isManager = "Y";
                } else {
                    JSONObject param = new JSONObject();
                    param.put("org_name", (Object)info.getName());
                    param.put("agentIdNo", (Object)info.getAgentIdNo());
                    isManager = this.getManagerStatus(param);
                }
                if (isManager == null) {
                    isManager = "N";
                }
                SignUserInfoHclc managerSignInfo = new SignUserInfoHclc();
                managerSignInfo.setIdNo(info.getIdNo());
                managerSignInfo.setIsManagerFlag("Y");
                managerSignInfo.setAuthFlag("Y");
                List<SignUserInfoHclc> managerList = this.mapper.select(managerSignInfo);
                if (Objects.isNull(managerList) || managerList.size() == 0) {
                    if ("N".equalsIgnoreCase(isManager)) {
                        this.logger.error("\u8bf7\u5148\u5b8c\u6210\u4f01\u4e1a\u6cd5\u4eba\u6216\u7ba1\u7406\u4eba\u5458\u6ce8\u518c!");
                        mapOrgan.put("code", "14");
                        mapOrgan.put("message", "\u8bf7\u5148\u5b8c\u6210\u4f01\u4e1a\u6cd5\u4eba\u6216\u7ba1\u7406\u4eba\u5458\u6ce8\u518c\uff01");
                        return mapOrgan;
                    }
                } else {
                    managerSignInfo = managerList.get(0);
                }
                if (Objects.isNull(signInfoHclc)) {
                    info.setCtitype(2L);
                    info.setAuthFlag("N");
                    if ("N".equalsIgnoreCase(isManager)) {
                        info.setIsManagerFlag("N");
                        info.setManagerAuthFlag("N");
                    } else {
                        info.setIsManagerFlag("Y");
                        info.setManagerAuthFlag("Y");
                    }
                    signInfoHclc = this.insertSelective(iRequest, info);
                    accountStatus = "AGENT_ADD";
                    getUrlType = "AGENT";
                } else {
                    signInfoHclc.setCtitype(2L);
                    signInfoHclc.setAgentType(info.getAgentType());
                    if ("Y".equalsIgnoreCase(signInfoHclc.getAuthFlag())) {
                        mapOrgan.put("code", "2");
                        mapOrgan.put("message", "\u673a\u6784\u8ba4\u8bc1\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u9a8c\u8bc1\uff01");
                        return mapOrgan;
                    }
                    if (!(info.getAgentIdNo().equalsIgnoreCase(signInfoHclc.getAgentIdNo()) && info.getAgentName().equalsIgnoreCase(signInfoHclc.getAgentName()) && info.getMobile().equalsIgnoreCase(signInfoHclc.getMobile()))) {
                        if (Objects.isNull(signInfoHclc.getAgentAccountId())) {
                            accountStatus = "AGENT_ADD";
                            getUrlType = "AGENT";
                        } else {
                            accountStatus = "AGENT_MODIFY";
                            getUrlType = "AGENT";
                        }
                    } else {
                        SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                        if (Objects.nonNull(signInfoHclc.getFaceAuthId())) {
                            signInfoHclcFace.setAuthId(signInfoHclc.getFaceAuthId());
                            signInfoHclcFace = this.signInfoHclcFaceService.selectByPrimaryKey(iRequest, signInfoHclcFace);
                            if ("SUCCESS".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                                if (Objects.nonNull(managerSignInfo.getOpenId())) {
                                    signInfoHclc.setAccountId(managerSignInfo.getAccountId());
                                    signInfoHclc.setOrgAuthId(managerSignInfo.getOrgAuthId());
                                    signInfoHclc.setAuthFlag("Y");
                                    this.updateByPrimaryKey(iRequest, signInfoHclc);
                                    this.createOrgPersonInfo(signInfoHclc.getOpenId());
                                    mapOrgan.put("code", "2");
                                    mapOrgan.put("message", "\u673a\u6784\u8ba4\u8bc1\u5df2\u5b8c\u6210\uff01");
                                    return mapOrgan;
                                }
                                getUrlType = "ORG";
                            } else {
                                if (!"FAIL".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                                    mapOrgan.put("code", "0");
                                    mapOrgan.put("url", signInfoHclcFace.getUrl());
                                    mapOrgan.put("message", "\u83b7\u53d6url\u6210\u529f\uff01");
                                    return mapOrgan;
                                }
                                accountStatus = "AGENT_EXISTS";
                                getUrlType = "AGENT";
                            }
                        } else if (Objects.isNull(signInfoHclc.getAgentAccountId())) {
                            accountStatus = "AGENT_ADD";
                            getUrlType = "AGENT";
                        } else {
                            accountStatus = "AGENT_EXISTS";
                            getUrlType = "AGENT";
                        }
                    }
                }
                if (!"AGENT".equalsIgnoreCase(getUrlType)) break block56;
                SignUserInfoHclc agentSignInfo = new SignUserInfoHclc();
                agentSignInfo.setOpenId(info.getOpenId());
                agentSignInfo.setIdNo(info.getAgentIdNo());
                agentSignInfo.setMobile(info.getMobile());
                agentSignInfo.setName(info.getAgentName());
                agentSignInfo.setCtitype(signInfoHclc.getCtitype());
                if (!"AGENT_EXISTS".equalsIgnoreCase(accountStatus)) {
                    if ("AGENT_MODIFY".equalsIgnoreCase(accountStatus)) {
                        if (Objects.nonNull(signInfoHclc.getAccountId())) {
                            mapOrgan = this.deleteOrgansAccount(iRequest, signInfoHclc);
                            if (!"0".equalsIgnoreCase(mapOrgan.get("code").toString()) && !"40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                                return mapOrgan;
                            }
                            signInfoHclc.setAccountId("");
                            signInfoHclc.setIdNo(info.getIdNo());
                            signInfoHclc.setName(info.getName());
                            signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                            signInfoHclc.setLegalName(info.getLegalName());
                            signInfoHclc.setOrgAuthId(null);
                        }
                        agentSignInfo.setAccountId(signInfoHclc.getAgentAccountId());
                        mapOrgan = this.iSignInfoHclcService.deletePersonAccount(iRequest, agentSignInfo);
                        if ("0".equalsIgnoreCase(mapOrgan.get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                            agentSignInfo.setAccountId("");
                            signInfoHclc.setAgentAccountId("");
                            signInfoHclc.setAuthAgentAccountId("");
                            signInfoHclc.setAgentIdNo(info.getAgentIdNo());
                            signInfoHclc.setAgentName(info.getAgentName());
                            if (signInfoHclc.getAgentType().compareTo(1L) == 0) {
                                signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                                signInfoHclc.setLegalName(info.getLegalName());
                            }
                            signInfoHclc.setMobile(info.getMobile());
                            signInfoHclc.setAgentType(info.getAgentType());
                            signInfoHclc.setFaceAuthId(null);
                        }
                    }
                    if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        mapOrgan = this.iSignInfoHclcService.addPersonAccount(agentSignInfo);
                        if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                            signInfoHclc.setAgentAccountId(mapOrgan.get("accountId").toString());
                            signInfoHclc.setSealId(mapOrgan.get("sealId").toString());
                            if ("AGENT_ADD".equalsIgnoreCase(accountStatus)) {
                                signInfoHclc.setAgentIdNo(info.getAgentIdNo());
                                signInfoHclc.setAgentName(info.getAgentName());
                                if (signInfoHclc.getAgentType().compareTo(1L) == 0) {
                                    signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                                    signInfoHclc.setLegalName(info.getLegalName());
                                }
                                signInfoHclc.setMobile(info.getMobile());
                                signInfoHclc.setAgentType(info.getAgentType());
                            }
                        }
                        signInfoHclc.setCreateCode(mapOrgan.get("code").toString());
                        signInfoHclc.setCreateMessage(mapOrgan.get("message").toString());
                    }
                }
                if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                    SignHclcUtils signHclcUtils = new SignHclcUtils();
                    agentSignInfo = SignHclcUtils.initProject(agentSignInfo, this.appId, this.secret, this.notifyUrl);
                    String tokenApiUrl = this.iSignInfoHclcService.getApiUrl(indivSysName, tokenApiName);
                    this.logger.debug("upload url: {}", (Object)tokenApiUrl);
                    String token = signHclcUtils.getFaceApiToken(tokenApiUrl, agentSignInfo.getAppId(), agentSignInfo.getSecret());
                    if (Objects.nonNull(token)) {
                        agentSignInfo.setRedirectUrl(info.getRedirectUrl());
                        mapOrgan = this.iSignInfoHclcService.getFaceUrlHttp(iRequest, agentSignInfo, token);
                        if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                            signInfoHclc.setFaceAuthId(Long.valueOf(mapOrgan.get("faceAuthId").toString()));
                        }
                        break block57;
                    } else {
                        mapOrgan.put("code", "2");
                        mapOrgan.put("message", "\u83b7\u53d6\u9274\u6743Token\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
                break block57;
            }
            SignUserFaceHclc signInfoHclcOrg = new SignUserFaceHclc();
            if (Objects.nonNull(signInfoHclc.getOrgAuthId())) {
                signInfoHclcOrg.setAuthId(signInfoHclc.getOrgAuthId());
                signInfoHclcOrg = this.signInfoHclcFaceService.selectByPrimaryKey(iRequest, signInfoHclcOrg);
            }
            if (!info.getIdNo().equalsIgnoreCase(signInfoHclc.getIdNo()) || !info.getName().equalsIgnoreCase(signInfoHclc.getName()) || Objects.nonNull(signInfoHclc.getLegalIdNo()) && !info.getLegalIdNo().equalsIgnoreCase(signInfoHclc.getLegalIdNo()) || !info.getLegalName().equalsIgnoreCase(signInfoHclc.getLegalName())) {
                if (Objects.nonNull(signInfoHclcOrg) && "SUCCESS".equalsIgnoreCase(signInfoHclcOrg.getAuthStatus())) {
                    this.createOrgPersonInfo(signInfoHclc.getOpenId());
                    mapOrgan.put("code", "10");
                    mapOrgan.put("message", "\u4f01\u4e1a\u5bf9\u516c\u6253\u6b3e\u8ba4\u8bc1\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u9a8c\u8bc1\uff01");
                    return mapOrgan;
                }
                accountStatus = Objects.isNull(signInfoHclc.getAccountId()) ? "ORG_ADD" : "ORG_MODIFY";
            } else if (Objects.nonNull(signInfoHclcOrg.getAuthId())) {
                if ("SUCCESS".equalsIgnoreCase(signInfoHclcOrg.getAuthStatus())) {
                    this.createOrgPersonInfo(signInfoHclc.getOpenId());
                    mapOrgan.put("code", "10");
                    mapOrgan.put("message", "\u4f01\u4e1a\u5bf9\u516c\u6253\u6b3e\u8ba4\u8bc1\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u9a8c\u8bc1\uff01");
                    return mapOrgan;
                }
                if (!"FAIL".equalsIgnoreCase(signInfoHclcOrg.getAuthStatus())) {
                    mapOrgan.put("code", "0");
                    mapOrgan.put("url", signInfoHclcOrg.getUrl());
                    mapOrgan.put("message", "\u83b7\u53d6url\u6210\u529f\uff01");
                    return mapOrgan;
                }
                accountStatus = "ORG_EXISTS";
            } else {
                accountStatus = Objects.isNull(signInfoHclc.getAccountId()) ? "ORG_ADD" : "ORG_EXISTS";
            }
            if (!"ORG_EXISTS".equalsIgnoreCase(accountStatus)) {
                if ("ORG_MODIFY".equalsIgnoreCase(accountStatus) && ("0".equalsIgnoreCase((mapOrgan = this.deleteOrgansAccount(iRequest, signInfoHclc)).get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString()))) {
                    signInfoHclc.setAccountId("");
                    signInfoHclc.setIdNo(info.getIdNo());
                    signInfoHclc.setName(info.getName());
                    signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                    signInfoHclc.setLegalName(info.getLegalName());
                    signInfoHclc.setOrgAuthId(null);
                }
                if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString()) || "40051667".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                    SignUserInfoHclc ogrSignInfo = new SignUserInfoHclc();
                    ogrSignInfo.setAgentAccountId(signInfoHclc.getAgentAccountId());
                    ogrSignInfo.setAgentIdNo(signInfoHclc.getAgentIdNo());
                    ogrSignInfo.setLegalIdNo(info.getLegalIdNo());
                    ogrSignInfo.setLegalName(info.getLegalName());
                    ogrSignInfo.setIdNo(info.getIdNo());
                    ogrSignInfo.setName(info.getName());
                    ogrSignInfo.setOpenId(signInfoHclc.getOpenId());
                    mapOrgan = this.addOrgansAccount(ogrSignInfo);
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        signInfoHclc.setAccountId(mapOrgan.get("organizeId").toString());
                        if ("ORG_ADD".equalsIgnoreCase(accountStatus)) {
                            signInfoHclc.setIdNo(info.getIdNo());
                            signInfoHclc.setName(info.getName());
                            signInfoHclc.setLegalIdNo(info.getLegalIdNo());
                            signInfoHclc.setLegalName(info.getLegalName());
                        }
                    }
                    signInfoHclc.setCreateCode(mapOrgan.get("code").toString());
                    signInfoHclc.setCreateMessage(mapOrgan.get("message").toString());
                }
            }
            if (mapOrgan.size() == 0 || "0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                SignHclcUtils signHclcUtils = new SignHclcUtils();
                signInfoHclc = SignHclcUtils.initProject(signInfoHclc, this.appId, this.secret, this.notifyUrl);
                String tokenApiUrl = this.iSignInfoHclcService.getApiUrl(indivSysName, tokenApiName);
                this.logger.debug("upload url: {}", (Object)tokenApiUrl);
                String token = signHclcUtils.getFaceApiToken(tokenApiUrl, signInfoHclc.getAppId(), signInfoHclc.getSecret());
                if (Objects.nonNull(token)) {
                    signInfoHclc.setRedirectUrl(info.getRedirectUrl());
                    mapOrgan = this.getOrgAuthUrlHttp(iRequest, signInfoHclc, token);
                    if ("0".equalsIgnoreCase(mapOrgan.get("code").toString())) {
                        signInfoHclc.setOrgAuthId(Long.valueOf(mapOrgan.get("orgAuthId").toString()));
                    }
                } else {
                    mapOrgan.put("code", "2");
                    mapOrgan.put("message", "\u83b7\u53d6\u9274\u6743Token\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
        }
        this.updateByPrimaryKey(iRequest, signInfoHclc);
        return mapOrgan;
    }

    @Override
    public void createOrgPersonInfo(String openId) {
        SignUserInfoHclc userInfoHclc = new SignUserInfoHclc();
        userInfoHclc.setOpenId(openId);
        userInfoHclc = (SignUserInfoHclc)this.signInfoHclcMapper.selectByPrimaryKey(userInfoHclc);
        SignUserInfoHclc personInfoHclc = new SignUserInfoHclc();
        personInfoHclc.setOpenId(openId + "personHclc");
        personInfoHclc = (SignUserInfoHclc)this.signInfoHclcMapper.selectByPrimaryKey(personInfoHclc);
        if (Objects.isNull(personInfoHclc)) {
            personInfoHclc = new SignUserInfoHclc();
            personInfoHclc.setOpenId(openId + "personHclc");
            personInfoHclc.setIdNo(userInfoHclc.getAgentIdNo());
            personInfoHclc.setName(userInfoHclc.getAgentName());
            personInfoHclc.setMobile(userInfoHclc.getMobile());
            personInfoHclc.setAccountId(userInfoHclc.getAgentAccountId());
            personInfoHclc.setSealId(userInfoHclc.getSealId());
            personInfoHclc.setIsManagerFlag("N");
            personInfoHclc.setManagerAuthFlag("N");
            personInfoHclc.setCtitype(1L);
            personInfoHclc.setAuthFlag("Y");
            this.signInfoHclcMapper.insert(personInfoHclc);
        }
    }

    @Override
    public String getManagerStatus(JSONObject params) {
        try {
            String url = this.iSignInfoHclcService.getApiUrl(hclcSysName, getManagerStatus);
            this.logger.debug("sign flow url: {}", (Object)url);
            HashMap<String, String> headInfo = new HashMap<String, String>();
            headInfo.put("Content-Type", "application/x-www-form-urlencoded");
            JSONObject requestData = new JSONObject();
            requestData.put("requestData", (Object)params.toString());
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, params, headInfo, "application/x-www-form-urlencoded");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("true".equalsIgnoreCase(jsonResult.getString("success"))) {
                return jsonResult.getJSONObject("result").getJSONObject("json").getString("admin_flag");
            }
            return "N";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "N";
        }
    }

    @Override
    public List<SignUserInfoHclc> getOrganIndividualInfoQuery(IRequest iRequest, SignUserInfoHclc info) {
        List<SignUserInfoHclc> signInfoHclcs = this.signInfoHclcMapper.queryAgentInfo(info);
        return signInfoHclcs;
    }

    @Override
    public Map<String, Object> setOrganIndividualAssignment(IRequest iRequest, SignUserInfoHclc info) {
        HashMap<String, Object> mapOrgan = new HashMap<String, Object>();
        try {
            this.signInfoHclcMapper.setOrganIndividualAssignment(info);
            mapOrgan.put("code", "000000");
            mapOrgan.put("message", "\u7ba1\u7406\u6743\u9650\u8f6c\u8ba9\u6210\u529f\uff01");
        }
        catch (Exception e) {
            mapOrgan.put("code", "000005");
            mapOrgan.put("message", "\u7ba1\u7406\u6743\u9650\u8f6c\u8ba9\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return mapOrgan;
    }

    public Map<String, Object> getOrgAuthUrlHttp(IRequest iRequest, SignUserInfoHclc info, String token) {
        SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
        signInfoHclcFace.setOpenId(info.getOpenId());
        signInfoHclcFace.setAuthStatus("NEW");
        signInfoHclcFace.setAuthType("2");
        signInfoHclcFace = this.signInfoHclcFaceService.insertSelective(iRequest, signInfoHclcFace);
        JSONObject json1 = new JSONObject();
        json1.put("contextId", (Object)signInfoHclcFace.getAuthId());
        json1.put("notifyUrl", (Object)info.getNotifyUrl());
        json1.put("redirectUrl", (Object)info.getRedirectUrl());
        JSONObject json2 = new JSONObject();
        json2.put("name", (Object)info.getName());
        json2.put("certNo", (Object)info.getIdNo());
        json2.put("certType", (Object)"ORGANIZATION_USC_CODE");
        if (Objects.nonNull(info.getLegalIdNo()) && !"".equalsIgnoreCase(info.getLegalIdNo())) {
            json2.put("legalRepCertNo", (Object)info.getLegalIdNo());
        }
        json2.put("egalRepCertType", (Object)"INDIVIDUAL_CH_IDCARD");
        json2.put("legalRepName", (Object)info.getLegalName());
        json2.put("agentName", (Object)info.getAgentName());
        json2.put("agentIdNo", (Object)info.getAgentIdNo());
        json2.put("operatorType", (Object)info.getAgentType());
        if ("92".equalsIgnoreCase(info.getIdNo().substring(0, 2))) {
            json2.put("organizationType", (Object)2);
        } else {
            json2.put("organizationType", (Object)1);
        }
        String[] str = new String[]{};
        JSONObject json3 = new JSONObject();
        str = Objects.nonNull(info.getLegalIdNo()) && !"".equalsIgnoreCase(info.getLegalIdNo()) ? new String[]{"name", "certNo", "legalRepName", "legalRepCertNo", "agentName", "agentIdNo"} : new String[]{"name", "certNo", "legalRepName", "agentName", "agentIdNo"};
        json3.put("indivUneditableInfo", (Object)str);
        JSONObject result = new JSONObject();
        result.put("authType", (Object)"ORG_BANK_TRANSFER");
        result.put("contextInfo", (Object)json1);
        result.put("orgEntity", (Object)json2);
        result.put("configParams", (Object)json3);
        JSONObject json = new JSONObject((Map)result);
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("X-Tsign-Open-App-Id", info.getAppId());
        headInfo.put("X-Tsign-Open-Token", token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String orgApiurl = this.iSignInfoHclcService.getApiUrl(indivSysName, orgApiName);
            this.logger.debug("upload url: {}", (Object)orgApiurl);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(orgApiurl, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                signInfoHclcFace.setFlowId(data.getString("flowId"));
                signInfoHclcFace.setUrl(data.getString("url"));
                signInfoHclcFace.setShortLink(data.getString("shortLink"));
                signInfoHclcFace.setAuthStatus("AUTHING");
                map.put("code", "0");
                map.put("orgAuthId", signInfoHclcFace.getAuthId());
                map.put("url", data.getString("url"));
                map.put("AuthType", "ORG");
                map.put("message", "\u83b7\u53d6url\u6210\u529f\uff01");
            } else {
                map.put("code", jsonResult.getString("code"));
                map.put("message", "\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25," + jsonResult.getString("message"));
            }
            signInfoHclcFace.setReturnCode(jsonResult.getString("code"));
            signInfoHclcFace.setReturnMessage(jsonResult.getString("message"));
            this.signInfoHclcFaceService.updateByPrimaryKey(iRequest, signInfoHclcFace);
        }
        catch (Exception e) {
            map.put("code", "17");
            map.put("message", "\u8bbf\u95eee\u7b7e\u5b9d\u7ec4\u7ec7\u673a\u6784\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25\uff0c" + e.getMessage());
            signInfoHclcFace.setReturnCode("3");
            signInfoHclcFace.setReturnMessage(e.getMessage());
            this.signInfoHclcFaceService.updateByPrimaryKey(iRequest, signInfoHclcFace);
        }
        return map;
    }

    @Override
    public Map<String, Object> addOrgansAccount(SignUserInfoHclc signInfoHclc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject result = new JSONObject();
        result.put("agentAccountId", (Object)signInfoHclc.getAgentAccountId());
        result.put("agentUniqueId", (Object)signInfoHclc.getOpenId());
        result.put("cardNo", (Object)"");
        result.put("email", (Object)"");
        result.put("legalLicenseNumber", (Object)signInfoHclc.getLegalIdNo());
        result.put("legalLicenseType", (Object)"IDCard");
        result.put("legalMobile", (Object)"");
        result.put("legalName", (Object)signInfoHclc.getLegalName());
        result.put("licenseNumber", (Object)signInfoHclc.getIdNo());
        result.put("licenseType", (Object)"SOCNO");
        result.put("organizeName", (Object)signInfoHclc.getName());
        result.put("organizeNo", (Object)(signInfoHclc.getOpenId() + "-ORG"));
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = this.iSignInfoHclcService.getApiUrl(signatureSysName, organsApiName);
            this.logger.debug("create organs account url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                map.put("organizeId", data.getString("organizeId"));
                map.put("code", "0");
                map.put("message", "\u673a\u6784e\u7b7e\u5b9d\u8d26\u6237\u521b\u5efa\u6210\u529f\uff01");
            } else {
                this.logger.error("create organs account failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u673a\u6784e\u7b7e\u5b9d\u8d26\u6237\u521b\u5efa\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            this.logger.error("create organs account failed, msg:{}", (Object)e.getMessage());
            map.put("code", "000015");
            map.put("message", "\u673a\u6784e\u7b7e\u5b9d\u8d26\u6237\u521b\u5efa\u5931\u8d25\uff0c" + e.getMessage());
        }
        return map;
    }

    @Override
    public Map<String, Object> bindOrgansAgent(SignUserInfoHclc signInfoHclc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject result = new JSONObject();
        result.put("accountId", (Object)signInfoHclc.getAgentAccountId());
        if ("Y".equalsIgnoreCase(signInfoHclc.getIsManagerFlag())) {
            result.put("isDefault", (Object)"1");
        } else {
            result.put("isDefault", (Object)"0");
        }
        result.put("loginId", (Object)signInfoHclc.getAgentAccountId());
        result.put("orgId", (Object)signInfoHclc.getAccountId());
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        System.out.println(this.projectId);
        System.out.println(EncryptedString);
        try {
            String url = this.iSignInfoHclcService.getApiUrl(signatureSysName, bindApiName);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u7ed1\u5b9a\u7ecf\u529e\u4eba\u6210\u529f\uff01");
            } else {
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u7ed1\u5b9a\u7ecf\u529e\u4eba\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            map.put("code", "000004");
            map.put("message", "\u7ed1\u5b9a\u7ecf\u529e\u4eba\u5931\u8d25," + e.getMessage());
        }
        return map;
    }

    @Override
    public Map<String, Object> unBindOrgansAgent(SignUserInfoHclc signInfoHclc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject result = new JSONObject();
        result.put("accountId", (Object)signInfoHclc.getAgentAccountId());
        result.put("loginId", (Object)signInfoHclc.getAgentAccountId());
        result.put("orgId", (Object)signInfoHclc.getAccountId());
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = this.iSignInfoHclcService.getApiUrl(signatureSysName, unBindApiName);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u89e3\u7ed1\u7ecf\u529e\u4eba\u6210\u529f\uff01");
            } else {
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u89e3\u7ed1\u7ecf\u529e\u4eba\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            map.put("code", "000004");
            map.put("message", "\u89e3\u7ed1\u7ecf\u529e\u4eba\u5931\u8d25," + e.getMessage());
        }
        return map;
    }

    @Override
    public Map<String, Object> deleteOrgansAccount(IRequest iRequest, SignUserInfoHclc signInfoHclc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Objects.isNull(signInfoHclc = this.iSignInfoHclcService.selectByPrimaryKey(iRequest, signInfoHclc))) {
            this.logger.debug("\u672a\u627e\u5230\u5bf9\u5e94e\u7b7e\u5b9d\u673a\u6784\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
            map.put("code", "000002");
            map.put("message", "\u672a\u627e\u5230\u5bf9\u5e94e\u7b7e\u5b9d\u673a\u6784\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
            return map;
        }
        if (Objects.isNull(signInfoHclc.getAccountId()) || "".equalsIgnoreCase(signInfoHclc.getAccountId())) {
            this.logger.debug("e\u7b7e\u5b9d\u673a\u6784\u8d26\u6237 accountId: {} \u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u6ce8\u9500\uff01", (Object)signInfoHclc.getAccountId());
            map.put("code", "000012");
            map.put("message", "e\u7b7e\u5b9d\u673a\u6784\u8d26\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u6ce8\u9500\uff01");
            return map;
        }
        if ("N".equalsIgnoreCase(signInfoHclc.getIsManagerFlag())) {
            this.logger.debug("\u975e\u7ba1\u7406\u5458\u7528\u6237\uff0c\u65e0\u9700\u6ce8\u9500\uff01");
            map.put("code", "000003");
            map.put("message", "\u975e\u7ba1\u7406\u5458\u7528\u6237\uff0c\u65e0\u9700\u6ce8\u9500\uff01");
            return map;
        }
        SignUserInfoHclc userInfoHclc = new SignUserInfoHclc();
        List<Object> userInfoHclcs = new ArrayList();
        userInfoHclc.setIdNo(signInfoHclc.getIdNo());
        userInfoHclc.setName(signInfoHclc.getName());
        userInfoHclc.setAuthFlag("Y");
        userInfoHclc.setIsManagerFlag("N");
        userInfoHclcs = this.signInfoHclcMapper.select(userInfoHclc);
        if (Objects.nonNull(userInfoHclcs) && userInfoHclcs.size() > 0) {
            this.logger.debug("\u5b58\u5728\u975e\u7ba1\u7406\u5458\u7ecf\u529e\u4eba\uff0c\u8bf7\u5148\u5b8c\u6210\u7ba1\u7406\u6743\u9650\u8f6c\u79fb\uff0c\u518d\u6ce8\u9500\uff01");
            map.put("code", "000013");
            map.put("message", "\u5b58\u5728\u975e\u7ba1\u7406\u5458\u7ecf\u529e\u4eba\uff0c\u8bf7\u5148\u5b8c\u6210\u7ba1\u7406\u6743\u9650\u8f6c\u79fb\uff0c\u518d\u6ce8\u9500\uff01");
            return map;
        }
        JSONObject result = new JSONObject();
        result.put("organizeId", (Object)signInfoHclc.getAccountId());
        result.put("organizeNo", (Object)(signInfoHclc.getOpenId() + "-ORG"));
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = this.iSignInfoHclcService.getApiUrl(signatureSysName, deleteApiName);
            this.logger.debug("upload url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode")) || "40051667".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                map.put("code", "0");
                map.put("message", "e\u7b7e\u5b9d\u673a\u6784\u7528\u6237\u6ce8\u9500\u6210\u529f\uff01");
            } else {
                this.logger.error("delete organs account failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "e\u7b7e\u5b9d\u673a\u6784\u7528\u6237\u6ce8\u9500\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            this.logger.error("delete organs account failed, msg:{}", (Object)e.getMessage());
            map.put("code", "000013");
            map.put("message", "e\u7b7e\u5b9d\u673a\u6784\u7528\u6237\u6ce8\u9500\u5931\u8d25\uff0c" + e.getMessage());
        }
        return map;
    }

    public Map<String, Object> getByThirdId(SignUserInfoHclc info, String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject headInfo = new JSONObject();
        headInfo.put("X-Tsign-Open-App-Id", (Object)info.getAppId());
        headInfo.put("X-Tsign-Open-Token", (Object)token);
        String param = "thirdPartyUserId=" + info.getIdNo();
        try {
            String orgApiurl = this.iSignInfoHclcService.getApiUrl(indivSysName, getOrgIdApiName) + "?" + param;
            this.logger.debug("upload url: {}", (Object)orgApiurl);
            HttpResponse execute = HttpUtil.getJson(orgApiurl, headInfo);
            String stringResult = null;
            JSONObject responseBody = new JSONObject();
            if (execute != null) {
                int httpReponseCode = execute.getStatusLine().getStatusCode();
                if (httpReponseCode != 200) {
                    responseBody.put("code", (Object)httpReponseCode);
                    responseBody.put("message", (Object)execute.getStatusLine().getReasonPhrase());
                    stringResult = responseBody.toString();
                } else {
                    stringResult = HttpUtil.HttpResponseParseJson(execute);
                }
                JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
                if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                    JSONObject data = jsonResult.getJSONObject("data");
                    map.put("code", "0");
                    map.put("authOrgAccountId", data.getString("orgId"));
                    map.put("message", "\u83b7\u53d6\u8eab\u4efd\u8ba4\u8bc1\u8d26\u6237\u6210\u529f\uff01");
                } else {
                    map.put("code", jsonResult.getString("code"));
                    map.put("message", "\u83b7\u53d6\u8eab\u4efd\u8ba4\u8bc1\u8d26\u6237\u5931\u8d25," + jsonResult.getString("message"));
                }
            } else {
                map.put("code", "10");
                map.put("message", "\u83b7\u53d6\u8eab\u4efd\u8ba4\u8bc1\u8d26\u6237\u53d1\u9001\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8eab\u4efd\u8ba4\u8bc1\u5730\u5740\u4fe1\u606f\uff01");
            }
        }
        catch (Exception e) {
            map.put("code", "9");
            map.put("message", e.getMessage());
        }
        return map;
    }
}

