/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign.utils;

import com.hand.app.esign.utils.FileHelper;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmHelper {
    private static Logger LOG = LoggerFactory.getLogger(AlgorithmHelper.class);

    public static String getXtimevaleSignature(String data, String key, String algorithm, String encoding) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(algorithm);
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(encoding), algorithm);
            mac.init(secretKey);
            mac.update(data.getBytes(encoding));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            LOG.info("\u83b7\u53d6Signature\u7b7e\u540d\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            return null;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            LOG.info("\u83b7\u53d6Signature\u7b7e\u540d\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            return null;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            LOG.info("\u83b7\u53d6Signature\u7b7e\u540d\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
            return null;
        }
        return AlgorithmHelper.byte2hex(mac.doFinal());
    }

    public static String getFileByteString(String filePath) {
        Base64 b64 = new Base64();
        byte[] buffer = FileHelper.getBytes(filePath);
        return b64.encodeToString(buffer);
    }

    public static void saveFileByEncodeStr(String encodeStr, String targetFilePath) {
        Base64 b64 = new Base64();
        byte[] buffer = b64.decode(encodeStr);
        try {
            FileOutputStream fos = new FileOutputStream(targetFilePath);
            fos.write(buffer);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOG.info("Base64\u5b57\u7b26\u4e32\u89e3\u5bc6\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.info("Base64\u5b57\u7b26\u4e32\u89e3\u5bc6\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static String encodeStr(String str) {
        byte[] bytes = str.getBytes();
        Base64 base64 = new Base64();
        bytes = base64.encode(bytes);
        String encodeStr = new String(bytes);
        return encodeStr;
    }

    public static String decodeStr(String encodeStr) {
        byte[] bytes = encodeStr.getBytes();
        Base64 base64 = new Base64();
        bytes = base64.decode(bytes);
        String decodeStr = new String(bytes);
        return decodeStr;
    }

    public static String byte2hex(byte[] data) {
        StringBuilder hash = new StringBuilder();
        for (int n = 0; data != null && n < data.length; ++n) {
            String stmp = Integer.toHexString(data[n] & 0xFF);
            if (stmp.length() == 1) {
                hash.append('0');
            }
            hash.append(stmp);
        }
        return hash.toString();
    }
}

