/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hand.app.esign.bean.AttachmentInfo;
import com.hand.app.esign.bean.SignPage;
import com.hand.app.esign.dto.PersonData;
import com.hand.app.esign.dto.SignHistory;
import com.hand.app.esign.dto.SignInfo;
import com.hand.app.esign.mapper.PersonDataMapper;
import com.hand.app.esign.service.ISignHistoryService;
import com.hand.app.esign.service.ISignInfoService;
import com.hand.app.esign.utils.SignUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.timevale.esign.sdk.tech.bean.AccountProfile;
import com.timevale.esign.sdk.tech.bean.PersonBean;
import com.timevale.esign.sdk.tech.bean.PosBean;
import com.timevale.esign.sdk.tech.bean.result.AddAccountResult;
import com.timevale.esign.sdk.tech.bean.result.AddSealResult;
import com.timevale.esign.sdk.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.GetAccountProfileResult;
import com.timevale.esign.sdk.tech.bean.seal.PersonTemplateType;
import com.timevale.esign.sdk.tech.bean.seal.SealColor;
import com.timevale.esign.sdk.tech.impl.constants.SignType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SignInfoServiceImpl
extends BaseServiceImpl<SignInfo>
implements ISignInfoService {
    public static final String RESULT_ERROR = "-1";
    public static final String SIGN_TYPE_USER = "USER";
    private static final String SIGN_TYPE_PLATFORM = "PLATFORM";
    public static final PersonTemplateType TEMPLATE_TYPE_DEFAULT = PersonTemplateType.SQUARE;
    public static final SealColor SEAL_COLOR_DEFAULT = SealColor.RED;
    @Value(value="${tsign.project.id}")
    private String projectId;
    @Value(value="${tsign.project.secret}")
    private String projectSecret;
    @Value(value="${tsign.api.url}")
    private String apiUrl;
    private CloseableHttpClient httpClient;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    private PersonDataMapper personDataMapper;
    @Autowired
    private ISignHistoryService historyService;
    private boolean isProjectInit = false;
    @Resource(name="restBean")
    IHapApiService restService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SignInfoServiceImpl() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    private void initProject() {
        if (this.isProjectInit) {
            return;
        }
        int code = SignUtils.initProject(this.projectId, this.projectSecret, this.apiUrl);
        if (code == 0) {
            this.isProjectInit = true;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData pdfSign(IRequest iRequest, SignInfo person) {
        byte[] bytes;
        if (!this.isProjectInit) {
            this.initProject();
        }
        ResponseData responseData = new ResponseData(false);
        ArrayList<SignHistory> histories = new ArrayList<SignHistory>(10);
        String accountId = this.getCustomerAccount(person);
        if (StringUtils.isBlank((CharSequence)accountId)) {
            responseData.setMessage("can not get accountId");
            return responseData;
        }
        person.setAccountId(accountId);
        String sealData = this.getPersonSealData(person);
        if (StringUtils.isBlank((CharSequence)sealData)) {
            responseData.setMessage("could not get person seal data");
            return responseData;
        }
        try {
            bytes = this.getPdf(person.getAttachmentInfo());
        }
        catch (IOException e) {
            responseData.setMessage("can not get file content");
            return responseData;
        }
        String attachmentId = person.getAttachmentInfo().getAttachmentId();
        bytes = this.userPosSign(person, responseData, histories, accountId, sealData, bytes, attachmentId);
        bytes = this.userKeySign(person, responseData, histories, accountId, sealData, bytes, attachmentId);
        if (bytes == null) {
            this.logger.debug("user sign failed");
            return responseData;
        }
        bytes = this.selfPosSign(person, responseData, histories, bytes, attachmentId);
        if ((bytes = this.selfKeySign(person, responseData, histories, bytes, attachmentId)) == null) {
            this.logger.debug("platform sign failed");
            return responseData;
        }
        String uploadStatus = this.uploadFile(bytes, person.getAttachmentInfo());
        if (uploadStatus == null) {
            responseData.setMessage("upload file failed");
        } else {
            responseData.setSuccess(true);
            responseData.setMessage(uploadStatus);
        }
        if (CollectionUtils.isNotEmpty(histories)) {
            this.historyService.batchUpdate(iRequest, histories);
        }
        return responseData;
    }

    private byte[] selfKeySign(SignInfo person, ResponseData responseData, List<SignHistory> histories, byte[] bytes, String attachmentId) {
        List<String> selfKeys = person.getSelfKeys();
        if (CollectionUtils.isNotEmpty(selfKeys)) {
            for (String key : selfKeys) {
                FileDigestSignResult customerResult;
                if (StringUtils.isBlank((CharSequence)key)) {
                    this.logger.debug("platform key is empty, skip this");
                    continue;
                }
                PosBean platformKeywordPosBean = SignUtils.getPlatformKeywordPosBean(key);
                try {
                    customerResult = SignUtils.platformSignByStreamm(bytes, platformKeywordPosBean, SignType.Key);
                }
                catch (Exception e) {
                    responseData.setMessage("platform key sign failed" + e.getMessage());
                    return null;
                }
                if (customerResult == null || customerResult.getErrCode() != 0) {
                    responseData.setMessage("platform sign failed");
                    return null;
                }
                histories.add(this.historyLog(SIGN_TYPE_USER, attachmentId, customerResult.getSignDetailUrl(), customerResult.getSignServiceId(), key));
                bytes = customerResult.getStream();
            }
        } else {
            this.logger.debug("not found selfKeyword, skip platform key sign. signInfo: {}", (Object)JSON.toJSONString((Object)person));
        }
        return bytes;
    }

    private byte[] userKeySign(SignInfo person, ResponseData responseData, List<SignHistory> histories, String accountId, String sealData, byte[] bytes, String attachmentId) {
        List<String> userKeys = person.getUserKeys();
        if (CollectionUtils.isNotEmpty(userKeys)) {
            for (String key : userKeys) {
                FileDigestSignResult customerResult;
                if (StringUtils.isBlank((CharSequence)key)) {
                    this.logger.debug("user key is empty, skip this");
                    continue;
                }
                PosBean userKeywordPosBean = SignUtils.getUserKeywordPosBean(key);
                try {
                    customerResult = SignUtils.customerDigestSign(bytes, accountId, sealData, userKeywordPosBean, SignType.Key);
                }
                catch (Exception e) {
                    responseData.setMessage("custom key sign failed." + e.getMessage());
                    return null;
                }
                if (customerResult == null || customerResult.getErrCode() != 0) {
                    responseData.setMessage("customer sign failed");
                    return null;
                }
                histories.add(this.historyLog(SIGN_TYPE_USER, attachmentId, customerResult.getSignDetailUrl(), customerResult.getSignServiceId(), key));
                bytes = customerResult.getStream();
            }
        } else {
            this.logger.debug("not found userKeyword, skip user key sign. signInfo: {}", (Object)JSON.toJSONString((Object)person));
        }
        return bytes;
    }

    private byte[] selfPosSign(SignInfo person, ResponseData responseData, List<SignHistory> histories, byte[] bytes, String attachmentId) {
        List<SignPage> selfPages = person.getSelfPages();
        if (CollectionUtils.isNotEmpty(selfPages)) {
            for (SignPage selfPage : selfPages) {
                FileDigestSignResult platformResult;
                try {
                    platformResult = SignUtils.platformSignByStreamm(bytes, selfPage.getPage(), selfPage.getX(), (int)selfPage.getY());
                }
                catch (Exception e) {
                    responseData.setMessage("platform Pos sign failed" + e.getMessage());
                    return null;
                }
                if (platformResult == null || platformResult.getErrCode() != 0) {
                    responseData.setMessage("platform sign failed");
                    return null;
                }
                bytes = platformResult.getStream();
                histories.add(this.historyLog(SIGN_TYPE_PLATFORM, attachmentId, platformResult.getSignDetailUrl(), platformResult.getSignServiceId(), selfPage.getPage(), selfPage.getX(), selfPage.getY()));
            }
        } else {
            this.logger.debug("not found selfPages, skip platform pos sign. signInfo: {}", (Object)JSON.toJSONString((Object)person));
        }
        return bytes;
    }

    private byte[] userPosSign(SignInfo person, ResponseData responseData, List<SignHistory> histories, String accountId, String sealData, byte[] bytes, String attachmentId) {
        List<SignPage> userPages = person.getUserPages();
        if (CollectionUtils.isNotEmpty(userPages)) {
            for (SignPage userPage : userPages) {
                FileDigestSignResult customerResult;
                try {
                    customerResult = SignUtils.customerDigestSign(bytes, accountId, sealData, userPage.getPage(), userPage.getX(), userPage.getY());
                }
                catch (Exception e) {
                    responseData.setMessage("customer Pos sign failed" + e.getMessage());
                    return null;
                }
                if (customerResult == null || customerResult.getErrCode() != 0) {
                    responseData.setMessage("customer sign failed");
                    return null;
                }
                histories.add(this.historyLog(SIGN_TYPE_USER, attachmentId, customerResult.getSignDetailUrl(), customerResult.getSignServiceId(), userPage.getPage(), userPage.getX(), userPage.getY()));
                bytes = customerResult.getStream();
            }
        } else {
            this.logger.debug("not found userPages, skip user pos sign. signInfo: {}", (Object)JSON.toJSONString((Object)person));
        }
        return bytes;
    }

    private String getPersonSealData(SignInfo person) {
        this.logger.debug("getPersonSealData::{}", (Object)JSON.toJSONString((Object)person));
        if (person == null) {
            return null;
        }
        String sealData = person.getSealData();
        if (StringUtils.isBlank((CharSequence)sealData)) {
            this.logger.debug("not get sealData from param");
            String accountId = person.getAccountId();
            if (StringUtils.isBlank((CharSequence)accountId)) {
                return null;
            }
            PersonData personData = new PersonData();
            personData.setAccountId(accountId);
            PersonData data = (PersonData)this.personDataMapper.selectByPrimaryKey(personData);
            if (data == null || StringUtils.isBlank((CharSequence)data.getSealData())) {
                AddSealResult addSealResult = SignUtils.addPersonTemplateSeal(accountId, TEMPLATE_TYPE_DEFAULT, SEAL_COLOR_DEFAULT);
                if (0 != addSealResult.getErrCode()) {
                    return null;
                }
                data = (PersonData)this.personDataMapper.selectByPrimaryKey(personData);
                if (data != null && !StringUtils.isBlank((CharSequence)data.getSealData())) {
                    return data.getSealData();
                }
                personData.setSealData(addSealResult.getSealData());
                personData.setColor(SEAL_COLOR_DEFAULT.name());
                personData.setTemplateType(TEMPLATE_TYPE_DEFAULT.name());
                try {
                    if (data == null) {
                        this.personDataMapper.insertSelective(personData);
                    } else {
                        this.personDataMapper.updateByPrimaryKeySelective(personData);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SQLIntegrityConstraintViolationException || e instanceof DuplicateKeyException) {
                        this.logger.error("data insert duplicate");
                    }
                    throw e;
                }
                sealData = personData.getSealData();
            } else {
                sealData = data.getSealData();
            }
        }
        return sealData;
    }

    @Override
    public Map<String, Object> getUserAccountOrRegister(IRequest iRequest, SignInfo info) {
        if (!this.isProjectInit) {
            this.initProject();
        }
        String accountId = this.getCustomerAccount(info);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", StringUtils.isBlank((CharSequence)accountId));
        map.put("accountId", accountId);
        return map;
    }

    private SignHistory historyLog(String signType, String attachmentId, String detailUrl, String serviceId, String page, int x, int y) {
        SignHistory history = new SignHistory();
        history.setSignType(signType);
        history.setAttachmentId(attachmentId);
        history.setSignServiceId(serviceId);
        history.setSignDetailUrl(detailUrl);
        history.setSignPage(page);
        history.setX(String.valueOf(x));
        history.setY(String.valueOf(y));
        history.set__status("add");
        return history;
    }

    private SignHistory historyLog(String signType, String attachmentId, String detailUrl, String serviceId, String key) {
        SignHistory history = new SignHistory();
        history.setSignType(signType);
        history.setAttachmentId(attachmentId);
        history.setSignServiceId(serviceId);
        history.setSignDetailUrl(detailUrl);
        history.setKeyword(key);
        history.set__status("add");
        return history;
    }

    private String uploadFile(byte[] bytes, AttachmentInfo info) {
        this.logger.debug("params,bytes:{}, attachmentInfo:{}", (Object)bytes, (Object)JSON.toJSONString((Object)info));
        if (ArrayUtils.isEmpty((byte[])bytes) || info == null || StringUtils.isBlank((CharSequence)info.getPkValue()) || StringUtils.isBlank((CharSequence)info.getSourceType())) {
            return null;
        }
        String apiName = info.getUploadApiName();
        String sysName = info.getUploadSysName();
        HapInterfaceHeader headerAndLineDTO = this.headerService.getHeaderAndLine(sysName, apiName);
        if (headerAndLineDTO == null) {
            this.logger.debug("headerAndLineDTO is null\uff0c apiName:{}, sysName:{}", (Object)apiName, (Object)sysName);
            return null;
        }
        String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        this.logger.debug("upload url: {}", (Object)url);
        HttpPost httpPost = new HttpPost(url);
        StringBody pkValue = new StringBody(info.getPkValue(), ContentType.MULTIPART_FORM_DATA);
        StringBody userId = new StringBody(info.getUserId(), ContentType.MULTIPART_FORM_DATA);
        StringBody sourceType = new StringBody(info.getSourceType(), ContentType.MULTIPART_FORM_DATA);
        ContentType pdfType = ContentType.create((String)"application/pdf", (Charset)Consts.UTF_8);
        try {
            HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart("pkvalue", (ContentBody)pkValue).addPart("user_id", (ContentBody)userId).addPart("source_type", (ContentBody)sourceType).addBinaryBody("file", bytes, pdfType, info.getFileName()).setCharset(CharsetUtils.get((String)"utf-8")).build();
            httpPost.setEntity(entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            InputStream content = response.getEntity().getContent();
            String result = IOUtils.toString((InputStream)content);
            if (StringUtils.equals((CharSequence)RESULT_ERROR, (CharSequence)result)) {
                return null;
            }
            return result;
        }
        catch (IOException e) {
            this.logger.error("upload attachment failed, attachmentInfo:{}", (Object)JSON.toJSONString((Object)info), (Object)e);
            return null;
        }
    }

    private byte[] getPdf(AttachmentInfo info) throws IOException {
        if (info == null || StringUtils.isBlank((CharSequence)info.getAttachmentId())) {
            return null;
        }
        String attachmentId = info.getAttachmentId();
        String apiName = info.getDownloadApiName();
        String sysName = info.getDownloadSysName();
        HapInterfaceHeader headerAndLineDTO = this.headerService.getHeaderAndLine(sysName, apiName);
        if (headerAndLineDTO == null) {
            return null;
        }
        String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        HttpGet httpGet = new HttpGet(url = url + (url.indexOf("?") > 0 ? "&attachment_id=" : "?attachment_id=") + attachmentId);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
        if (200 != response.getStatusLine().getStatusCode()) {
            this.logger.error("request target attachment({}) failed,sysName:{}, apiName:{}", new Object[]{attachmentId, sysName, apiName});
            return null;
        }
        InputStream content = response.getEntity().getContent();
        return IOUtils.toByteArray((InputStream)content);
    }

    private String getCustomerAccount(SignInfo person) {
        Assert.notNull((Object)person, (String)"customer info can not be null");
        String idNo = person.getIdNo();
        String accountId = person.getAccountId();
        if (StringUtils.isNotBlank((CharSequence)accountId)) {
            return accountId;
        }
        if (StringUtils.isBlank((CharSequence)idNo)) {
            throw new IllegalArgumentException("accountId and idNo can not be null");
        }
        SignInfo signInfo = (SignInfo)this.mapper.selectByPrimaryKey(person);
        if (signInfo == null) {
            PersonBean personBean = this.signInfo2PersonBean(person);
            if (personBean != null) {
                AddAccountResult result = SignUtils.addPersonAccount(personBean);
                if (result.getErrCode() == 0) {
                    accountId = result.getAccountId();
                } else if (result.getErrCode() == 150016) {
                    accountId = this.fetchExistAccountFromServer(idNo);
                }
                if (StringUtils.isBlank((CharSequence)accountId)) {
                    throw new RuntimeException("get account error");
                }
                person.setAccountId(accountId);
                try {
                    this.mapper.insertSelective(person);
                }
                catch (Exception e) {
                    if (e instanceof SQLIntegrityConstraintViolationException || e instanceof DuplicateKeyException) {
                        this.logger.error("insert duplicate", (Throwable)e);
                    }
                    this.logger.error("insert error", (Throwable)e);
                    throw e;
                }
                return accountId;
            }
        } else {
            return signInfo.getAccountId();
        }
        return null;
    }

    private String fetchExistAccountFromServer(String idNo) {
        GetAccountProfileResult userAccount = SignUtils.getExistUserAccount(idNo);
        if (0 == userAccount.getErrCode()) {
            AccountProfile accountInfo = userAccount.getAccountInfo();
            SignInfo signInfo = new SignInfo();
            signInfo.setAccountId(accountInfo.getAccountUid());
            signInfo.setMobile(accountInfo.getMobile());
            signInfo.setIdNo(accountInfo.getIdNo());
            signInfo.setPersonArea(accountInfo.getIdNoType());
            signInfo.setName(accountInfo.getName());
            this.mapper.insertSelective(signInfo);
            return signInfo.getAccountId();
        }
        return null;
    }

    private PersonBean signInfo2PersonBean(SignInfo person) {
        if (person == null) {
            return null;
        }
        PersonBean personBean = null;
        try {
            String json = JSON.toJSONString((Object)person);
            personBean = (PersonBean)JSON.parseObject((String)json, PersonBean.class);
        }
        catch (Exception e) {
            this.logger.error("trans to PersonBean error", (Throwable)e);
        }
        return personBean;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData pdfSignByFile(IRequest iRequest, SignInfo person) {
        if (!this.isProjectInit) {
            this.initProject();
        }
        ResponseData responseData = new ResponseData(false);
        ArrayList<SignHistory> histories = new ArrayList<SignHistory>(10);
        String accountId = this.getCustomerAccount(person);
        if (StringUtils.isBlank((CharSequence)accountId)) {
            responseData.setMessage("can not get accountId");
            return responseData;
        }
        person.setAccountId(accountId);
        String sealData = this.getPersonSealData(person);
        if (StringUtils.isBlank((CharSequence)sealData)) {
            responseData.setMessage("could not get person seal data");
            return responseData;
        }
        String attachmentId = person.getAttachmentInfo().getAttachmentId();
        FileDigestSignResult customerResult = this.userKeySignByFile(person, responseData, histories, accountId, sealData, attachmentId);
        if (customerResult == null || customerResult.getErrCode() != 0) {
            this.logger.debug("user sign failed");
            return responseData;
        }
        if (customerResult.getDstFilePath() != null) {
            String uploadStatus = this.saveAttachmentInfo(customerResult.getDstFilePath(), person.getAttachmentInfo());
            if (uploadStatus == null) {
                responseData.setMessage("save attachmentinfo failed");
            } else {
                responseData.setSuccess(true);
                responseData.setMessage(uploadStatus);
            }
        }
        if (CollectionUtils.isNotEmpty(histories)) {
            this.historyService.batchUpdate(iRequest, histories);
        }
        return responseData;
    }

    private FileDigestSignResult userKeySignByFile(SignInfo info, ResponseData responseData, List<SignHistory> histories, String accountId, String sealData, String attachmentId) {
        String srcPdfFile = info.getAttachmentInfo().getSrcPdfFilePath();
        String signedPdfFile = srcPdfFile.split("\\.")[0] + "-signByUser.pdf";
        String signedPdfFileName = info.getAttachmentInfo().getFileName();
        List<String> userKeys = info.getUserKeys();
        FileDigestSignResult customerResult = new FileDigestSignResult();
        if (CollectionUtils.isNotEmpty(userKeys)) {
            for (String key : userKeys) {
                if (StringUtils.isBlank((CharSequence)key)) {
                    this.logger.debug("user key is empty, skip this");
                    continue;
                }
                PosBean userKeywordPosBean = SignUtils.getUserKeywordPosBean(key);
                try {
                    if (!StringUtils.isBlank((CharSequence)customerResult.getDstFilePath())) {
                        srcPdfFile = customerResult.getDstFilePath();
                        signedPdfFile = srcPdfFile.split("\\.")[0] + "-signByUser.pdf";
                    }
                    customerResult = SignUtils.userOrganizeSignByFile(srcPdfFile, signedPdfFile, signedPdfFileName, accountId, sealData, userKeywordPosBean, SignType.Key);
                }
                catch (Exception e) {
                    responseData.setMessage("custom key sign failed." + e.getMessage());
                    return null;
                }
                if (customerResult == null || customerResult.getErrCode() != 0) {
                    responseData.setMessage("customer sign failed");
                    return null;
                }
                histories.add(this.historyLog(SIGN_TYPE_USER, attachmentId, customerResult.getSignDetailUrl(), customerResult.getSignServiceId(), key));
            }
        } else {
            this.logger.debug("not found userKeyword, skip user key sign. signInfo: {}", (Object)JSON.toJSONString((Object)info));
        }
        return customerResult;
    }

    private String saveAttachmentInfo(String signedPath, AttachmentInfo info) {
        this.logger.debug("params,bytes:{}, attachmentInfo:{}", (Object)signedPath, (Object)JSON.toJSONString((Object)info));
        if (StringUtils.isEmpty((CharSequence)signedPath) || info == null || StringUtils.isBlank((CharSequence)info.getPkValue()) || StringUtils.isBlank((CharSequence)info.getSourceType())) {
            return null;
        }
        String apiName = info.getSaveApiName();
        String sysName = info.getSaveSysName();
        HapInterfaceHeader headerAndLineDTO = this.headerService.getHeaderAndLine(sysName, apiName);
        if (headerAndLineDTO == null) {
            this.logger.debug("headerAndLineDTO is null\uff0c apiName:{}, sysName:{}", (Object)apiName, (Object)sysName);
            return null;
        }
        String url = headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
        this.logger.debug("savaAttachment url: {}", (Object)url);
        String fileSize = String.valueOf(this.getFileSize(signedPath));
        String fileType = "pdf";
        String mimeType = "pdf";
        JSONObject params = new JSONObject();
        params.put("table_pk_value", (Object)info.getPkValue());
        params.put("user_id", (Object)info.getUserId());
        params.put("table_name", (Object)info.getSourceType());
        params.put("file_name", (Object)info.getFileName());
        params.put("file_path", (Object)signedPath);
        params.put("file_size", (Object)fileSize);
        params.put("file_type_code", (Object)fileType);
        params.put("mime_type", (Object)mimeType);
        try {
            JSONObject result = this.restService.invoke(headerAndLineDTO, params);
            if (StringUtils.equals((CharSequence)"S", (CharSequence)result.getString("return_status"))) {
                return result.getString("attachment_id");
            }
            this.logger.error("save attachment failed, message:{}", (Object)result.getString("message"));
        }
        catch (Exception e) {
            this.logger.error("save attachment failed, attachmentInfo:{}", (Object)JSON.toJSONString((Object)info), (Object)e);
        }
        return null;
    }

    public long getFileSize(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        return 0L;
    }
}

