/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hand.app.esign.bean.AttachmentInfo;
import com.hand.app.esign.dto.OrganSignInfo;
import com.hand.app.esign.dto.PersonData;
import com.hand.app.esign.dto.SignHistory;
import com.hand.app.esign.mapper.PersonDataMapper;
import com.hand.app.esign.service.IOrganSignInfoService;
import com.hand.app.esign.service.ISignHistoryService;
import com.hand.app.esign.utils.SignUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapApiService;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.timevale.esign.sdk.tech.bean.AccountProfile;
import com.timevale.esign.sdk.tech.bean.OrganizeBean;
import com.timevale.esign.sdk.tech.bean.PosBean;
import com.timevale.esign.sdk.tech.bean.result.AddAccountResult;
import com.timevale.esign.sdk.tech.bean.result.AddSealResult;
import com.timevale.esign.sdk.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.GetAccountProfileResult;
import com.timevale.esign.sdk.tech.bean.seal.OrganizeTemplateType;
import com.timevale.esign.sdk.tech.bean.seal.SealColor;
import com.timevale.esign.sdk.tech.impl.constants.LicenseQueryType;
import com.timevale.esign.sdk.tech.impl.constants.SignType;
import java.io.File;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class OrganSignInfoServiceImpl
extends BaseServiceImpl<OrganSignInfo>
implements IOrganSignInfoService {
    public static final String SIGN_TYPE_USER = "USER";
    private static final String SIGN_TYPE_PLATFORM = "PLATFORM";
    public static final OrganizeTemplateType ORGANIZE_TEMPLATE_TYPE_DEFAULT = OrganizeTemplateType.STAR;
    public static final SealColor SEAL_COLOR_DEFAULT = SealColor.RED;
    @Value(value="${tsign.project.id}")
    private String projectId;
    @Value(value="${tsign.project.secret}")
    private String projectSecret;
    @Value(value="${tsign.api.url}")
    private String apiUrl;
    private CloseableHttpClient httpClient;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    private PersonDataMapper personDataMapper;
    @Autowired
    private ISignHistoryService historyService;
    private boolean isProjectInit = false;
    @Resource(name="restBean")
    IHapApiService restService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public OrganSignInfoServiceImpl() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(15000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    private void initProject() {
        if (this.isProjectInit) {
            return;
        }
        int code = SignUtils.initProject(this.projectId, this.projectSecret, this.apiUrl);
        if (code == 0) {
            this.isProjectInit = true;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ResponseData pdfSignByOrgan(IRequest iRequest, OrganSignInfo info) {
        if (!this.isProjectInit) {
            this.initProject();
        }
        ResponseData responseData = new ResponseData(false);
        ArrayList<SignHistory> histories = new ArrayList<SignHistory>(10);
        String accountId = this.getOrganAccount(info);
        if (StringUtils.isBlank((CharSequence)accountId)) {
            responseData.setMessage("can not get accountId");
            return responseData;
        }
        info.setAccountId(accountId);
        String sealData = this.getOrganSealData(info);
        if (StringUtils.isBlank((CharSequence)sealData)) {
            responseData.setMessage("could not get organize seal data");
            return responseData;
        }
        String attachmentId = info.getAttachmentInfo().getAttachmentId();
        FileDigestSignResult customerResult = this.userOrganKeySign(info, responseData, histories, accountId, sealData, attachmentId);
        if (customerResult == null || customerResult.getErrCode() != 0) {
            this.logger.debug("user sign failed");
            return responseData;
        }
        if (customerResult.getDstFilePath() != null) {
            String uploadStatus = this.saveAttachmentInfo(customerResult.getDstFilePath(), info.getAttachmentInfo());
            if (uploadStatus == null) {
                responseData.setMessage("save attachmentinfo failed");
            } else {
                responseData.setSuccess(true);
                responseData.setMessage(uploadStatus);
            }
        }
        if (CollectionUtils.isNotEmpty(histories)) {
            this.historyService.batchUpdate(iRequest, histories);
        }
        return responseData;
    }

    private FileDigestSignResult userOrganKeySign(OrganSignInfo info, ResponseData responseData, List<SignHistory> histories, String accountId, String sealData, String attachmentId) {
        String srcPdfFile = info.getAttachmentInfo().getSrcPdfFilePath();
        String signedPdfFile = srcPdfFile.split("\\.")[0] + "-signByUser.pdf";
        String signedPdfFileName = info.getAttachmentInfo().getFileName();
        List<String> userKeys = info.getUserKeys();
        FileDigestSignResult customerResult = new FileDigestSignResult();
        if (CollectionUtils.isNotEmpty(userKeys)) {
            for (String key : userKeys) {
                if (StringUtils.isBlank((CharSequence)key)) {
                    this.logger.debug("user key is empty, skip this");
                    continue;
                }
                PosBean OrganizeKeywordPosBean = SignUtils.getOrganizeKeywordPosBean(key);
                try {
                    if (!StringUtils.isBlank((CharSequence)customerResult.getDstFilePath())) {
                        srcPdfFile = customerResult.getDstFilePath();
                        signedPdfFile = srcPdfFile.split("\\.")[0] + "-signByUser.pdf";
                    }
                    customerResult = SignUtils.userOrganizeSignByFile(srcPdfFile, signedPdfFile, signedPdfFileName, accountId, sealData, OrganizeKeywordPosBean, SignType.Key);
                }
                catch (Exception e) {
                    responseData.setMessage("custom key sign failed." + e.getMessage());
                    return null;
                }
                if (customerResult == null || customerResult.getErrCode() != 0) {
                    responseData.setMessage("customer sign failed");
                    return null;
                }
                histories.add(this.historyLog(SIGN_TYPE_USER, attachmentId, customerResult.getSignDetailUrl(), customerResult.getSignServiceId(), key));
            }
        } else {
            this.logger.debug("not found userKeyword, skip user key sign. signInfo: {}", (Object)JSON.toJSONString((Object)info));
        }
        return customerResult;
    }

    private SignHistory historyLog(String signType, String attachmentId, String detailUrl, String serviceId, String key) {
        SignHistory history = new SignHistory();
        history.setSignType(signType);
        history.setAttachmentId(attachmentId);
        history.setSignServiceId(serviceId);
        history.setSignDetailUrl(detailUrl);
        history.setKeyword(key);
        history.set__status("add");
        return history;
    }

    private String getOrganSealData(OrganSignInfo info) {
        this.logger.debug("getOrganSealData::{}", (Object)JSON.toJSONString((Object)info));
        if (info == null) {
            return null;
        }
        String hText = info.gethText();
        String qText = info.getqText();
        String sealData = info.getSealData();
        if (StringUtils.isBlank((CharSequence)sealData)) {
            this.logger.debug("not get sealData from param");
            String accountId = info.getAccountId();
            if (StringUtils.isBlank((CharSequence)accountId)) {
                return null;
            }
            PersonData personData = new PersonData();
            personData.setAccountId(accountId);
            PersonData data = (PersonData)this.personDataMapper.selectByPrimaryKey(personData);
            if (data == null || StringUtils.isBlank((CharSequence)data.getSealData())) {
                AddSealResult addSealResult = SignUtils.addOrganizeTemplateSeal(accountId, ORGANIZE_TEMPLATE_TYPE_DEFAULT, SEAL_COLOR_DEFAULT, hText, qText);
                if (0 != addSealResult.getErrCode()) {
                    return null;
                }
                data = (PersonData)this.personDataMapper.selectByPrimaryKey(personData);
                if (data != null && !StringUtils.isBlank((CharSequence)data.getSealData())) {
                    return data.getSealData();
                }
                personData.setSealData(addSealResult.getSealData());
                personData.setColor(SEAL_COLOR_DEFAULT.name());
                personData.setTemplateType(ORGANIZE_TEMPLATE_TYPE_DEFAULT.name());
                personData.setHtext(hText);
                personData.setQtext(qText);
                try {
                    if (data == null) {
                        this.personDataMapper.insertSelective(personData);
                    } else {
                        this.personDataMapper.updateByPrimaryKeySelective(personData);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SQLIntegrityConstraintViolationException || e instanceof DuplicateKeyException) {
                        this.logger.error("data insert duplicate");
                    }
                    throw e;
                }
                sealData = personData.getSealData();
            } else {
                sealData = data.getSealData();
            }
        }
        return sealData;
    }

    @Override
    public Map<String, Object> getUserAccountOrRegisterByOrgan(IRequest iRequest, OrganSignInfo info) {
        if (!this.isProjectInit) {
            this.initProject();
        }
        String accountId = this.getOrganAccount(info);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", StringUtils.isBlank((CharSequence)accountId));
        map.put("accountId", accountId);
        return map;
    }

    private String getOrganAccount(OrganSignInfo organ) {
        Assert.notNull((Object)organ, (String)"organize info can not be null");
        String organCode = organ.getOrganCode();
        String accountId = organ.getAccountId();
        if (StringUtils.isNotBlank((CharSequence)accountId)) {
            return accountId;
        }
        if (StringUtils.isBlank((CharSequence)organCode)) {
            throw new IllegalArgumentException("accountId and idNo can not be null");
        }
        OrganSignInfo signInfo = (OrganSignInfo)this.mapper.selectByPrimaryKey(organ);
        if (signInfo == null) {
            OrganizeBean organizeBean = this.signInfo2OrganizeBean(organ);
            if (organizeBean != null) {
                AddAccountResult result = SignUtils.addOrganizeAccount(organizeBean);
                if (result.getErrCode() == 0) {
                    accountId = result.getAccountId();
                } else if (result.getErrCode() == 150016) {
                    accountId = this.fetchExistAccountFromServer(organCode, LicenseQueryType.MERGE);
                }
                if (StringUtils.isBlank((CharSequence)accountId)) {
                    throw new RuntimeException("get account error");
                }
                organ.setAccountId(accountId);
                try {
                    this.mapper.insertSelective(organ);
                }
                catch (Exception e) {
                    if (e instanceof SQLIntegrityConstraintViolationException || e instanceof DuplicateKeyException) {
                        this.logger.error("insert duplicate", (Throwable)e);
                    }
                    this.logger.error("insert error", (Throwable)e);
                    throw e;
                }
                return accountId;
            }
        } else {
            return signInfo.getAccountId();
        }
        return null;
    }

    private String fetchExistAccountFromServer(String idNo, LicenseQueryType area) {
        GetAccountProfileResult userAccount = SignUtils.getExistUserAccount(idNo, area);
        if (0 == userAccount.getErrCode()) {
            AccountProfile accountInfo = userAccount.getAccountInfo();
            OrganSignInfo signInfo = new OrganSignInfo();
            signInfo.setAccountId(accountInfo.getAccountUid());
            signInfo.setOrganCode(accountInfo.getIdNo());
            signInfo.setName(accountInfo.getName());
            this.mapper.insertSelective(signInfo);
            return signInfo.getAccountId();
        }
        return null;
    }

    private OrganizeBean signInfo2OrganizeBean(OrganSignInfo organ) {
        if (organ == null) {
            return null;
        }
        OrganizeBean organizeBean = null;
        try {
            String json = JSON.toJSONString((Object)organ);
            organizeBean = (OrganizeBean)JSON.parseObject((String)json, OrganizeBean.class);
        }
        catch (Exception e) {
            this.logger.error("trans to PersonBean error", (Throwable)e);
        }
        return organizeBean;
    }

    private String saveAttachmentInfo(String signedPath, AttachmentInfo info) {
        this.logger.debug("params,bytes:{}, attachmentInfo:{}", (Object)signedPath, (Object)JSON.toJSONString((Object)info));
        if (StringUtils.isEmpty((CharSequence)signedPath) || info == null || StringUtils.isBlank((CharSequence)info.getPkValue()) || StringUtils.isBlank((CharSequence)info.getSourceType())) {
            return null;
        }
        String apiName = info.getSaveApiName();
        String sysName = info.getSaveSysName();
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        if (hapInterfaceHeader == null) {
            this.logger.debug("hapInterfaceHeader is null\uff0c apiName:{}, sysName:{}", (Object)apiName, (Object)sysName);
            return null;
        }
        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        this.logger.debug("savaAttachment url: {}", (Object)url);
        String fileSize = String.valueOf(this.getFileSize(signedPath));
        String fileType = "pdf";
        String mimeType = "pdf";
        JSONObject params = new JSONObject();
        params.put("table_pk_value", (Object)info.getPkValue());
        params.put("user_id", (Object)info.getUserId());
        params.put("table_name", (Object)info.getSourceType());
        params.put("file_name", (Object)info.getFileName());
        params.put("file_path", (Object)signedPath);
        params.put("file_size", (Object)fileSize);
        params.put("file_type_code", (Object)fileType);
        params.put("mime_type", (Object)mimeType);
        try {
            JSONObject result = this.restService.invoke(hapInterfaceHeader, params);
            if (StringUtils.equals((CharSequence)"S", (CharSequence)result.getString("return_status"))) {
                return result.getString("attachment_id");
            }
            this.logger.error("save attachment failed, message:{}", (Object)result.getString("message"));
        }
        catch (Exception e) {
            this.logger.error("save attachment failed, attachmentInfo:{}", (Object)JSON.toJSONString((Object)info), (Object)e);
        }
        return null;
    }

    public long getFileSize(String filePath) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            return file.length();
        }
        return 0L;
    }
}

