/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esign.controllers;

import com.hand.app.esign.dto.OrganSignInfo;
import com.hand.app.esign.dto.SignInfo;
import com.hand.app.esign.service.IOrganSignInfoService;
import com.hand.app.esign.service.ISignInfoService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class SignController
extends BaseController {
    @Autowired
    private ISignInfoService signService;
    @Autowired
    private IOrganSignInfoService organSignService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ResponseBody
    @RequestMapping(value={"/app/sign/pdf"})
    public ResponseData signPdf(HttpServletRequest request, @RequestBody SignInfo signInfo) {
        ResponseData responseData;
        try {
            responseData = this.signService.pdfSign(this.createRequestContext(request), signInfo);
        }
        catch (Exception e) {
            this.logger.error("something error!", (Throwable)e);
            responseData = new ResponseData(false);
            responseData.setMessage("Unknown Error: " + e.getMessage());
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/app/sign/pdfByFile"})
    public ResponseData signPdfByFile(HttpServletRequest request, @RequestBody SignInfo signInfo) {
        ResponseData responseData;
        try {
            responseData = this.signService.pdfSignByFile(this.createRequestContext(request), signInfo);
        }
        catch (Exception e) {
            this.logger.error("something error!", (Throwable)e);
            responseData = new ResponseData(false);
            responseData.setMessage("Unknown Error: " + e.getMessage());
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/app/sign/pdfByOrgan"})
    public ResponseData signPdfByOrgan(HttpServletRequest request, @RequestBody OrganSignInfo organsignInfo) {
        ResponseData responseData;
        try {
            responseData = this.organSignService.pdfSignByOrgan(this.createRequestContext(request), organsignInfo);
        }
        catch (Exception e) {
            this.logger.error("something error!", (Throwable)e);
            responseData = new ResponseData(false);
            responseData.setMessage("Unknown Error: " + e.getMessage());
        }
        return responseData;
    }

    @ResponseBody
    @RequestMapping(value={"/app/sign/register"})
    public Map<String, Object> getUserAccountOrRegister(HttpServletRequest request, @RequestBody SignInfo signInfo) {
        return this.signService.getUserAccountOrRegister(this.createRequestContext(request), signInfo);
    }

    @ResponseBody
    @RequestMapping(value={"/app/sign/registerByOrgan"})
    public Map<String, Object> getUserAccountOrRegisterByOrgan(HttpServletRequest request, @RequestBody OrganSignInfo organsignInfo) {
        return this.organSignService.getUserAccountOrRegisterByOrgan(this.createRequestContext(request), organsignInfo);
    }
}

