/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.electronicSignature.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.electronicSignature.dto.EleSignConData;
import com.hand.app.electronicSignature.dto.EleSignContract;
import com.hand.app.electronicSignature.dto.EleSignSeal;
import com.hand.app.electronicSignature.mapper.EleSignConDataMapper;
import com.hand.app.electronicSignature.mapper.EleSignContractMapper;
import com.hand.app.electronicSignature.mapper.EleSignSealMapper;
import com.hand.app.electronicSignature.service.IElectronicSignatureContract;
import com.hand.app.hms.mapper.HmsThirdpartyAppMapper;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import constant.APIToolKitException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import request.Request;
import request.Tx1010Request;
import request.Tx1011Request;
import request.Tx1019Request;
import request.bean.ContractDataItem;
import request.bean.KeyWordInfo;
import request.bean.SignInfo;
import request.bean.Signatory;
import service.SignAPI;
import util.Base64;
import util.StringUtil;

@Service
public class ElectronicSignatureContractImpl
extends BaseServiceImpl<EleSignContract>
implements IElectronicSignatureContract {
    @Autowired
    private EleSignContractMapper eleSignContractMapper;
    @Autowired
    private EleSignConDataMapper eleSignConDataMapper;
    @Autowired
    private EleSignSealMapper eleSignSealMapper;
    @Autowired
    HmsThirdpartyAppMapper thirdpartyAppMapper;
    private static String SIGN_PDF_PATH;

    @Override
    public JSONObject createContractTemplate(EleSignContract param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1010Request tx1010Request = new Tx1010Request();
            tx1010Request.setTemplateId(param.getTemplateId());
            tx1010Request.setSerialNumber(param.getSerialNumber());
            tx1010Request.setContractName(param.getContractName());
            List<EleSignConData> conDataList = param.getConDataList();
            tx1010Request.setContractData(this.getContractDataItems(conDataList));
            tx1010Request.setAttachmentName(param.getAttachmentName());
            tx1010Request.setAttachmentContentHash(param.getAttachmentContentHash());
            tx1010Request.setContractName(param.getContractName());
            List<EleSignSeal> eleSignSealList = param.getSealList();
            tx1010Request.setSignatories(this.getSignature(eleSignSealList));
            String response = SignAPI.sendMessageAndGetResult((Request)tx1010Request);
            returnJson.put("ResponseCode", (Object)StringUtil.getNodeText((String)response, (String)"ResponseCode"));
            returnJson.put("ResponseDesc", (Object)StringUtil.getNodeText((String)response, (String)"ResponseDesc"));
            returnJson.put("txId", (Object)StringUtil.getNodeText((String)response, (String)"TxID"));
            param.setResponseCode(returnJson.getString("ResponseCode"));
            param.setResponseDesc(returnJson.getString("ResponseDesc"));
            param.setTxId(returnJson.getString("txId"));
        }
        catch (APIToolKitException e) {
            e.printStackTrace();
        }
        this.eleSignContractMapper.insertSelective(param);
        return returnJson;
    }

    public LinkedList<ContractDataItem> getContractDataItems(List<EleSignConData> conDataList) {
        LinkedList<ContractDataItem> contractDataItems = new LinkedList<ContractDataItem>();
        for (int i = 0; i < conDataList.toArray().length; ++i) {
            ContractDataItem contractDataItem = new ContractDataItem();
            contractDataItem.setContractDataKey(conDataList.get(i).getContractDataKey());
            contractDataItem.setContractDataValue(conDataList.get(i).getContractDataValue());
            contractDataItem.setContractDataKey(conDataList.get(i).getContractDataKey());
            contractDataItems.add(contractDataItem);
            this.eleSignConDataMapper.insertSelective(conDataList.get(i));
        }
        return contractDataItems;
    }

    public LinkedList<Signatory> getSignature(List<EleSignSeal> eleSignSealList) {
        LinkedList<Signatory> signatories = new LinkedList<Signatory>();
        if (eleSignSealList != null) {
            for (int i = 0; i < eleSignSealList.toArray().length; ++i) {
                Signatory signatory = new Signatory();
                signatory.setUserId(eleSignSealList.get(i).getUserId());
                signatory.setLocation(eleSignSealList.get(i).getLocation());
                signatory.setSignLocation(eleSignSealList.get(i).getSignLocation());
                signatory.setAuthorizationTime(eleSignSealList.get(i).getAuthorizationTime());
                signatories.add(signatory);
                this.eleSignSealMapper.insertSelective(eleSignSealList.get(i));
            }
        }
        return signatories;
    }

    @Override
    public JSONObject createContractFile(EleSignContract param) throws IOException {
        JSONObject returnJson = new JSONObject();
        try {
            Tx1011Request tx1011Request = new Tx1011Request();
            tx1011Request.setContractType(param.getContractType());
            tx1011Request.setPlatformSignatory(param.getPlatformIsSignatory().booleanValue());
            tx1011Request.setSerialNumber(param.getSerialNumber());
            tx1011Request.setContractName(param.getContractName());
            tx1011Request.setContractFile(param.getContractFile());
            tx1011Request.setPlatformSignInfo(ElectronicSignatureContractImpl.getSignInfoKeyWord(param));
            List<EleSignSeal> eleSignSealList = param.getSealList();
            tx1011Request.setSignatories(this.getSignature(eleSignSealList));
            tx1011Request.setSealId(param.getSealId());
            String response = SignAPI.sendMessageAndGetResult((Request)tx1011Request);
            returnJson.put("ResponseCode", (Object)StringUtil.getNodeText((String)response, (String)"ResponseCode"));
            returnJson.put("ResponseDesc", (Object)StringUtil.getNodeText((String)response, (String)"ResponseDesc"));
            returnJson.put("txId", (Object)StringUtil.getNodeText((String)response, (String)"TxID"));
            returnJson.put("contractId", (Object)StringUtil.getNodeText((String)response, (String)"contractId"));
        }
        catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }

    public static SignInfo getSignInfoKeyWord(EleSignContract param) {
        SignInfo signInfo = new SignInfo();
        KeyWordInfo keyWordInfo = new KeyWordInfo();
        keyWordInfo.setKeyWord(param.getKeyWord());
        keyWordInfo.setOffsetX(param.getOffsetX().intValue());
        keyWordInfo.setOffsetY(param.getOffsetY().intValue());
        keyWordInfo.setSealHeight(param.getSealHeight().intValue());
        keyWordInfo.setSealWith(param.getSealWith().intValue());
        signInfo.setKeyWordInfo(keyWordInfo);
        return signInfo;
    }

    @Override
    public JSONObject downloadContract(EleSignContract param) throws Exception {
        JSONObject returnJson = new JSONObject();
        try {
            SIGN_PDF_PATH = this.thirdpartyAppMapper.selectByCode("sign.attachment.download").getAppKey();
            Tx1019Request tx1019Request = new Tx1019Request();
            tx1019Request.setContractId(param.getContractId());
            String response = SignAPI.sendMessageAndGetResult((Request)tx1019Request);
            String contractFile = StringUtil.getNodeText((String)response, (String)"contractFile");
            byte[] fileBytes = Base64.base64ToByteArray((String)contractFile);
            try {
                String filePath = SIGN_PDF_PATH + "pdf";
                File dir = new File(filePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File file = new File(filePath + File.separator + param.getContractId() + ".pdf");
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(fileBytes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            returnJson.put("ResponseCode", (Object)StringUtil.getNodeText((String)response, (String)"ResponseCode"));
            returnJson.put("ResponseDesc", (Object)StringUtil.getNodeText((String)response, (String)"ResponseDesc"));
            returnJson.put("txId", (Object)StringUtil.getNodeText((String)response, (String)"TxID"));
            returnJson.put("contractFile", (Object)StringUtil.getNodeText((String)response, (String)"contractFile"));
        }
        catch (APIToolKitException e) {
            e.printStackTrace();
        }
        return returnJson;
    }
}

