/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.cmb.util;

import com.hand.app.cmb.util.BCUtil;
import com.hand.app.cmb.util.Sm2Vo;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.encoders.Hex;

public class SM2Util {
    private static final String SM2_KEY_TITLE = "3059301306072a8648ce3d020106082a811ccf5501822d03420004";
    public static final String USER_ID = "1234567812345678";

    public static String sm2Sign(String content, String privateKey) {
        try {
            BCECPrivateKey bcecPrivateKey = BCUtil.getPrivatekeyFromD(new BigInteger(privateKey, 16));
            byte[] sign = BCUtil.signSm3WithSm2(content.getBytes(), USER_ID.getBytes(), (PrivateKey)bcecPrivateKey);
            return SM2Util.encodeBase64(SM2Util.signRawToAsn1(sign));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean sm2Check(String content, String rawSign, String publicKey) {
        try {
            Sm2Vo sm2Vo = SM2Util.parseBase64TRawKey(publicKey);
            if (null == sm2Vo) {
                return false;
            }
            BCECPublicKey bcecPublicKey = BCUtil.getPublickeyFromXY(new BigInteger(sm2Vo.getSm2_x(), 16), new BigInteger(sm2Vo.getSm2_y(), 16));
            byte[] sign = SM2Util.signAsn12Raw(SM2Util.decodeBase64(rawSign));
            return BCUtil.verifySm3WithSm2(content.getBytes(), USER_ID.getBytes(), sign, (PublicKey)bcecPublicKey);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static Sm2Vo parseBase64TRawKey(String sm2Key) {
        if (null == sm2Key) {
            return null;
        }
        String sm2_asn1 = Hex.toHexString((byte[])SM2Util.decodeBase64(sm2Key));
        if (!sm2_asn1.startsWith(SM2_KEY_TITLE)) {
            return null;
        }
        String sm2_xy = sm2_asn1.substring(SM2_KEY_TITLE.length(), sm2_asn1.length());
        String sm2_x = sm2_xy.substring(0, sm2_xy.length() / 2);
        String sm2_y = sm2_xy.substring(sm2_xy.length() / 2, sm2_xy.length());
        return new Sm2Vo(SM2_KEY_TITLE, sm2_x, sm2_y);
    }

    public static void main(String[] args) {
        String sm2_asn1 = "3059301306072A8648CE3D020106082A811CCF5501822D03420004bf552c3a487a87912302ee2dffc6362a9743efb6fe71233efecf174d27c247e089d77bc81de9a1b99577700d667093733339d053840a3fe9f3dbb9b5d26e2f24";
        System.out.println(SM2Util.encodeBase64(Hex.decode((String)sm2_asn1)));
    }

    public static String encodeBase64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.getDecoder().decode(data);
    }

    private static byte[] signRawToAsn1(byte[] bcCipTxt) throws Exception {
        byte[] netSignCipTxt = new byte[73];
        byte[] signR = new byte[32];
        byte[] signS = new byte[32];
        System.arraycopy(bcCipTxt, 0, signR, 0, 32);
        System.arraycopy(bcCipTxt, 32, signS, 0, 32);
        int wPos = 4;
        netSignCipTxt[0] = 48;
        netSignCipTxt[2] = 2;
        if ((signR[0] & 0xFF) >= 128) {
            netSignCipTxt[wPos - 1] = 33;
            netSignCipTxt[wPos] = 0;
            ++wPos;
        } else {
            netSignCipTxt[wPos - 1] = 32;
        }
        System.arraycopy(signR, 0, netSignCipTxt, wPos, 32);
        netSignCipTxt[wPos += 32] = 2;
        ++wPos;
        if ((signS[0] & 0xFF) >= 128) {
            netSignCipTxt[wPos] = 33;
            netSignCipTxt[++wPos] = 0;
            ++wPos;
        } else {
            netSignCipTxt[wPos] = 32;
            ++wPos;
        }
        System.arraycopy(signS, 0, netSignCipTxt, wPos, 32);
        if (70 == (wPos += 32)) {
            netSignCipTxt[1] = 68;
        } else if (71 == wPos) {
            netSignCipTxt[1] = 69;
        } else if (72 == wPos) {
            netSignCipTxt[1] = 70;
        } else {
            throw new Exception("signRawToAsn1 Error!");
        }
        byte[] resultBytes = new byte[wPos];
        System.arraycopy(netSignCipTxt, 0, resultBytes, 0, wPos);
        return resultBytes;
    }

    private static byte[] signAsn12Raw(byte[] signature) throws Exception {
        byte[] resultBytes = new byte[64];
        int wPos = 3;
        if ((signature[wPos] & 0xFF) == 32) {
            ++wPos;
        } else if ((signature[wPos] & 0xFF) == 33) {
            wPos += 2;
        } else {
            throw new Exception("signR length Error!");
        }
        System.arraycopy(signature, wPos, resultBytes, 0, 32);
        wPos += 32;
        if ((signature[++wPos] & 0xFF) == 32) {
            ++wPos;
        } else if ((signature[wPos] & 0xFF) == 33) {
            wPos += 2;
        } else {
            throw new Exception("signS length Error!");
        }
        System.arraycopy(signature, wPos, resultBytes, 32, 32);
        return resultBytes;
    }
}

