/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.hand.app.appManger.bean.SmsInfo;
import com.hand.app.appManger.service.ICaptchaCodeService;
import com.hand.hap.core.IRequest;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CaptchaCodeServiceImpl
implements ICaptchaCodeService {
    private final Logger logger = LoggerFactory.getLogger(CaptchaCodeServiceImpl.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private String category = "app:cache:captcha";
    private String captchaKeyName = "captcha_key";
    private Integer expire = 300;
    static final String product = "Dysmsapi";
    static final String domain = "dysmsapi.aliyuncs.com";
    @Value(value="#{configProperties['aliyun.accessKeyId']}")
    private String accessKeyId;
    @Value(value="#{configProperties['aliyun.accessKeySecret']}")
    private String accessKeySecret;

    public String getCaptchaKeyName() {
        return this.captchaKeyName;
    }

    public void setCaptchaKeyName(String captchaKeyName) {
        this.captchaKeyName = captchaKeyName;
    }

    public Integer getExpire() {
        return this.expire;
    }

    public void setExpire(Integer expire) {
        this.expire = expire;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void setCaptchaCode(String key, String code) {
        this.redisTemplate.opsForValue().set((Object)(this.getCategory() + ":" + key), (Object)code, (long)this.getExpire().intValue(), TimeUnit.SECONDS);
    }

    @Override
    public String getCaptchaCode(String key) {
        String captchaKey = this.getCategory() + ":" + key;
        String captchaCodeInRedis = (String)this.redisTemplate.opsForValue().get((Object)captchaKey);
        return captchaCodeInRedis;
    }

    @Override
    public void removeCaptchaCode(String key) {
        String captchaKey = this.getCategory() + ":" + key;
        this.redisTemplate.execute(connection -> {
            connection.del((byte[][])new byte[][]{captchaKey.getBytes()});
            return null;
        });
    }

    @Override
    public Boolean checkCaptcha(String key, String code) {
        if (code == null) {
            return false;
        }
        String captchaKey = this.getCategory() + ":" + key;
        String captchaCodeInRedis = (String)this.redisTemplate.opsForValue().get((Object)captchaKey);
        return code.equalsIgnoreCase(captchaCodeInRedis);
    }

    @Override
    public JSONObject sendAliyunSms(IRequest iRequest, SmsInfo smsInfo) {
        JSONObject json = new JSONObject();
        this.logger.info("smsInfo:{}", (Object)smsInfo);
        Boolean captchKey = false;
        int code = (int)((Math.random() * 9.0 + 1.0) * 100000.0);
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.accessKeyId, (String)this.accessKeySecret);
        try {
            DefaultProfile.addEndpoint((String)"cn-hangzhou", (String)"cn-hangzhou", (String)product, (String)domain);
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)profile);
            SendSmsRequest request = new SendSmsRequest();
            request.setPhoneNumbers(smsInfo.getPhoneNumber());
            request.setSignName(smsInfo.getSignName());
            request.setTemplateCode(smsInfo.getTemplateCode());
            JSONObject templatePara = smsInfo.getTemplateParam();
            if (templatePara == null || templatePara.isEmpty()) {
                captchKey = true;
                templatePara = new JSONObject();
                templatePara.put("code", (Object)code);
            }
            request.setTemplateParam(templatePara.toString());
            SendSmsResponse sendSmsResponse = (SendSmsResponse)acsClient.getAcsResponse((AcsRequest)request);
            if (sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
                json.put("code", (Object)sendSmsResponse.getCode());
                json.put("message", (Object)sendSmsResponse.getMessage());
                if (captchKey.booleanValue()) {
                    String key = this.getUUID();
                    this.setCaptchaCode(key, code + "");
                    json.put("captchaKey", (Object)key);
                }
            } else {
                this.logger.info("message:{}", (Object)sendSmsResponse.getMessage());
                json.put("code", (Object)"E");
                String message = "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25!";
                if (sendSmsResponse.getCode().equals("isv.BUSINESS_LIMIT_CONTROL")) {
                    message = "\u5f53\u524d\u624b\u673a\u53d1\u9001\u8d85\u51fa\u9650\u5236\u6b21\u6570";
                }
                json.put("message", (Object)message);
            }
        }
        catch (ClientException e) {
            this.logger.info("error:{}", (Object)e.getMessage());
            json.put("code", (Object)e.getMessage());
            json.put("message", (Object)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff01");
        }
        return json;
    }

    public String getUUID() {
        return UUID.randomUUID().toString();
    }
}

