/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.HlsAppVersion;
import com.hand.app.appManger.service.IHlsAppVersionService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class HlsAppVersionController
extends BaseController {
    @Autowired
    private IHlsAppVersionService appVersionService;

    @RequestMapping(value={"/app/add/appVersion"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public ResponseData addAppVersion(HttpServletRequest request, @RequestBody List<HlsAppVersion> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.appVersionService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/app/delete/appVersion"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public int deleteAppVersion(HttpServletRequest request, @RequestBody List<HlsAppVersion> appVersion) {
        return this.appVersionService.batchDelete(appVersion);
    }

    @RequestMapping(value={"/app/query/appVersionAll"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryAllVersion(HlsAppVersion dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.appVersionService.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/app/query/appVersionByCode"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryAppVersionByCode(HttpServletRequest request, @RequestParam(value="appCode") String appCode) {
        IRequest requestContext = this.createRequestContext(request);
        return this.appVersionService.queryAppVersion(requestContext, appCode);
    }
}

