/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppRole;
import com.hand.app.appManger.service.IAppRoleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class AppRoleController
extends BaseController {
    @Autowired
    private IAppRoleService appRoleService;

    @RequestMapping(value={"/app/queryRole"})
    @ResponseBody
    public ResponseData query(AppRole dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.appRoleService.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/app/addRole"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public ResponseData addRole(HttpServletRequest request, @RequestBody List<AppRole> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.appRoleService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/app/deleteRole"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public int deleteRole(HttpServletRequest request, @RequestBody List<AppRole> approle) {
        return this.appRoleService.batchDelete(approle);
    }
}

