/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.appManger.controllers;

import com.codahale.metrics.annotation.Timed;
import com.hand.app.appManger.dto.AppFunction;
import com.hand.app.appManger.service.IAppFunctionService;
import com.hand.app.appManger.service.IAppRoleFunctionService;
import com.hand.app.appManger.service.IRoleModuleService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api", "/"})
public class AppFunctionController
extends BaseController {
    @Autowired
    private IAppFunctionService appFunctionService;
    @Autowired
    private IAppRoleFunctionService appRoleFunctionService;
    @Autowired
    IRoleModuleService roleModuleService;

    @RequestMapping(value={"/app/addFunction"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public ResponseData addFunction(HttpServletRequest request, @RequestBody List<AppFunction> dto, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.appFunctionService.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/app/deleteFunction"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public int deleteFunction(HttpServletRequest request, @RequestBody List<AppFunction> function) {
        return this.appFunctionService.batchDelete(function);
    }

    @RequestMapping(value={"/app/query/moduleFunction"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryModuleFunctionEnable(HttpServletRequest request, @RequestParam(value="moduleId") String moduleId) {
        return this.appRoleFunctionService.getModuleFunction(this.createRequestContext(request), moduleId);
    }

    @RequestMapping(value={"/app/queryModuleAllFunction"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryModuleAllFunction(HttpServletRequest request, @RequestParam(value="moduleId") String moduleId) {
        return this.appRoleFunctionService.getModuleAllFunction(this.createRequestContext(request), moduleId);
    }

    @RequestMapping(value={"/app/queryFunction"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryFunction(HttpServletRequest request, @RequestParam(value="roleCode") String roleCode, @RequestParam(value="appCode") String appCode) {
        return this.appRoleFunctionService.getFunctionAll(this.createRequestContext(request), roleCode, appCode);
    }

    @RequestMapping(value={"/app/queryRoleModule"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryRoleModule(HttpServletRequest request, @RequestParam(value="roleCode") String roleCode, @RequestParam(value="appCode") String appCode) {
        return this.roleModuleService.getRoleModule(this.createRequestContext(request), roleCode, appCode);
    }

    @RequestMapping(value={"/app/queryModuleFunction"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData queryModuleFunction(HttpServletRequest request, @RequestParam(value="roleCode") String roleCode, @RequestParam(value="appCode") String appCode) {
        return this.appFunctionService.getModuleFunction(this.createRequestContext(request), roleCode, appCode);
    }

    @RequestMapping(value={"/app/querySingModuleFunction"}, method={RequestMethod.GET})
    @ResponseBody
    @Timed
    public ResponseData querySingModuleFunction(HttpServletRequest request, @RequestParam(value="moduleId") String moduleId, @RequestParam(value="roleCode") String roleCode, @RequestParam(value="appCode") String appCode) {
        return this.appRoleFunctionService.getSingModuleFunction(this.createRequestContext(request), moduleId, roleCode, appCode);
    }
}

