/*
 * Decompiled with CFR 0.152.
 */
package com.chinapay.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.app.cmb.util.SM2Util;
import com.hand.app.cmb.util.SignatureUtil;
import com.hand.hap.system.dto.BaseDTO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.time.DateUtils;
import org.apache.http.HttpResponse;

public class StringUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String getRelevantDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String getRelevantTime(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static String getEntrstStrDtT(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(date);
        return dateString;
    }

    public static void main(String[] args) throws IOException {
        TreeMap<String, String> requestPublicParams = new TreeMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        requestPublicParams.put("version", "0.0.1");
        requestPublicParams.put("encoding", "UTF-8");
        requestPublicParams.put("signMethod", "02");
        requestPublicParams.put("biz_content", "{\"tradeScene\":\"OFFLINE\",\"orderId\":\"2022042400000390\",\"notifyUrl\":\"http://sign.hitachics.com/core/api/public/cmb/get/qr/code/listen\",\"merId\":\"3089991701201D0\",\"body\":\"\u805a\u5408\u652f\u4ed8\u6d4b\u8bd5\",\"userId\":\"N003574551\",\"payValidTime\":\"900\",\"currencyCode\":\"156\",\"txnAmt\":\"200000\"}");
        String signContent = SignatureUtil.getSignContent(requestPublicParams);
        System.out.println("\u7b7e\u540dsignContent:" + signContent);
        requestPublicParams.put("sign", SM2Util.sm2Sign(signContent, "D5F2AFA24E6BA9071B54A8C9AD735F9A1DE9C4657FA386C09B592694BC118B38"));
        System.out.println(((String)requestPublicParams.get("sign")).toString());
    }

    private static Boolean checkSign(String string) {
        System.out.println("\u8981\u9a8c\u7b7e\u7684\u62a5\u6587\u5185\u5bb9\uff1a" + string);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Map responseBodyMap = (Map)objectMapper.readValue(string, Map.class);
            String sign = (String)responseBodyMap.remove("sign");
            String contentStr = SignatureUtil.getSignContent(responseBodyMap);
            System.out.println("\u9a8c\u7b7econtentStr:" + contentStr);
            boolean result = SM2Util.sm2Check(contentStr, sign, "MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAE6Q+fktsnY9OFP+LpSR5Udbxf5zHCFO0PmOKlFNTxDIGl8jsPbbB/9ET23NV+acSz4FEkzD74sW2iiNVHRLiKHg==");
            if (result) {
                System.out.println("\u62a5\u6587\u9a8c\u7b7e\u6210\u529f!");
            } else {
                System.out.println("\u62a5\u6587\u9a8c\u7b7e\u5931\u8d25!");
            }
            return result;
        }
        catch (Exception e) {
            System.out.println("\u9a8c\u7b7e\u53d1\u751f\u5f02\u5e38\uff01");
            e.printStackTrace();
            return false;
        }
    }

    public static String yearAddNum(Date time, Integer num) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.add(1, num);
        Date newTime = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateString = formatter.format(newTime);
        return dateString;
    }

    public static String pad(String val, String type, int size, String delim) {
        if (StringUtil.isEmpty(val)) {
            return val;
        }
        if ("r".equals(type)) {
            if (val.length() >= size) {
                return val.substring(0, size);
            }
            return val + StringUtil.repeat('r', delim, size - val.length());
        }
        if (val.length() >= size) {
            return val.substring(val.length() - size);
        }
        return StringUtil.repeat('l', delim, size - val.length()) + val;
    }

    public static String repeat(char type, String val, int len) {
        if (StringUtil.isEmpty(val)) {
            return val;
        }
        StringBuffer tBuffer = new StringBuffer();
        while (tBuffer.length() < len) {
            tBuffer.append(val);
        }
        if ('r' == type) {
            return tBuffer.substring(0, len);
        }
        return tBuffer.substring(tBuffer.length() - len);
    }

    public static String paserMaptoStr(Map<String, Object> dataMap) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String parseResponseToStr(HttpResponse httpResonse) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(httpResonse.getEntity().getContent(), "utf-8"));
        StringBuffer sb = new StringBuffer();
        String str = null;
        while ((str = br.readLine()) != null) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static Map<String, String> paserStrToMap(String respStr) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (StringUtil.isNotEmpty(respStr)) {
            String[] strs;
            for (String str : strs = respStr.split("&")) {
                if (StringUtil.isEmpty(str)) continue;
                int index = str.indexOf("=");
                data.put(str.substring(0, index), str.substring(index + 1));
            }
        }
        return data;
    }

    public static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_') {
            startIndex = 1;
        }
        return "set" + fieldName.substring(startIndex, startIndex + 1).toUpperCase() + fieldName.substring(startIndex + 1);
    }

    public static boolean checkSetMet(Method[] methods, String fieldSetMet) {
        for (Method met : methods) {
            if (!fieldSetMet.equals(met.getName())) continue;
            return true;
        }
        return false;
    }

    public static String camel2Underline(String line) {
        if (line == null || "".equals(line)) {
            return "";
        }
        line = String.valueOf(line.charAt(0)).toUpperCase().concat(line.substring(1));
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("[A-Z]([a-z\\d]+)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(word.toUpperCase());
            sb.append(matcher.end() == line.length() ? "" : "_");
        }
        return sb.toString();
    }

    public static Date parseDate(String datestr) {
        if (null == datestr || "".equals(datestr)) {
            return null;
        }
        try {
            String fmtstr = null;
            fmtstr = datestr.indexOf(58) > 0 ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(fmtstr, Locale.UK);
            return sdf.parse(datestr);
        }
        catch (Exception e) {
            Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
            if (pattern.matcher(datestr).matches()) {
                GregorianCalendar c = new GregorianCalendar(1900, 0, -1);
                Date d = c.getTime();
                Date _d = DateUtils.addDays((Date)d, (int)Integer.parseInt(datestr));
                return _d;
            }
            return null;
        }
    }

    public static void setFieldValue4Bean(Object bean, Map<String, String> valMap) {
        block2: for (Class<?> cls = bean.getClass(); cls.getSuperclass() != null && cls != BaseDTO.class; cls = cls.getSuperclass()) {
            for (Field field : cls.getDeclaredFields()) {
                try {
                    Comparable<Date> temp;
                    String value;
                    String fieldSetName = StringUtil.parSetName(field.getName());
                    if (!StringUtil.checkSetMet(cls.getDeclaredMethods(), fieldSetName)) continue;
                    Method fieldSetMet = cls.getMethod(fieldSetName, field.getType());
                    String fieldKeyName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                    if (!Objects.nonNull(valMap.get(fieldKeyName)) || null == (value = String.valueOf(valMap.get(fieldKeyName))) || "".equals(value)) continue;
                    String fieldType = field.getType().getSimpleName();
                    if ("String".equals(fieldType)) {
                        fieldSetMet.invoke(bean, value);
                        continue;
                    }
                    if ("Date".equals(fieldType)) {
                        temp = StringUtil.parseDate(value);
                        fieldSetMet.invoke(bean, temp);
                        continue;
                    }
                    if ("Integer".equals(fieldType) || "int".equals(fieldType)) {
                        Integer intval = Integer.parseInt(value);
                        fieldSetMet.invoke(bean, intval);
                        continue;
                    }
                    if ("Long".equalsIgnoreCase(fieldType)) {
                        temp = Long.parseLong(value);
                        fieldSetMet.invoke(bean, temp);
                        continue;
                    }
                    if ("Double".equalsIgnoreCase(fieldType)) {
                        temp = Double.parseDouble(value);
                        fieldSetMet.invoke(bean, temp);
                        continue;
                    }
                    if ("BigDecimal".equalsIgnoreCase(fieldType)) {
                        BigDecimal bigDecimal = new BigDecimal(value);
                        fieldSetMet.invoke(bean, bigDecimal);
                        continue;
                    }
                    if ("Boolean".equalsIgnoreCase(fieldType)) {
                        temp = Boolean.parseBoolean(value);
                        fieldSetMet.invoke(bean, temp);
                        continue;
                    }
                    System.out.println("not supper type" + fieldType);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue block2;
                }
            }
        }
    }
}

