package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;

@UITag
public class HlsRadioButton extends InputField implements HlsComponent {

    public static final String PROPERTITY_HLSRADIOBUTTON = "hlsRadioButton";
    public static final String PROPERTITY_VALUE = "value";
    public static final String PROPERTITY_ICON = "icon";

    public void setValue(Object value) {
        setPropertity(PROPERTITY_VALUE, value);
    }

    public void setIcon(Object value) {
        setPropertity(PROPERTITY_ICON, value);
    }

    @Override
    public Object getValue() throws Exception {
        return getPrototype().getString(PROPERTITY_VALUE);
    }

    public Object getIcon() throws Exception {
        return getPrototype().getString(PROPERTITY_ICON);
    }

    public static HlsRadioButton createInstance() {
        XMap view = new XMap(DEFAULT_TAG_PREFIX, DEFAULT_NAME_SPACE,
                PROPERTITY_HLSRADIOBUTTON);
        HlsRadioButton hlsRadioButton = new HlsRadioButton();
        hlsRadioButton.initPrototype(view);
        return hlsRadioButton;
    }

    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_PROMPTCOLSPAN, getPromptColspan());
        context.put(PROPERTITY_PROMPT, getPrompt());
        context.put(PROPERTITY_HLSCLASSNAME, getHlsClassName());
        context.put(PROPERTITY_PROMPTCLASSNAME, getPromptClassName());
        context.put(PROPERTITY_PRMOPTIMAGE, getPromptImage());
        context.put(PROPERTITY_BINDMODEL, getHlsBindModel());
        context.put(PROPERTITY_COLSPAN, getColSpan());
        context.put(PROPERTITY_VALUE, getValue());
        context.put(PROPERTITY_VALIDATIONMESSAGE, getValidationMessage());
        context.put(PROPERTITY_DATAMODELNAME, getDataField(PROPERTITY_DATAMODELNAME));
        context.put(PROPERTITY_DATAFIELDNAME, getDataField(PROPERTITY_DATAFIELDNAME));
    }

    @Override
    public void hlsSetPropertity(Object key, Object value) {
        super.setPropertity(key, value);
    }
}
