package com.hand.app.zhongDengWang.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.app.zhongDengWang.service.IFndZhongDengHeadsService;
import com.hand.app.zhongDengWang.service.IZdwWsRequestsService;
import com.hand.app.zhongDengWang.dto.ZdwLoginTokenInterface;
import com.hand.app.zhongDengWang.dto.FndZhongDengHeads;
import com.hand.app.zhongDengWang.dto.FndZhongDengLines;
import com.hand.app.zhongDengWang.dto.FndZhongDengBatch;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.service.IZdwWsRequestsService;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.app.zhongDengWang.service.IFndZhongDengLinesService;
import com.hand.app.zhongDengWang.mapper.ZdwLoginTokenInterfaceMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengHeadsMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengLinesMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengBatchMapper;
import com.hand.app.zhongDengWang.utils.ClientUtils;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterService;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterServiceService;
import com.hand.app.zhongDengWang.ws.terminate.WSTerminateRegisterService;
import com.hand.app.zhongDengWang.ws.terminate.WSTerminateRegisterServiceService;
import com.hand.app.zhongDengWang.ws.amend.WSAmendRegisterService;
import com.hand.app.zhongDengWang.ws.amend.WSAmendRegisterServiceService;
import com.hand.app.zhongDengWang.ws.extend.WSExtendRegisterService;
import com.hand.app.zhongDengWang.ws.extend.WSExtendRegisterServiceService;
import com.hand.app.zhongDengWang.ws.login.WSLoginService;
import com.hand.app.zhongDengWang.ws.login.WSLoginServiceService;
import com.hand.app.zhongDengWang.dto.FndAtmAttachmentDto;
import com.hand.app.zhongDengWang.mapper.FndAtmAttachmentMapper;
import com.hand.hap.core.IRequest;
import com.hand.hap.lock.components.DatabaseLockProvider;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOStatus;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.rfp.sm.utils.SM2Utils;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Service
public class ZdwWsRequestsServiceImpl implements IZdwWsRequestsService {

    @Autowired
    ZdwLoginTokenInterfaceMapper zdwLoginTokenInterfaceMapper;
    @Autowired
    FndZhongDengHeadsMapper fndZhongDengHeadsMapper;
    @Autowired
    FndZhongDengLinesMapper fndZhongDengLinesMapper;
    @Autowired
    IFndZhongDengHeadsService fndZhongDengHeadsService;
    @Autowired
    IFndZhongDengLinesService fndZhongDengLinesService;
    @Autowired
    IZdwWsRequestsService zdwWsRequestsService;
    @Autowired
    HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    FndAtmAttachmentMapper fndAtmAttachmentMapper;
    @Autowired
    FndZhongDengBatchMapper fndZhongDengBatchMapper;
    @Autowired
    private DatabaseLockProvider databaseLockProvider;


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /**
     * Use private final lock objects to synchronize classes that may interact with untrusted code
     */
    private final Object lock = new Object();


    @Value("${zdw.login.clientKey}")
    private String clientKey;
    @Value("${zdw.login.userName}")
    private String userName;
    @Value("${zdw.login.password}")
    private String userPassword;
    @Value("${zdw.login.authCode}")
    private String platformAuthCode;

    private String loginToken;

    /**
     * 加密公钥 String clientKey
     * 用户名 String userName
     * 密码  String userPassword
     * 平台授权码 String platformAuthCode
     **/
    public String clintLogin(String clientKey, String userName, String userPassword, String platformAuthCode) {
        String returnMsg = "";
        String encryUserName = "";
        String encryUserPassword = "";
        String encryPlatformAuthCode = "";

        try {
            /*SM2算法加密*/
            encryUserName = SM2Utils.encryptByKeyStr(userName, clientKey);
            encryUserPassword = SM2Utils.encryptByKeyStr(userPassword, clientKey);
            encryPlatformAuthCode = SM2Utils.encryptByKeyStr(platformAuthCode, clientKey);
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
        WSLoginServiceService service = new WSLoginServiceService();
        WSLoginService login = service.getWSLoginServicePort();
        /*插入接口日志表*/
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = createRequestLog(service.getWSDLDocumentLocation().toString(), "userName:" + userName + ";userPassword:" + userPassword + ";platformAuthCode:" + platformAuthCode, null);

        try {
            byte[] returns = login.login(encryUserName.getBytes(), encryUserPassword.getBytes(), encryPlatformAuthCode.getBytes());
            returnMsg = new String(returns, "UTF-8");
            logger.info("get token success token: {}", returnMsg);
        } catch (Exception e) {
            e.printStackTrace();
            returnMsg = "LoginError";
            logger.info("get token fail message: {}", e.getMessage());
        }
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return returnMsg;
    }

    private String getRegisterToken() {

        //获取token，后台设置每25分钟重置一次token
        ZdwLoginTokenInterface zdwLoginTokenInterface = new ZdwLoginTokenInterface();
        zdwLoginTokenInterface.setEnableFlag("Y");
        zdwLoginTokenInterface = zdwLoginTokenInterfaceMapper.selectOne(zdwLoginTokenInterface);

        String assesstoken = "";

        if (Objects.isNull(zdwLoginTokenInterface)) {
            assesstoken = clintLogin(clientKey, userName, userPassword, platformAuthCode);
            //assesstoken = "cs11111111";
            if (!assesstoken.contains("Error")) {
                zdwLoginTokenInterfaceMapper.updateToken(assesstoken);
            }
        } else {
            assesstoken = zdwLoginTokenInterface.getToken();
        }

        return assesstoken;
    }


    private HlsWsRequests createRequestLog(String wsdlUrl, String requestClob, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(wsdlUrl);
        hlsWsRequests.setFunctionName("INIT_REGISTER");
        hlsWsRequests.setRequestClob(requestClob);
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setParameterType("XML");
        hlsWsRequests.setPkValue(pkValue);

        hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }

    /**
     * 设置错误信息
     *
     * @param resultJson    返回给前端的结果集
     * @param hlsWsRequests 储存给数据库的请求体
     * @param e             异常
     */
    public void setErrData(JSONObject resultJson, HlsWsRequests hlsWsRequests, Exception e) {
        resultJson.put("code", "-1");
        resultJson.put("info", "请求失败：" + e.getMessage());
        hlsWsRequests.setReturnStatus("E");
        hlsWsRequests.setResponsedDate(new Date());
    }

    /**
     * 设置返回信息
     *
     * @param resultJson    返回给前端的结果集
     * @param hlsWsRequests 储存给数据库的请求体
     * @param resData       返回字符串
     */
    public void setResData(JSONObject resultJson, HlsWsRequests hlsWsRequests, String resData) {
        resultJson.put("code", "0");
        resultJson.put("info", resData);
        hlsWsRequests.setReturnStatus("S");
        hlsWsRequests.setResponseClob(resData);
        hlsWsRequests.setResponsedDate(new Date());
    }

    /*初始登记*/
    public JSONObject registerInit(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        JSONObject resultJson = new JSONObject();

        //WS服务初始化
        WSInitRegisterServiceService service = new WSInitRegisterServiceService();
        WSInitRegisterService reg = service.getWSInitRegisterServicePort();

        /*插入接口日志表*/
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());
        try {
            /*SM2算法加密*/
            String encryXmlFileContent = SM2Utils.encryptByKeyStr(xmlFileContent, clientKey);
            String encryLoginToken = SM2Utils.encryptByKeyStr(loginToken, clientKey);
            String attachmentZipPath = "";
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr(platformAuthCode, clientKey);

            /*发送初始登记接口请求*/
            byte[] returns = reg.initRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(), encryLoginToken.getBytes(), attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes(), ClientUtils.getAttachmentZip(attachmentZipPath));

            String resData = new String(returns, "UTF-8");
            setResData(resultJson, hlsWsRequests, resData);
            logger.info("register init success line_id:{}, returns: {}", line.getLineId(), resData);
        } catch (Exception e) {
            e.printStackTrace();
            setErrData(resultJson, hlsWsRequests, e);
            logger.info("register init fail line_id:{},message: {}", line.getLineId(), e.getMessage());
        }

        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    /*变更登记*/
    public JSONObject registerAmend(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengHeads heads, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        JSONObject resultJson = new JSONObject();

        //WS服务初始化
        WSAmendRegisterServiceService service = new WSAmendRegisterServiceService();
        WSAmendRegisterService amend = service.getWSAmendRegisterServicePort();

        //插入接口日志表
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());

        try {
            /*SM2算法加密*/
            String encryLoginToken = SM2Utils.encryptByKeyStr(loginToken, clientKey);
            String encryXmlFileContent = SM2Utils.encryptByKeyStr(xmlFileContent, clientKey);
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr(platformAuthCode, clientKey);
            String encryAuthorizationCode = SM2Utils.encryptByKeyStr(heads.getAuthorizationCode(), clientKey);
            String encryRegisterCode = SM2Utils.encryptByKeyStr(heads.getInitRegisterNumber(), clientKey);
            String attachmentZipPath = "";

            /*发送变更登记接口请求*/
            byte[] returns = amend.amendRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(),
                    encryLoginToken.getBytes(), encryRegisterCode.getBytes(), encryAuthorizationCode.getBytes(),
                    attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes(),
                    ClientUtils.getAttachmentZip(attachmentZipPath));

            String resData = new String(returns, "UTF-8");
            setResData(resultJson, hlsWsRequests, resData);

            logger.info("register amend success line_id:{},returns: {}", line.getLineId(), resData);

        } catch (Exception e) {
            e.printStackTrace();
            setErrData(resultJson, hlsWsRequests, e);
            logger.info("register amend fail line_id:{},message: {}", line.getLineId(), e.getMessage());
        }

        //返回结果 给数据库和前端
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    /*展期登记*/
    public JSONObject registerExtend(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengHeads heads, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        JSONObject resultJson = new JSONObject();
        //WS服务初始化
        WSExtendRegisterServiceService service = new WSExtendRegisterServiceService();
        WSExtendRegisterService extend = service.getWSExtendRegisterServicePort();

        //插入接口日志表
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());

        try {
            /*SM2算法加密*/
            String encryLoginToken = SM2Utils.encryptByKeyStr(loginToken, clientKey);
            String encryXmlFileContent = SM2Utils.encryptByKeyStr(xmlFileContent, clientKey);
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr(platformAuthCode, clientKey);
            String encryAuthorizationCode = SM2Utils.encryptByKeyStr(heads.getAuthorizationCode(), clientKey);
            String encryRegisterCode = SM2Utils.encryptByKeyStr(heads.getInitRegisterNumber(), clientKey);
            String attachmentZipPath = "";

            /*发送展期登记接口请求*/
            byte[] returns = extend.extendRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(),
                    encryLoginToken.getBytes(), encryRegisterCode.getBytes(), encryAuthorizationCode.getBytes(),
                    attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes(),
                    ClientUtils.getAttachmentZip(attachmentZipPath));

            String resData = new String(returns, "UTF-8");
            setResData(resultJson, hlsWsRequests, resData);
            logger.info("register extend success line_id:{},returns: {}", line.getLineId(), resData);
        } catch (Exception e) {
            e.printStackTrace();
            setErrData(resultJson, hlsWsRequests, e);
            logger.info("register extend fail line_id:{},message: {}", line.getLineId(), e.getMessage());
        }

        //返回结果 给数据库和前端
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    /*注销登记*/
    public JSONObject registerTerminate(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengHeads heads, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        JSONObject resultJson = new JSONObject();
        //WS服务初始化
        WSTerminateRegisterServiceService service = new WSTerminateRegisterServiceService();
        WSTerminateRegisterService terminate = service.getWSTerminateRegisterServicePort();

        //插入接口日志表
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());

        try {
            /*SM2算法加密*/
            String encryLoginToken = SM2Utils.encryptByKeyStr(loginToken, clientKey);
            String encryXmlFileContent = SM2Utils.encryptByKeyStr(xmlFileContent, clientKey);
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr(platformAuthCode, clientKey);
            String encryAuthorizationCode = SM2Utils.encryptByKeyStr(heads.getAuthorizationCode(), clientKey);
            String encryRegisterCode = SM2Utils.encryptByKeyStr(heads.getInitRegisterNumber(), clientKey);

            /*发送注销登记接口请求*/
            byte[] returns = terminate.terminateRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(),
                    encryLoginToken.getBytes(), encryRegisterCode.getBytes(), encryAuthorizationCode.getBytes(),
                    attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes());

            String resData = new String(returns, "UTF-8");
            setResData(resultJson, hlsWsRequests, resData);
            logger.info("register terminate success line_id:{},returns: {}", line.getLineId(), resData);
        } catch (Exception e) {
            e.printStackTrace();
            setErrData(resultJson, hlsWsRequests, e);
            logger.info("register terminate fail line_id:{},message: {}", line.getLineId(), e.getMessage());
        }

        //返回结果 给数据库和前端
        hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }


    /***
     * 融资租赁-登记入口方法;
     * @param
     * @param
     ***/
    public void registerThread(IRequest request, List<FndZhongDengBatch> fndZhongDengBatches, String loginToken) {
        JSONObject resultJson = new JSONObject();
        List<FndZhongDengLines> fndZhongDengLinesList = new ArrayList<>();
        List<FndZhongDengHeads> fndZhongDengHeadsList = new ArrayList<>();
        /*根据传入ids循环上报中登网*/
        synchronized (lock) {
            for (FndZhongDengBatch batch : fndZhongDengBatches) {
                /*根据批次id获取该批次下所有上报行id*/
                FndZhongDengLines fndZhongDengLines = new FndZhongDengLines();
                fndZhongDengLines.setLineId(batch.getLineId());
                fndZhongDengLines = fndZhongDengLinesMapper.selectByPrimaryKey(fndZhongDengLines);


                if (Objects.nonNull(fndZhongDengLines) && "UPING".equalsIgnoreCase(fndZhongDengLines.getUpStatus()) && "NORMAL".equalsIgnoreCase(fndZhongDengLines.getDataClass())) {
                    try {
                        FndZhongDengHeads fndZhongDengHeads = new FndZhongDengHeads();
                        fndZhongDengHeads.setHeadId(fndZhongDengLines.getHeadId());
                        fndZhongDengHeads = fndZhongDengHeadsMapper.selectByPrimaryKey(fndZhongDengHeads);

                        /*获取xml报文文件所在路径*/
                        FndAtmAttachmentDto fndAtmAttachmentDto = new FndAtmAttachmentDto();
                        fndAtmAttachmentDto.setAttachmentId(fndZhongDengLines.getAttachmentXmlId());
                        fndAtmAttachmentDto = fndAtmAttachmentMapper.selectByPrimaryKey(fndAtmAttachmentDto);

                        /*解析xml文件内容*/
                        String xmlFileContent = new String(Objects.requireNonNull(ClientUtils.getxmlFileContent(fndAtmAttachmentDto.getFilePath())), "UTF-8");

                        /*初始登记*/
                        if ("01".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                            resultJson = registerInit(platformAuthCode, loginToken, xmlFileContent, fndZhongDengLines, fndAtmAttachmentDto);
                        } else if ("02".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                            resultJson = registerAmend(platformAuthCode, loginToken, xmlFileContent, fndZhongDengHeads, fndZhongDengLines, fndAtmAttachmentDto);
                        } else if ("03".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                            resultJson = registerExtend(platformAuthCode, loginToken, xmlFileContent, fndZhongDengHeads, fndZhongDengLines, fndAtmAttachmentDto);
                        } else if ("05".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                            resultJson = registerTerminate(platformAuthCode, loginToken, xmlFileContent, fndZhongDengHeads, fndZhongDengLines, fndAtmAttachmentDto);
                        }

                        String returns = "";
                        if ("0".equalsIgnoreCase(resultJson.getString("code"))) {
                            returns = resultJson.getString("info");
                        } else {
                            returns = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                                    "<feedback>\n" +
                                    "\t<registertype>" + fndZhongDengLines.getUpStage() + "</registertype>\n" +
                                    "\t<registerresult>002</registerresult>\n" +
                                    "\t<errors>\n" +
                                    "\t\t<error>" + resultJson.getString("info") + "</error>\n" +
                                    "\t</errors>\n" +
                                    "</feedback>";
                        }

                        /*解析接口返回结果*/
                        org.json.JSONObject returnJson = XML.toJSONObject(returns);
                        String registerResult = returnJson.getJSONObject("feedback").getString("registerresult");

                        /*成功*/
                        if (Objects.nonNull(registerResult) && "001".equalsIgnoreCase(registerResult)) {

                            /*回写登记报文号registernumber*/
                            if (!returnJson.getJSONObject("feedback").isNull("registernumber")) {
                                String registerNumber = returnJson.getJSONObject("feedback").getString("registernumber");
                                fndZhongDengLines.setRegisterNumber(registerNumber);
                                /*初始登记*/
                                if ("01".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setInitRegisterNumber(registerNumber);
                                } else if ("02".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setAmendRegisterNumber(registerNumber);
                                } else if ("03".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setExtendRegisterNumber(registerNumber);
                                } else if ("05".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                    fndZhongDengHeads.setAbolishRegisterNumber(registerNumber);
                                }
                            }
                            /*回写修改码authorizationcode*/
                            if (!returnJson.getJSONObject("feedback").isNull("authorizationcode")) {
                                String authorizationCode = returnJson.getJSONObject("feedback").getString("authorizationcode");
                                fndZhongDengLines.setAuthorizationCode(authorizationCode);
                                fndZhongDengHeads.setAuthorizationCode(authorizationCode);
                            }
                            fndZhongDengHeads.set__status(DTOStatus.UPDATE);
                            fndZhongDengHeadsList.add(fndZhongDengHeads);
                            fndZhongDengLines.setUpStatus("SUCCESS");
                            fndZhongDengLines.setReturnMsg("上报成功");
                            /*失败*/
                        } else {
                            String error = returnJson.getJSONObject("feedback").getJSONObject("errors").toString();
                            fndZhongDengLines.setUpStatus("FAIL");
                            fndZhongDengLines.setReturnMsg(error);
                        }

                    } catch (RuntimeException e) {
                        e.printStackTrace();
                        fndZhongDengLines.setUpStatus("FAIL");
                        fndZhongDengLines.setReturnMsg(e.getMessage());
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                        fndZhongDengLines.setUpStatus("FAIL");
                        fndZhongDengLines.setReturnMsg(e.getMessage());
                    }
                    fndZhongDengLines.setUpDate(new Date());
                    fndZhongDengLines.set__status(DTOStatus.UPDATE);
                    fndZhongDengLinesList.add(fndZhongDengLines);
                }
            }

            if (fndZhongDengHeadsList.size() > 0) {
                fndZhongDengHeadsService.batchUpdate(request, fndZhongDengHeadsList);
            }
            if (fndZhongDengLinesList.size() > 0) {
                fndZhongDengLinesService.batchUpdate(request, fndZhongDengLinesList);
            }
        }
    }

    /***
     * 融资租赁-登记入口方法;
     * @param request
     * @param params
     ***/
    @Override
    public JSONObject initRegisterService(IRequest request, JSONObject params) {
        JSONObject resultJson = new JSONObject();

        Long batchId=params.getLongValue("batchId");
        if(Objects.isNull(batchId)){
            resultJson.put("code", "001");
            resultJson.put("info", "必须传入参数batchId缺失，请检查");
            return resultJson;
        }

        /*根据批次ID获取所有上报请求id*/
        List<FndZhongDengBatch> fndZhongDengBatches = new ArrayList<>();
        FndZhongDengBatch fndZhongDengBatch = new FndZhongDengBatch();
        fndZhongDengBatch.setBatchId(batchId);
        fndZhongDengBatches = fndZhongDengBatchMapper.select(fndZhongDengBatch);


        if (fndZhongDengBatches.size() == 0) {
            resultJson.put("code", "000");
            resultJson.put("info", "000");
            return resultJson;
        }

        /*获取中登网登录loginToken*/
        loginToken = getRegisterToken();
        /*返回结果loginToken解析，如果返回异常退出当前请求*/
        if (loginToken.contains("Error")) {
            String errorCode = "-1";
            String errorInfo = "-1";
            if (errorCode.contains(":")) {
                errorCode = loginToken.split(":")[1];
                if (errorCode.contains("_")) {
                    errorCode = loginToken.split("_")[0];
                    errorInfo = loginToken.split("_")[1];
                }
            }

            resultJson.put("code", errorCode);
            resultJson.put("info", errorInfo);
        } else {

            final List<FndZhongDengBatch> fndZhongDengBatchList = fndZhongDengBatches;

            /*启用新线程进行异步处理中登网接口请求*/
            ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
            cachedThreadPool.execute(new Runnable() {
                @Override
                public void run() {
                    // do
                    try {
                        registerThread(request, fndZhongDengBatchList, loginToken);
                    } catch (Exception e) {
                        // TODO Auto-generated catch block
                        e.printStackTrace();
                    }
                }
            });
            /*关闭线程*/
            cachedThreadPool.shutdown();
//            List<FndZhongDengLines> fndZhongDengLinesList = new ArrayList<>();
//            /*根据传入ids循环上报中登网*/
//            for (FndZhongDengBatch batch : fndZhongDengBatches) {
//
//                FndZhongDengLines fndZhongDengLines = new FndZhongDengLines();
//                fndZhongDengLines.setLineId(batch.getLineId());
//                fndZhongDengLines = fndZhongDengLinesMapper.selectByPrimaryKey(fndZhongDengLines);
//
//                if (Objects.nonNull(fndZhongDengLines) && "UPING".equalsIgnoreCase(fndZhongDengLines.getUpStatus())) {
//                    String xmlFileContent = "";
//                    String attachmentZipPath = "";
//                    try {
//                        String registerResult = "";
//                        String registerNumber = "";
//                        String authorizationCode = "";
//                        String error = "";
//                        org.json.JSONObject returnJson;
//
//                        FndAtmAttachmentDto fndAtmAttachmentDto = new FndAtmAttachmentDto();
//                        fndAtmAttachmentDto.setAttachmentId(fndZhongDengLines.getAttachmentXmlId());
//                        fndAtmAttachmentDto = fndAtmAttachmentMapper.selectByPrimaryKey(fndAtmAttachmentDto);
//
//                        /*解析xml文件内容*/
//                        xmlFileContent = new String(ClientUtils.getxmlFileContent(fndAtmAttachmentDto.getFilePath()));
//
//                        /*插入接口日志表*/
//                        if ("01".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
//                            resultJson = registerInit(fndZhongDengLines.getTypebz(), platformAuthCode, loginToken, fndAtmAttachmentDto.getFileName(), xmlFileContent, fndZhongDengLines.getLineId());
//                        }
//                        String returns = "";
//                        if ("0".equalsIgnoreCase(resultJson.getString("code"))) {
//                            returns = resultJson.getString("info");
//                        } else {
//                            returns = "<feedback>\n<registertype>LR</registertype>\n<registerresult>001</registerresult>\n<registernumber>I0000001</registernumber>\n<authorizationcode>A0000001</authorizationcode>\n<errors>\n<error>\n" + resultJson.getString("info") + "</error>\n</errors>\n</feedback>\n";
//                        }
//
//                        /*解析接口返回结果*/
//                        returnJson = XML.toJSONObject(returns);
//                        registerResult = returnJson.getJSONObject("feedback").getString("registerresult");
//                        registerNumber = returnJson.getJSONObject("feedback").getString("registernumber");
//                        authorizationCode = returnJson.getJSONObject("feedback").getString("authorizationcode");
//
//                        /*成功*/
//                        if (Objects.nonNull(registerResult) && "001".equalsIgnoreCase(registerResult)) {
//                            fndZhongDengLines.setRegisterNumber(registerNumber);
//                            fndZhongDengLines.setAuthorizationCode(authorizationCode);
//                            fndZhongDengLines.setUpStatus("SUCCESS");
//                            fndZhongDengLines.setReturnMsg("上报成功");
//                            /*失败*/
//                        } else {
//                            error = returnJson.getJSONObject("feedback").getString("errors");
//                            fndZhongDengLines.setUpStatus("FAIL");
//                            fndZhongDengLines.setReturnMsg(error);
//                        }
//
//                        fndZhongDengLines.setUpDate(new Date());
//                        fndZhongDengLines.set__status(DTOStatus.UPDATE);
//
//                        System.out.println("dddd" + new String(returns));
//                    } catch (Exception e) {
//                        // TODO Auto-generated catch block
//                        e.printStackTrace();
//                        fndZhongDengLines.setUpStatus("FAIL");
//                        fndZhongDengLines.setReturnMsg(e.getMessage());
//                    }
//
//                    fndZhongDengLinesList.add(fndZhongDengLines);
//                }
//
//            }
//
//            if (fndZhongDengLinesList.size() > 0) {
//                fndZhongDengLinesService.batchUpdate(request, fndZhongDengLinesList);
//            }

            resultJson.put("code", "000");
            resultJson.put("info", "000");
        }
        return resultJson;
    }


}