package com.hand.app.sms.utils;

import com.google.gson.reflect.TypeToken;
import com.hand.app.sms.dto.ResponseData;
import com.hand.app.sms.dto.SmsResponse;
import com.hand.app.sms.utils.http.*;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @author: Eugene Song
 * @date: 2023/6/12
 * @description:
 */
public class Test {



    /**
     * 发送批次短信
     */
    private static void setSms(String appId, String sign, String timestamp, String host, String content, String mobiles, String customSmsId, String extendedCode, String timerTime) {
        System.out.println("============= setSms==================");
        Map<String, String> params = new HashMap<String, String>();
        try {
            params.put("appId", appId);
            params.put("sign", sign);
            params.put("timestamp", timestamp);
            params.put("mobiles", mobiles);
            params.put("content", URLEncoder.encode(content, "utf-8"));
            if (customSmsId != null) {
                params.put("customSmsId", customSmsId);
            }
            if (timerTime != null) {
                params.put("timerTime", timerTime);
            }
            if (extendedCode != null) {
                params.put("extendedCode", extendedCode);
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String json = request(params, host + "/simpleinter/sendSMS");
        if (json != null) {
            ResponseData<SmsResponse[]> data = JsonHelper.fromJson(new TypeToken<ResponseData<SmsResponse[]>>() {
            }, json);
            String code = data.getCode();
            if ("SUCCESS".equals(code)) {
                for (SmsResponse d : data.getData()) {
                    System.out.println("data:" + d.getMobile() + "," + d.getSmsId() + "," + d.getCustomSmsId());
                }
            }
        }
        System.out.println("=============end setSms==================");
    }



    /**
     * 公共请求方法
     */
    public static String request(Map<String, String> params, String url) {
        HttpRequestParams<Map<String, String>> requestparams = new HttpRequestParams<Map<String, String>>();
        requestparams.setCharSet("UTF-8");
        requestparams.setMethod("POST");
        requestparams.setParams(params);
        requestparams.setUrl(url);
        HttpRequest<Map<String, String>> request;
        if (url.startsWith("https://")) {
            request = new HttpsRequestKV(requestparams, null);
        } else {
            request = new HttpRequestKV(requestparams);
        }
        HttpClient client = new HttpClient();
        String json = null;
        try {
            String mapst = "";
            for (String key : params.keySet()) {
                String value = params.get(key);
                mapst += key + "=" + value + "&";
            }
            mapst = mapst.substring(0, mapst.length() - 1);
            System.out.println("request params: " + mapst);
            HttpResponseString res = client.service(request, new HttpResponseStringPraser());
            if (res == null) {
                System.err.println("请求接口异常");
                return null;
            }
            if (res.getResultCode().equals(HttpResultCode.SUCCESS)) {
                if (res.getHttpCode() == 200) {
                    json = res.getResult();
                    System.out.println("response json: " + json);
                } else {
                    System.out.println("请求接口异常,请求码:" + res.getHttpCode());
                }
            } else {
                System.out.println("请求接口网络异常:" + res.getResultCode().getCode());
            }
        } catch (Exception e) {
            System.err.println("解析失败");
            e.printStackTrace();
        }
        return json;
    }

    public static void main(String[] args) {
        //账号：EUCP-EMY-SMS0-0CBEG 密码：832D74316E2SY30G
        // appId
        String appId = "EUCP-EMY-SMS0-0CBEG";// 请联系销售，或者在页面中 获取
        // 密钥
        String secretKey = "832D74316E2SY30G";// 请联系销售，或者在页面中 获取
        // 接口地址
        String host = "http://www.btom.cn:8080";// 请联系销售获取
        // 时间戳
        String timestamp = DateUtil.toString(new Date(), "yyyyMMddHHmmss");
        // 签名
        String sign = Md5.md5((appId + secretKey + timestamp).getBytes());

        // 发送批次短信,定时时间格式yyyyMMddHHmmss
        setSms(appId, sign, timestamp, host, "【某某公司】你好今天天气不错，挺风和日丽的&1=D$", "18502741388", "839273940", null, null);// 如果通道已绑定签名，可以去掉【某某公司】

    }
}
