package com.hand.app.sms.service.impl;

import com.hand.app.sms.service.IHclcSmsLogService;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.service.IHlsWsRequestsService;
import com.hand.hap.core.IRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @author: Eugene Song
 * @date: 2023/6/12
 * @description:
 */
@Service
public class HclcSmsLogServiceImpl implements IHclcSmsLogService {
    @Autowired
    private IHlsWsRequestsService hlsWsRequestsService;

    @Override
    public HlsWsRequests createLog(IRequest iRequest, String functionName, String url, String request, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(url);
        hlsWsRequests.setFunctionName(functionName);
        hlsWsRequests.setStatusCode("1");
        hlsWsRequests.setStatusDate(new Date());
        //手机号
        hlsWsRequests.setPkValue(pkValue);
        hlsWsRequests.setRequestClob(request);
        hlsWsRequests = hlsWsRequestsService.insertSelective(iRequest, hlsWsRequests);
        return hlsWsRequests;

    }

    @Override
    public HlsWsRequests updateLog(IRequest iRequest, HlsWsRequests hlsWsRequests, String statusCode, String returnStatus, String response) {
        hlsWsRequests.setStatusCode(statusCode);
        hlsWsRequests.setReturnStatus(returnStatus);
        hlsWsRequests.setResponseClob(response);
        hlsWsRequests.setResponsedDate(new Date());
        hlsWsRequests = hlsWsRequestsService.updateByPrimaryKeySelective(iRequest, hlsWsRequests);
        return hlsWsRequests;
    }
}
