package com.hand.app.hms.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.app.hms.dto.HmsThirdpartyApp;
import com.hand.app.hms.service.IHmsThirdpartyAppService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Controller
@RequestMapping("/app/third_procedure")
public class HmsThirdpartyController extends BaseController {

    @Autowired
    private IHmsThirdpartyAppService service;

    /**
     * 根据Id同步当前第三方信息
     *
     * @param request
     * @param  ID 第三方程序插表id
     * @return responseData
     */
//    @RequestMapping(value = "/synchronizeContacts")
//    @ResponseBody
//    public ResponseData synchronizeData(HttpServletRequest request, Long id) {
//        IRequest requestContext = createRequestContext(request);
//        return service.synchronizeData(requestContext, id);
//    }

    @RequestMapping(value = "/query")
    @ResponseBody
    public ResponseData query(HmsThirdpartyApp dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value = "/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<HmsThirdpartyApp> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<HmsThirdpartyApp> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }
}